# CloudNativePG PostgreSQL Cluster for CP4BA

This repository contains Kubernetes manifests for deploying a CloudNativePG (CNPG) PostgreSQL cluster specifically configured for IBM Cloud Pak for Business Automation on OpenShift.

## Overview

The setup creates a highly available PostgreSQL cluster with:
- **3 instances** for high availability and load distribution
- **7 dedicated databases** for different CP4BA components
- **Custom tablespaces** with optimized storage layout
- **Secure authentication** with dedicated users per component
- **Performance tuning** optimized for CP4BA workloads

## Architecture

### Core Components
- **Primary Cluster**: 3-node PostgreSQL cluster with automatic failover
- **Database Isolation**: Each CP4BA component has its own database and user
- **Storage Strategy**: Separate RBD storage for data and CephFS for WAL
- **Security**: Role-based access with minimal privilege principle

### Database Structure
| Component | Database | User | Tablespace | Purpose |
|-----------|----------|------|------------|---------|
| GCD | `gcd` | `gcd_user` | `gcd_ts` | IBM Business Automation Navigator |
| ICN | `icn` | `icn_user` | `icn_ts` | IBM Content Navigator |
| DOS | `dos` | `dos_user` | `dos_ts` | Document Object Store |
| TOS | `tos` | `tos_user` | `tos_ts` | Task Object Store |
| BAW | `baw` | `baw_user` | `baw_ts` | Business Automation Workflow |
| DOCS | `docs` | `docs_user` | `docs_ts` | Content Services |
| OS1 | `os1` | `os1_user` | `os1_ts` | Object Store 1 |

## Deployment Guide

### Prerequisites
- OpenShift cluster with CNPG operator installed
- Storage classes: `ocs-storagecluster-ceph-rbd` and `ocs-storagecluster-cephfs`
- Sufficient resources: 6 CPU cores, 12GB RAM, 45GB storage

### Step 1: Create Namespace
```bash
oc new-project cp4ba-db
```

### Step 2: Deploy Base Configuration
```bash
# Deploy credentials (contains all passwords)
oc apply -f cp4ba-db-credentials.yml

# Deploy PostgreSQL configuration
oc apply -f cp4ba-postgresql-config.yml

# Deploy initialization scripts
oc apply -f cp4ba-initdb-scripts.yml

# Create service endpoint
oc apply -f cp4ba-postgresql-svc.yml
```

### Step 3: Deploy PostgreSQL Cluster
```bash
# Deploy the main cluster
oc apply -f cp4ba-postgresql.yml

# Wait for cluster to be ready
oc wait --for=condition=ready cluster/cp4ba-postgresql -n cp4ba-db --timeout=600s
```

### Step 4: Setup Tablespaces
```bash
# Create RBAC for tablespace operations
oc apply -f cp4ba-tablespace-rbac.yml

# Create tablespace directories
oc apply -f create-tablespace-dirs.yml

# Create tablespaces
oc apply -f create-tablespaces.yml

# Wait for jobs to complete
oc wait --for=condition=complete job/create-tablespace-dirs -n cp4ba-db --timeout=300s
oc wait --for=condition=complete job/create-tablespaces -n cp4ba-db --timeout=300s
```

## Monitoring and Verification

### Check Cluster Status
```bash
# View cluster health
oc get cluster -n cp4ba-db

# Check all pods
oc get pods -n cp4ba-db

# View cluster details
oc describe cluster cp4ba-postgresql -n cp4ba-db
```

### Verify Database Setup
```bash
# Access PostgreSQL
oc exec -it cp4ba-postgresql-1 -n cp4ba-db -- psql

# List databases
\l

# List tablespaces
\db

# Check users
\du
```

### Monitor Logs
```bash
# Cluster logs
oc logs -n cp4ba-db -l cnpg.io/cluster=cp4ba-postgresql

# Specific pod logs
oc logs -n cp4ba-db cp4ba-postgresql-1 -c postgres

# Job logs
oc logs job/create-tablespace-dirs -n cp4ba-db
oc logs job/create-tablespaces -n cp4ba-db
```

## Configuration Details

### Performance Tuning
The cluster is optimized for CP4BA workloads:
- **Connections**: 200 max connections, 250 prepared transactions
- **Memory**: 130MB shared buffers, 5MB work memory
- **WAL**: 2GB minimum, 12GB maximum size
- **Logging**: Statements over 5 seconds logged

### Security Features
- **Encryption**: TLS for all connections
- **Authentication**: Password-based with strong passwords
- **Isolation**: Each component has dedicated database and user
- **Privileges**: Minimal required permissions per user

### Storage Layout
- **Data**: 10GB on high-performance RBD storage
- **WAL**: 5GB on shared CephFS for backup efficiency
- **Tablespaces**: Custom locations for optimal I/O

## Connection Information

### Service Endpoints
- **Read-Write**: `cp4ba-postgresql-rw.cp4ba-db.svc.cluster.local:5432`
- **Read-Only**: `cp4ba-postgresql-ro.cp4ba-db.svc.cluster.local:5432`

### Connection Examples
```bash
# Connect as superuser
psql -h cp4ba-postgresql-rw.cp4ba-db.svc.cluster.local -U postgres

# Connect to specific database
psql -h cp4ba-postgresql-rw.cp4ba-db.svc.cluster.local -U gcd_user -d gcd
```

## Maintenance Operations

### Backup and Recovery
```bash
# Manual backup
oc exec -it cp4ba-postgresql-1 -n cp4ba-db -- pg_dump -U postgres gcd > gcd_backup.sql

# View backup configuration
oc get backup -n cp4ba-db
```

### Scaling Operations
```bash
# Scale cluster (if needed)
oc patch cluster cp4ba-postgresql -n cp4ba-db --type='merge' -p='{"spec":{"instances":5}}'
```

### Cleanup
```bash
# Remove all CNPG resources
oc delete cluster cp4ba-postgresql -n cp4ba-db
oc delete job create-tablespace-dirs create-tablespaces -n cp4ba-db
oc delete configmap cp4ba-postgresql-config cp4ba-initdb-scripts -n cp4ba-db
oc delete secret cp4ba-db-credentials -n cp4ba-db
oc delete service cp4ba-postgresql-svc -n cp4ba-db
oc delete serviceaccount cp4ba-tablespace-sa -n cp4ba-db
```

## Troubleshooting

### Common Issues

**Cluster Not Starting**
```bash
# Check events
oc get events -n cp4ba-db --sort-by='.lastTimestamp'

# Check pod status
oc describe pod cp4ba-postgresql-1 -n cp4ba-db
```

**Connection Failures**
```bash
# Verify service
oc get svc -n cp4ba-db

# Check network policies
oc get networkpolicy -n cp4ba-db
```

**Tablespace Creation Failed**
```bash
# Check job logs
oc logs job/create-tablespaces -n cp4ba-db

# Verify directory permissions
oc exec -it cp4ba-postgresql-1 -n cp4ba-db -- ls -la /var/lib/postgresql/data/tablespaces/
```

**Performance Issues**
```bash
# Check resource usage
oc top pods -n cp4ba-db

# Review PostgreSQL logs
oc logs -n cp4ba-db cp4ba-postgresql-1 -c postgres | grep -i slow
```

## File Reference

| File | Purpose |
|------|---------|
| `cp4ba-postgresql.yml` | Main cluster configuration |
| `cp4ba-db-credentials.yml` | All database passwords |
| `cp4ba-postgresql-config.yml` | PostgreSQL settings |
| `cp4ba-initdb-scripts.yml` | Database initialization |
| `cp4ba-postgresql-svc.yml` | Service definition |
| `cp4ba-tablespace-rbac.yml` | RBAC for tablespace ops |
| `create-tablespace-dirs.yml` | Directory creation job |
| `create-tablespaces.yml` | Tablespace creation job |

## Support

For issues related to:
- **CNPG**: Check [CloudNativePG documentation](https://cloudnative-pg.io/)
- **CP4BA**: Consult IBM Cloud Pak for Business Automation docs
- **OpenShift**: Review Red Hat OpenShift documentation
