/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cp4ba.operate.ldaptest;

import com.ibm.cp4ba.operate.ldaptest.HostnameFakeVerifier;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;

public class LdapTest {
    private String url = null;
    private String basedn = null;
    private String binddn = null;
    private String bindCredentials = null;
    private String[] groupnamelist = null;
    private String groupdn = null;
    private String userfilter = null;
    private String groupfilter = null;
    private List<Map<String, String>> userpassdict = null;
    private List<Map<String, Object>> groupvalidateddetails = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> uservalidateddetails = new ArrayList<Map<String, Object>>();
    private StartTlsResponse tls = null;
    private boolean useTLS = false;
    private boolean validate = false;
    private boolean allowFakeHostname = false;
    private boolean additionalValidation = false;
    private String referral = null;
    private final SearchControls searchControls = new SearchControls();
    private String[] attributes;
    private long startTime;
    private long interimTime;
    private long totalTime;
    private double startqueryTime;
    private double interimqueryTime;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes.split(",");
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public void setUserFilter(String userfilter) {
        this.userfilter = userfilter;
    }

    public void setuserpassdict(String userpassdict) {
        String[] entries;
        ArrayList<Map<String, String>> dictionaries = new ArrayList<Map<String, String>>();
        for (String entry : entries = userpassdict.split(";")) {
            String[] pairs;
            HashMap<String, String> dictionary = new HashMap<String, String>();
            for (String pair : pairs = entry.split(",")) {
                String value;
                String key;
                String[] keyValue = pair.split(":");
                if (keyValue.length == 2) {
                    key = keyValue[0];
                    value = new String(Base64.getDecoder().decode(keyValue[1]));
                    dictionary.put(key, value);
                    continue;
                }
                key = keyValue[0];
                value = null;
                dictionary.put(key, value);
            }
            dictionaries.add(dictionary);
        }
        this.userpassdict = dictionaries;
    }

    public void setGroupFilter(String groupfilter) {
        this.groupfilter = groupfilter;
    }

    public void checkValidationParameters(String[] groupnamelist, String groupfilter, String groupdn, List<Map<String, String>> userpassdict, String userfilter) {
        if (groupnamelist == null || groupfilter == null || groupdn == null || userpassdict == null || userfilter == null) {
            this.additionalValidation = false;
        }
    }

    public void setBasedn(String basedn) {
        this.basedn = basedn;
    }

    public void setGroupdn(String groupdn) {
        this.groupdn = groupdn;
    }

    public void setGroupName(String groupnamelist) {
        this.groupnamelist = groupnamelist.split(",");
    }

    public void setBinddn(String binddn) {
        this.binddn = binddn;
    }

    public void setBindCredentials(String bindCredentials) {
        this.bindCredentials = bindCredentials;
    }

    public void setTls(StartTlsResponse tls) {
        this.tls = tls;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public void setAdditionalValidation(boolean additionalValidation) {
        this.additionalValidation = additionalValidation;
    }

    public void setAllowFakeHostname(boolean allowFakeHostname) {
        this.allowFakeHostname = allowFakeHostname;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public boolean canExecute() {
        return this.url != null && this.basedn != null;
    }

    private void showTime(String msg) {
        this.interimTime = new Date().getTime() - this.startTime;
        System.out.println(msg + " took " + this.interimTime + " ms");
        this.totalTime += this.interimTime;
    }

    public void showdict(List<Map<String, String>> anydict) {
        for (Map<String, String> dict : anydict) {
            System.out.println("Dictionary:");
            for (Map.Entry<String, String> entry : dict.entrySet()) {
                System.out.println(entry.getKey() + ": " + entry.getValue());
            }
            System.out.println("-------------------");
        }
    }

    public void updatedict(List<Map<String, Object>> dictList, String user, String key, Object value) {
        for (Map<String, Object> dict : dictList) {
            if (!dict.get("name").equals(user)) continue;
            dict.put(key, value);
        }
    }

    public Integer dynamiccolumn(List<Map<String, Object>> dictList) {
        int maxLength = 0;
        for (Map<String, Object> map : dictList) {
            String name = (String)map.get("name");
            if (name == null || name.length() <= maxLength) continue;
            maxLength = name.length();
        }
        return maxLength;
    }

    private static String centerText(String text, int width) {
        int padding;
        if (text == null) {
            text = "";
        }
        if ((padding = width - text.length()) <= 0) {
            return text;
        }
        int padLeft = padding / 2;
        int padRight = padding - padLeft;
        return LdapTest.padString(" ", padLeft) + text + LdapTest.padString(" ", padRight);
    }

    private static String padString(String padChar, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static boolean areAllCertificatesValid() {
        try {
            String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                trustStore.load(fis, trustStorePassword.toCharArray());
            }
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null || !(cert instanceof X509Certificate)) {
                    System.out.println("Skipping invalid or unsupported certificate at alias: " + alias);
                    continue;
                }
                X509Certificate x509Cert = (X509Certificate)cert;
                try {
                    x509Cert.checkValidity();
                    System.out.println("Certificate at alias " + alias + " is valid.");
                }
                catch (Exception e) {
                    System.out.println("Certificate at alias " + alias + " is invalid: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error occurred while validating trust store: " + e.getMessage());
            return false;
        }
    }

    public void printUserSummary(List<Map<String, Object>> dictList) {
        String redText = "\u001b[31m";
        String redTextcross = "\u001b[31m[\u2717]";
        String resetText = "\u001b[0m";
        String greenText = "\u001b[0;32m[\u2714]";
        Boolean validusers = true;
        Boolean authentication = true;
        ArrayList<String> commentslist = new ArrayList<String>();
        Integer maxlength = this.dynamiccolumn(dictList);
        String format = null;
        Integer separatorwidth = 0;
        Integer namewidth = 0;
        if (maxlength > 20) {
            format = "%" + (maxlength + 5) + "s | %-15s | %-15s%n";
            separatorwidth = maxlength + 42;
            namewidth = maxlength + 5;
        } else {
            format = "%20s | %-15s | %-15s%n";
            separatorwidth = 57;
            namewidth = 20;
        }
        System.out.println("LDAP Users Summary");
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        System.out.printf(format, LdapTest.centerText("LDAP User Name", namewidth), "Valid LDAP User", "Authentication");
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        for (Map<String, Object> map : dictList) {
            String comments = "";
            if (map.get("valid").equals(false)) {
                validusers = false;
                comments = comments + String.format("The user %s is not a valid LDAP user,", map.get("name"));
            }
            if (map.get("Authentication").equals(false)) {
                authentication = false;
                comments = comments + String.format("The user %s's authentication credentials are incorrect,", map.get("name"));
            }
            if (comments.endsWith(",")) {
                comments = comments.substring(0, comments.length() - 1) + ".";
            }
            System.out.printf(format, LdapTest.centerText((String)map.get("name"), namewidth), map.get("valid"), map.get("Authentication"));
            if (comments == null || comments.trim().isEmpty()) continue;
            commentslist.add(comments);
        }
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        System.out.println("\n");
        if (!validusers.booleanValue()) {
            System.out.println(redText + "For the Valid LDAP User column, the value \"true\" indicates that the LDAP user is found in the LDAP directory and the value \"false\" indicates that the LDAP user is not found in the LDAP directory." + resetText + "\n");
        }
        if (!authentication.booleanValue()) {
            System.out.println(redText + "For the Authentication column, the value \"true\" indicates that the LDAP user could be authenticated with the credentials entered in the property files and the value \"false\" indicates that the LDAP user could not be authenticated with the credentials entered in the property files." + resetText + "\n");
        }
        if (!authentication.booleanValue() || !validusers.booleanValue()) {
            System.out.println(redText + "Review the comments section below and update the properties in the cp4ba_user_profile.property and cp4ba_LDAP.property files." + resetText + "\n");
            for (int i = 0; i < commentslist.size(); ++i) {
                int bulletPoint = i + 1;
                System.out.println(redText + bulletPoint + ". " + (String)commentslist.get(i) + resetText + "\n");
            }
        } else {
            System.out.println(greenText + "All LDAP user details entered in the cp4ba_user_profile.property and cp4ba_LDAP.property property files have been successfully validated." + resetText + "\n");
        }
        System.out.println("\n");
    }

    public void printGroupSummary(List<Map<String, Object>> dictList) {
        String redText = "\u001b[31m";
        String redTextcross = "\u001b[31m[\u2717]";
        String greenText = "\u001b[0;32m[\u2714]";
        Boolean validgroups = true;
        String resetText = "\u001b[0m";
        ArrayList<String> commentslist = new ArrayList<String>();
        Integer maxlength = this.dynamiccolumn(dictList);
        String format = null;
        Integer separatorwidth = 0;
        Integer namewidth = 0;
        if (maxlength > 20) {
            format = "%" + (maxlength + 5) + "s | %-20s%n";
            separatorwidth = maxlength + 25;
            namewidth = maxlength + 5;
        } else {
            format = "%20s | %-20s%n";
            separatorwidth = 40;
            namewidth = 20;
        }
        System.out.println("LDAP Groups Summary");
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        System.out.printf(format, LdapTest.centerText("LDAP Group Name", namewidth), "Valid LDAP Group");
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        for (Map<String, Object> map : dictList) {
            String comments = "";
            if (map.get("valid").equals(false)) {
                validgroups = false;
                comments = comments + String.format("The group %s is not a valid LDAP group,", map.get("name"));
            }
            if (comments.endsWith(",")) {
                comments = comments.substring(0, comments.length() - 1) + ".";
            }
            System.out.printf(format, LdapTest.centerText((String)map.get("name"), namewidth), map.get("valid"));
            if (comments == null || comments.trim().isEmpty()) continue;
            commentslist.add(comments);
        }
        System.out.println(new String(new char[separatorwidth.intValue()]).replace('\u0000', '-'));
        System.out.println("\n");
        if (!validgroups.booleanValue()) {
            System.out.println(redText + "For the Valid Group column, the value \"true\" indicates that the LDAP group is found in the LDAP directory and the value \"false\" indicates that the LDAP group is not found in the LDAP directory." + resetText + "\n");
            System.out.println(redText + "Review the comments section below and update the properties in the cp4ba_user_profile.property and cp4ba_LDAP.property files." + resetText + "\n");
            for (int i = 0; i < commentslist.size(); ++i) {
                int bulletPoint = i + 1;
                System.out.println(redText + bulletPoint + ". " + (String)commentslist.get(i) + resetText + "\n");
            }
        } else {
            System.out.println(greenText + "All LDAP group details entered in the cp4ba_user_profile.property and cp4ba_LDAP.property property files have been successfully validated." + resetText + "\n");
        }
    }

    private static Map<String, Object> createDictionary(String name, boolean valid) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        dictionary.put("name", name);
        dictionary.put("valid", valid);
        return dictionary;
    }

    private void validate_group_list(String[] grouplist, List<Map<String, String>> userdict) {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String groupname : grouplist) {
            boolean isMatchFound = false;
            for (Map<String, String> user : userdict) {
                if (!groupname.equals(user.get("username"))) continue;
                isMatchFound = true;
                break;
            }
            if (isMatchFound) continue;
            filteredList.add(groupname);
        }
        this.groupnamelist = filteredList.toArray(new String[0]);
    }

    private void validate_notgroup_list(String[] grouplist, String[] notgrouplist) {
        ArrayList<String> groupList = new ArrayList<String>(Arrays.asList(grouplist));
        for (String groupname : notgrouplist) {
            groupList.remove(groupname);
            HashMap<String, String> userpassEntry = new HashMap<String, String>();
            userpassEntry.put("username", groupname);
            userpassEntry.put("password", null);
            this.userpassdict.add(userpassEntry);
        }
        this.groupnamelist = groupList.toArray(new String[0]);
    }

    public void exec(PrintStream out) throws IOException, NamingException {
        this.startTime = new Date().getTime();
        System.out.println("Binding...");
        LdapContext ctx = this.getLdapContext(out, this.url, this.binddn, this.bindCredentials);
        if (ctx == null) {
            out.println("Binding failed.. exiting");
            return;
        }
        this.showTime("Binding");
        this.checkValidationParameters(this.groupnamelist, this.groupfilter, this.groupdn, this.userpassdict, this.userfilter);
        if (this.additionalValidation) {
            try {
                this.validate_group_list(this.groupnamelist, this.userpassdict);
                out.println("group list " + Arrays.toString(this.groupnamelist));
                String[] notgrouplist = new String[]{};
                for (String groupname : this.groupnamelist) {
                    boolean isvalidGroup = this.isGroupValid(out, ctx, this.groupdn, groupname, this.groupfilter);
                    if (isvalidGroup) {
                        out.printf("The Group %s is a valid Group in the LDAP", groupname);
                        this.groupvalidateddetails.add(LdapTest.createDictionary(groupname, true));
                        continue;
                    }
                    Map<String, Object> returnvalues = this.isUserValid(out, ctx, this.basedn, groupname, this.userfilter);
                    boolean isvalidUsernotGroup = (Boolean)returnvalues.get("isuser");
                    if (isvalidUsernotGroup) {
                        notgrouplist = Arrays.copyOf(notgrouplist, notgrouplist.length + 1);
                        notgrouplist[notgrouplist.length - 1] = groupname;
                        continue;
                    }
                    out.printf("The Group %s is not a valid Group", groupname);
                    this.groupvalidateddetails.add(LdapTest.createDictionary(groupname, false));
                }
                if (notgrouplist != null && notgrouplist.length > 0) {
                    this.validate_notgroup_list(this.groupnamelist, notgrouplist);
                }
                out.println("group list after validated\n");
                out.println(Arrays.toString(this.groupnamelist));
                out.println(this.userpassdict);
                out.println(this.groupvalidateddetails);
                out.println("using the user password dict for validation of users---");
                for (Map map : this.userpassdict) {
                    String username = (String)map.get("username");
                    out.println("Username being validated currently is " + username);
                    Map<String, Object> returnvalues = this.isUserValid(out, ctx, this.basedn, username, this.userfilter);
                    out.println(returnvalues);
                    boolean isvalidUser = (Boolean)returnvalues.get("isuser");
                    if (isvalidUser) {
                        out.printf("The User %s is a valid User", username);
                        this.uservalidateddetails.add(LdapTest.createDictionary(username, true));
                        map.put("userbind", (String)returnvalues.get("binddn"));
                        continue;
                    }
                    out.printf("The User %s is not a valid User", username);
                    this.uservalidateddetails.add(LdapTest.createDictionary(username, false));
                    map.put("userbind", "notfound");
                }
                out.println(this.userpassdict);
                for (Map map : this.userpassdict) {
                    String username = (String)map.get("username");
                    String userbinddn = (String)map.get("userbind");
                    String password = (String)map.get("password");
                    if (!userbinddn.equals("notfound")) {
                        out.println(map);
                        boolean isAuthenticated = false;
                        isAuthenticated = password == null ? this.authenticateUser(ctx, out, this.url, userbinddn, password, username) : this.authenticateUser(null, out, this.url, userbinddn, password, username);
                        if (isAuthenticated) {
                            out.println("User is authenticated successfully");
                            continue;
                        }
                        out.println("User authentication failed");
                        continue;
                    }
                    this.updatedict(this.uservalidateddetails, username, "Authentication", false);
                }
                out.println(this.uservalidateddetails);
                this.printUserSummary(this.uservalidateddetails);
                this.printGroupSummary(this.groupvalidateddetails);
            }
            catch (Exception e) {
                out.printf("Error found while performing the additional validation checks for the LDAP Details: %s\n", e.getMessage());
                out.printf("The additional validation steps have been skipped due the error stated above", new Object[0]);
            }
        }
        this.close(ctx);
        System.out.println("Total time taken: " + this.totalTime + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateUser(LdapContext ctx, PrintStream out, String url, String usernamebinddn, String userPassword, String user) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (ctx == null) {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", url);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", usernamebinddn);
            env.put("java.naming.security.credentials", userPassword);
            env.put("java.naming.referral", "follow");
        }
        try {
            if (ctx == null) {
                block20: {
                    try {
                        ctx = new InitialLdapContext(env, null);
                        if (ctx != null) break block20;
                        out.println("Authentication failed for user " + user);
                        this.updatedict(this.uservalidateddetails, user, "Authentication", false);
                        boolean bl = false;
                        return bl;
                    }
                    catch (NamingException e) {
                        System.out.println("Authentication failed: " + e.getMessage());
                        this.updatedict(this.uservalidateddetails, user, "Authentication", false);
                        boolean e2 = false;
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException e3) {
                                System.out.println("Failed to close LDAP context: " + e3.getMessage());
                            }
                        }
                        return e2;
                    }
                }
                System.out.println("User has been Successfully authenticated.");
            }
            this.updatedict(this.uservalidateddetails, user, "Authentication", true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e2) {
                    System.out.println("Failed to close LDAP context: " + e2.getMessage());
                }
            }
        }
    }

    public boolean isGroupValid(PrintStream out, LdapContext ctx, String groupDn, String groupName, String groupfilter) throws NamingException {
        try {
            out.println("Group name that is being validated---- " + groupName);
            out.println("Group Filter used-----" + groupfilter);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String searchgrouplist = groupfilter.replace("%v", groupName);
            NamingEnumeration<SearchResult> results = ctx.search(groupDn, searchgrouplist, searchControls);
            return results.hasMore();
        }
        catch (Exception e) {
            out.printf("Error found while validating the LDAP Group %s : %s", groupName, e.getMessage());
            return false;
        }
    }

    public Map<String, Object> isUserValid(PrintStream out, LdapContext ctx, String baseDn, String username, String userfilter) throws NamingException {
        HashMap<String, Object> returnvalues = new HashMap<String, Object>();
        try {
            out.println("User that is being validated ---- " + username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String searchusernamelist = userfilter.replace("%v", username);
            NamingEnumeration<SearchResult> results = ctx.search(baseDn, searchusernamelist, searchControls);
            if (results.hasMore()) {
                SearchResult result = results.next();
                String userDN = result.getNameInNamespace();
                out.println("full binddn-----------" + userDN);
                returnvalues.put("isuser", true);
                returnvalues.put("binddn", userDN);
                return returnvalues;
            }
            returnvalues.put("isuser", false);
            returnvalues.put("binddn", "notfound");
            return returnvalues;
        }
        catch (Exception e) {
            out.printf("Error found while validating the LDAP Username %s : %s", username, e.getMessage());
            returnvalues.put("isuser", false);
            returnvalues.put("binddn", "");
            return returnvalues;
        }
    }

    public LdapContext getLdapContext(PrintStream out, String url, String binddn, String bindCredentials) throws IOException, NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        if (this.referral != null) {
            env.put("java.naming.referral", this.referral);
        }
        if (binddn != null) {
            out.println("Binding with principal: " + binddn);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", binddn);
        }
        if (bindCredentials != null) {
            env.put("java.naming.security.credentials", bindCredentials);
        }
        if (url.startsWith("ldaps")) {
            boolean ssl_validity = LdapTest.areAllCertificatesValid();
            if (!ssl_validity) {
                out.println("Error while binding to LDAP. Please check your SSL certificate details");
                return null;
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            out.println("Error while binding to LDAP. Please check your credentials and if the LDAP Server is accessible");
            return null;
        }
        long nanoTime = System.nanoTime();
        double timeInSeconds = (double)nanoTime / 1.0E9;
        this.startqueryTime = (double)nanoTime % 1.0E9 / 1000000.0;
        try {
            NamingEnumeration<SearchResult> results = ctx.search(binddn, "(objectclass=*)", new SearchControls());
            results.hasMore();
            nanoTime = System.nanoTime();
            timeInSeconds = (double)nanoTime / 1.0E9;
            this.interimqueryTime = (double)nanoTime % 1.0E9 / 1000000.0;
            this.interimqueryTime -= this.startqueryTime;
        }
        catch (Exception e) {
            nanoTime = System.nanoTime();
            timeInSeconds = (double)nanoTime / 1.0E9;
            this.interimqueryTime = (double)nanoTime % 1.0E9 / 1000000.0;
            this.interimqueryTime -= this.startqueryTime;
        }
        System.out.println("Round Trip time: " + this.interimqueryTime + " ms");
        out.println("Connected to: " + url);
        if (this.useTLS && url.startsWith("ldap:")) {
            this.tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            if (this.allowFakeHostname) {
                this.tls.setHostnameVerifier(new HostnameFakeVerifier());
            }
            this.tls.negotiate();
            out.println("TLS enabled");
        }
        return ctx;
    }

    private String getUserdn(Attributes ldapAttributes, SearchResult result) throws NamingException {
        Attribute dn;
        String distinguishedUserDN = null;
        if (ldapAttributes != null && (dn = ldapAttributes.get("dn")) != null) {
            distinguishedUserDN = (String)dn.get();
        }
        if (distinguishedUserDN == null) {
            distinguishedUserDN = result.isRelative() ? result.getName() + ("".equals(this.basedn) ? "" : "," + this.basedn) : result.getNameInNamespace();
        }
        return distinguishedUserDN;
    }

    private void dumpAttributes(PrintStream out, NamingEnumeration attributes) throws NamingException {
        while (attributes.hasMore()) {
            Attribute attr = (Attribute)attributes.next();
            if (attr == null) continue;
            Object values = attr.get();
            if (values == null) {
                out.println(attr.getID() + "=<<<no values found>>>");
                continue;
            }
            int size = attr.size();
            if (size == 0) {
                out.println(attr.getID() + "=<<<size was 0>>>");
                continue;
            }
            for (int s = 0; s < size; ++s) {
                out.println(attr.getID() + "=" + attr.get(s).toString());
            }
        }
    }

    private void close(LdapContext ctx) {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

