/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cp4ba.operate.ldaptest;

import com.ibm.cp4ba.operate.ldaptest.LdapTest;
import java.io.IOException;
import javax.naming.NamingException;

public class Main {
    private static final String VERSION = "2022-12-01";

    public static void main(String[] args) throws NamingException, IOException {
        LdapTest instance = new LdapTest();
        if (Main.readOptions(instance, args)) {
            instance.exec(System.out);
        } else {
            Main.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println(" java -jar ldaptest.jar -u <url> -b <baseDN> [-D binddn -w password] -additionalvalidation [-gdn groupDN] [-upl userpasswordlist -gl groupnamelist] [-uf userFilter -gf groupFilter] [[-rf|-ri|-rt] [-t [-n]]\n Required:\n  -u url            : in the format \"ldap://server:port\"\n  -b baseDN       : the base dn from which to search a user\n  -D binddn         : bind (authenticate) to LDAP when creating the connection\n  -w password       : password for the bind\n  Additional Validation Parameters:\n  -additionalvalidation : to perform additional validation in addition to the binddn validation \n  -gdn groupDN      : the group dn from which to search a group\n  -upl user password list : Contains a dictionary of users & passwords corresponding to be used to authenticate\n  -gl groupname list      : a list of group names to validate\n  -gf groupFilter   : Group filter used to search for a specific group in the LDAP\n  -uf userFilter    : User filter used to search for a specific group in the LDAP\n  Optional:\n  -rf | -ri | -rt   : referrals: follow | ignore | throw\n  -t                : use startTLS when connecting to the non-secure port\n  -n                : in combination with -t: do not check the certificate hostname\n  -a                : comma separated list of attributes to fetch, default is all\n  -help             : shows the help\n\n Secure connections need:\n    java -Djavax.net.ssl.trustStore=/path/to/store.jks -Djavax.net.ssl.trustStorePassword=password -jar ldapTest.jar ...");
        System.exit(1);
    }

    private static boolean readOptions(LdapTest instance, String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-u".equals(args[i])) {
                instance.setUrl(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-b".equals(args[i])) {
                instance.setBasedn(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-gdn".equals(args[i])) {
                instance.setGroupdn(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-uf".equals(args[i])) {
                instance.setUserFilter(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-gf".equals(args[i])) {
                instance.setGroupFilter(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-upl".equals(args[i])) {
                instance.setuserpassdict(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-D".equals(args[i])) {
                instance.setBinddn(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-w".equals(args[i])) {
                instance.setBindCredentials(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-gl".equals(args[i])) {
                instance.setGroupName(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-t".equals(args[i])) {
                instance.setUseTLS(true);
                ++i;
                continue;
            }
            if ("-additionalvalidation".equals(args[i])) {
                instance.setAdditionalValidation(true);
                ++i;
                continue;
            }
            if ("-h".equals(args[i])) {
                instance.setAllowFakeHostname(true);
                ++i;
                continue;
            }
            if ("-rf".equals(args[i])) {
                instance.setReferral("follow");
                ++i;
                continue;
            }
            if ("-ri".equals(args[i])) {
                instance.setReferral("ignore");
                ++i;
                continue;
            }
            if ("-rt".equals(args[i])) {
                instance.setReferral("throw");
                ++i;
                continue;
            }
            if ("-help".equals(args[i])) {
                Main.usage();
                continue;
            }
            System.out.println("Unknown argument: " + args[i]);
            Main.usage();
        }
        return instance.canExecute();
    }
}

