/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.constants;

import com.filenet.api.constants.VersionStatus;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;

public class VersionStatusId
extends Id {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID = -4846791583317622768L;
    public static final VersionStatusId RESERVATION = new VersionStatusId("{f9ed916d-ccb7-4d7e-8cc1-563f1692c67c}");
    public static final VersionStatusId SUPERSEDED = new VersionStatusId("{a0a5a26e-d19f-4415-8451-6795386ad1bb}");
    public static final VersionStatusId IN_PROCESS = new VersionStatusId("{e76e4f72-545c-4180-97c1-8449883b83cf}");
    public static final VersionStatusId RELEASED = new VersionStatusId("{95ad7aed-dfa0-4459-ae95-2ca2fc041602}");

    private Object readResolve() throws ObjectStreamException {
        return VersionStatusId.getInstanceFromString(this.toString());
    }

    public static VersionStatusId fromVersionStatus(VersionStatus vs) {
        switch (vs.getValue()) {
            case 1: {
                return RELEASED;
            }
            case 2: {
                return IN_PROCESS;
            }
            case 3: {
                return RESERVATION;
            }
            case 4: {
                return SUPERSEDED;
            }
        }
        return null;
    }

    public static VersionStatus toVersionStatus(VersionStatusId vsi) {
        if (vsi == RESERVATION) {
            return VersionStatus.RESERVATION;
        }
        if (vsi == RELEASED) {
            return VersionStatus.RELEASED;
        }
        if (vsi == IN_PROCESS) {
            return VersionStatus.IN_PROCESS;
        }
        if (vsi == SUPERSEDED) {
            return VersionStatus.SUPERSEDED;
        }
        return null;
    }

    public static VersionStatusId getInstanceFromString(String val) {
        if (val == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "value");
        }
        if (val.equalsIgnoreCase("Reservation") || val.equalsIgnoreCase(RESERVATION.toString())) {
            return RESERVATION;
        }
        if (val.equalsIgnoreCase("Released") || val.equalsIgnoreCase(RELEASED.toString())) {
            return RELEASED;
        }
        if (val.equalsIgnoreCase("Superseded") || val.equalsIgnoreCase(SUPERSEDED.toString())) {
            return SUPERSEDED;
        }
        if (val.equalsIgnoreCase("InProcess") || val.equalsIgnoreCase(IN_PROCESS.toString())) {
            return IN_PROCESS;
        }
        return null;
    }

    private VersionStatusId(String id) {
        super(id);
    }
}

