/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.core;

import com.filenet.api.core.BatchItemHandle;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.classloader.CRCLHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class Batch {
    private static final String BATCH_CLASS_NAME = Batch.class.getName();
    private List batchList = null;
    private Domain domain = null;
    Object crclDelegate = null;
    private static final Class[] types_i = new Class[]{IndependentObject.class};

    Batch(Domain domain) {
        if (domain == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "domain");
        }
        this.domain = domain;
        this.batchList = new ArrayList();
    }

    void addHandle(BatchItemHandle handle) {
        this.batchList.add(handle);
    }

    public List getBatchItemHandles(IndependentObject object) {
        if (this.crclDelegate != null) {
            Object crclResult = CRCLHelper.doCRCLcall(this.crclDelegate, BATCH_CLASS_NAME, "getBatchItemHandles", types_i, object);
            return (List)crclResult;
        }
        ArrayList<BatchItemHandle> batchHandles = new ArrayList<BatchItemHandle>();
        if (object == null) {
            batchHandles.addAll(this.batchList);
        } else {
            for (BatchItemHandle item : this.batchList) {
                if (!object.equals(item.getObject())) continue;
                batchHandles.add(item);
            }
        }
        return batchHandles;
    }

    List getBatchList() {
        return this.batchList;
    }

    Domain getDomain() {
        return this.domain;
    }
}

