/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.api.constants.DatabaseType;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.IdGen;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class Id
implements Serializable,
Comparable {
    private byte[] guidBytes = null;
    private String guidString = null;
    private int hashCode = -1;
    private static final ThreadLocal<char[]> tlsCharBuff = new ThreadLocal();
    private static final ThreadLocal<byte[]> tlsByteBuff = new ThreadLocal();
    private static final int GUIDByteLen = 16;
    private static final int GUIDStringLen = 38;
    private static final char[] GUIDStringDigits = "0123456789ABCDEF".toCharArray();
    private static final byte[] guidByteOrder = new byte[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final Id ZERO_ID = new Id("{00000000-0000-0000-0000-000000000000}");
    private static DatabaseType dbTypeForSequential = null;
    private static final byte[] sqlServerByteOrder;
    private static final long serialVersionUID = -4124337438284514026L;
    private static final ObjectStreamField[] serialPersistentFields;

    public static Id createId() {
        if (dbTypeForSequential != null) {
            return Id.createSequentialId(dbTypeForSequential);
        }
        byte[] bytes = IdGen.getRandomBytes();
        bytes[7] = (byte)(bytes[7] & 0xF);
        bytes[7] = (byte)(bytes[7] | 0x40);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        Id newId = new Id(bytes, null);
        return newId;
    }

    public static Id createSequentialId(DatabaseType dbType) {
        byte[] bytes = IdGen.getSequentialBytes(dbType);
        return new Id(bytes, null);
    }

    public static Id asIdOrNull(String id) {
        char[] guidChars = Id.getCharBuffer();
        byte[] guidBytes = Id.parseToBytesOrNull(id, guidChars);
        if (guidBytes == null) {
            return null;
        }
        String guidString = new String(guidChars);
        return new Id(guidBytes, guidString);
    }

    private static char[] getCharBuffer() {
        char[] guidChars = tlsCharBuff.get();
        if (guidChars == null) {
            guidChars = new char[38];
            tlsCharBuff.set(guidChars);
        }
        return guidChars;
    }

    public Id(String id) {
        char[] guidChars = Id.getCharBuffer();
        this.guidBytes = Id.parseToBytesOrNull(id, guidChars);
        if (this.guidBytes == null) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, new Object[]{"id", id});
        }
        this.guidString = new String(guidChars);
    }

    public Id(byte[] bytes) {
        int length;
        int n = length = bytes == null ? 0 : bytes.length;
        if (length != 16) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, new Object[]{"bytes", Integer.toString(length)});
        }
        this.guidBytes = new byte[16];
        System.arraycopy(bytes, 0, this.guidBytes, 0, 16);
    }

    private Id(byte[] bytes, String canonicalString) {
        this.guidBytes = bytes;
        this.guidString = canonicalString;
    }

    public int compareTo(Object arg) {
        return this.compareTo(arg, null);
    }

    public int compareTo(Object arg, DatabaseType dbType) {
        Id argId = (Id)arg;
        if (dbType == DatabaseType.MSSQL) {
            for (int i = 0; i < this.guidBytes.length; ++i) {
                int cmp = (this.guidBytes[sqlServerByteOrder[i]] & 0xFF) - (argId.guidBytes[sqlServerByteOrder[i]] & 0xFF);
                if (cmp == 0) continue;
                return cmp < 0 ? -1 : 1;
            }
        } else if (dbType == DatabaseType.POSTGRE_SQL) {
            for (int i = 0; i < this.guidBytes.length; ++i) {
                int cmp = (this.guidBytes[guidByteOrder[i]] & 0xFF) - (argId.guidBytes[guidByteOrder[i]] & 0xFF);
                if (cmp == 0) continue;
                return cmp < 0 ? -1 : 1;
            }
        } else {
            for (int i = 0; i < this.guidBytes.length; ++i) {
                int cmp = (this.guidBytes[i] & 0xFF) - (argId.guidBytes[i] & 0xFF);
                if (cmp == 0) continue;
                return cmp < 0 ? -1 : 1;
            }
        }
        return 0;
    }

    public boolean equals(Object otherId) {
        if (otherId == this) {
            return true;
        }
        if (!(otherId instanceof Id)) {
            return false;
        }
        byte[] otherBytes = ((Id)otherId).guidBytes;
        for (int i = 0; i < 16; ++i) {
            if (this.guidBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        byte[] outBytes = new byte[this.guidBytes.length];
        System.arraycopy(this.guidBytes, 0, outBytes, 0, this.guidBytes.length);
        return outBytes;
    }

    public byte getByte(int index) {
        return this.guidBytes[index];
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 23;
            for (int i = 0; i < 16; ++i) {
                hash += this.guidBytes[i] & 0xFF;
                hash += hash << 10;
                hash ^= hash >>> 6;
            }
            hash += hash << 3;
            hash ^= hash >>> 11;
            hash += hash << 15;
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public static boolean isId(String value) {
        if (value == null) {
            return false;
        }
        int valueLength = value.length();
        if (valueLength < 36) {
            return false;
        }
        int length = 0;
        int brackets = 0;
        boolean whitespace = false;
        for (int i = 0; i < valueLength; ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                whitespace = length > 0;
                continue;
            }
            if (whitespace) {
                return false;
            }
            if (c == '{') {
                if (brackets != 0 || length != 0) {
                    return false;
                }
                ++brackets;
                continue;
            }
            if (c == '}') {
                if (brackets != 1 || length != 36) {
                    return false;
                }
                ++brackets;
                continue;
            }
            if (length == 8 || length == 13 || length == 18 || length == 23) {
                if (c != '-') {
                    return false;
                }
                ++length;
                continue;
            }
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                return false;
            }
            ++length;
        }
        return length == 36 && brackets != 1;
    }

    public String toString() {
        this.generateString();
        return this.guidString;
    }

    private static byte[] parseToBytesOrNull(String id, char[] guidChars) {
        if (id == null) {
            return null;
        }
        int length = id.length();
        if (length < 36) {
            return null;
        }
        byte[] guidBytes = tlsByteBuff.get();
        if (guidBytes == null) {
            guidBytes = new byte[16];
            tlsByteBuff.set(guidBytes);
        }
        int iBytes = 0;
        int iChars = 0;
        int partByte = 0;
        boolean lowerNibble = false;
        boolean trailingWhitespace = false;
        boolean expectCloseBrace = false;
        for (int iString = 0; iString < length; ++iString) {
            char c = id.charAt(iString);
            if (Character.isWhitespace(c)) {
                if (iChars != 0 && iBytes != 16) {
                    return null;
                }
                trailingWhitespace = iChars > 0;
                continue;
            }
            if (iChars == 0) {
                if (c == '{') {
                    expectCloseBrace = true;
                    c = id.charAt(++iString);
                }
                guidChars[iChars++] = 123;
            } else {
                if (trailingWhitespace) {
                    return null;
                }
                if (iChars == 9 || iChars == 14 || iChars == 19 || iChars == 24) {
                    if (c != '-') {
                        return null;
                    }
                    guidChars[iChars++] = c;
                    continue;
                }
            }
            if (c == '}') {
                if (!expectCloseBrace || iBytes != 16) {
                    return null;
                }
                guidChars[iChars++] = c;
                continue;
            }
            if (iChars > 36) {
                return null;
            }
            int digit = Character.digit(c, 16);
            if (digit == -1) {
                return null;
            }
            if (lowerNibble) {
                guidBytes[Id.guidByteOrder[iBytes++]] = (byte)((partByte << 4) + digit);
                lowerNibble = false;
            } else {
                partByte = digit;
                lowerNibble = true;
            }
            guidChars[iChars++] = GUIDStringDigits[digit];
        }
        if (iBytes != 16) {
            return null;
        }
        if (iChars == 37) {
            if (expectCloseBrace) {
                return null;
            }
            guidChars[iChars] = 125;
        } else if (iChars != 38 || guidChars[iChars - 1] != '}') {
            return null;
        }
        byte[] outBytes = new byte[guidBytes.length];
        System.arraycopy(guidBytes, 0, outBytes, 0, guidBytes.length);
        return outBytes;
    }

    private void generateString() {
        if (this.guidString != null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(38).append('{');
        for (int i = 0; i < 16; ++i) {
            byte b = this.guidBytes[guidByteOrder[i]];
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buffer.append('-');
            }
            buffer.append(GUIDStringDigits[0xF & b >> 4]);
            buffer.append(GUIDStringDigits[0xF & b]);
        }
        this.guidString = buffer.append('}').toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.guidBytes);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.guidBytes = (byte[])s.readObject();
        this.hashCode = -1;
    }

    static {
        int dbSequential = ConfigValueLookup.getValueAsInt("com.filenet.api.util.Id.SequentialDBType", -1);
        if (dbSequential > 0) {
            dbTypeForSequential = DatabaseType.getInstanceFromInt(dbSequential);
        }
        sqlServerByteOrder = new byte[]{10, 11, 12, 13, 14, 15, 8, 9, 6, 7, 4, 5, 0, 1, 2, 3};
        serialPersistentFields = new ObjectStreamField[0];
    }
}

