/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnLogger;
import com.filenet.apiimpl.authentication.util.DynLoginContext;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;

public class AuthnUtil {
    private static final String FNAME = "[AuthnUtil] ";
    private static boolean isInitLogger = true;
    private static AuthnLogger logger = null;

    private AuthnUtil() {
    }

    public static void setSysOutMode() {
        isInitLogger = false;
        logger = null;
    }

    private static AuthnLogger getLogger() {
        if (isInitLogger) {
            isInitLogger = false;
            logger = LoggerSetup.logger;
        }
        return logger;
    }

    public static synchronized void log(Object msg) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void log(Object msg, Throwable t) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.log(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static synchronized void warn(Object msg) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.warn(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void warn(Object msg, Throwable t) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.warn(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static synchronized void error(Object msg) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.error(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void error(Object msg, Throwable t) {
        AuthnLogger logger = AuthnUtil.getLogger();
        if (logger != null) {
            logger.error(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static void destroyCred(Object c) {
        if (c instanceof char[]) {
            char[] a = (char[])c;
            for (int i = 0; i < a.length; ++i) {
                a[i] = '\u0000';
            }
            return;
        }
        if (c instanceof Destroyable) {
            try {
                ((Destroyable)c).destroy();
                return;
            }
            catch (Exception a) {}
        } else if (c instanceof String) {
            return;
        }
        try {
            Method m = c.getClass().getMethod("dispose", null);
            m.invoke(c, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void displayClassloaders(String where, Class cls) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": classloaders...");
        for (ClassLoader cl = cls.getClassLoader(); cl != null; cl = cl.getParent()) {
            buf.append('\n');
            buf.append("  ");
            AuthnUtil.displayObj(buf, cl);
        }
        AuthnUtil.log(buf.toString());
    }

    public static void displaySubject(String where, Subject subject) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": ");
        if (subject == null) {
            buf.append("subject is null!\n");
        } else {
            buf.append("contents of subject (");
            AuthnUtil.displayObj(buf, subject);
            for (Principal p : subject.getPrincipals()) {
                AuthnUtil.displayPrincipal(buf, p, 1);
            }
            AuthnUtil.displayCreds(buf, "public", subject.getPublicCredentials());
            AuthnUtil.displayCreds(buf, "private", subject.getPrivateCredentials());
        }
        AuthnUtil.log(buf.toString());
    }

    public static void displayObject(String where, Object obj) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": ");
        AuthnUtil.displayObj(buf, obj);
        AuthnUtil.log(buf.toString());
    }

    private static void displayPrincipal(StringBuffer buf, Principal principal, int level) {
        buf.append('\n');
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append('[');
        buf.append(level);
        buf.append("] principal: ");
        buf.append(principal.getName());
        buf.append(" (");
        AuthnUtil.displayObj(buf, principal);
        buf.append(')');
        if (principal instanceof FnCLMPrincipal) {
            buf.append("  CLM: ");
            Object tok = ((FnCLMPrincipal)principal).getCLM();
            AuthnUtil.displayObj(buf, tok);
        }
        if (principal instanceof Group) {
            Group group = (Group)principal;
            int mems = 0;
            Enumeration mem = group.members();
            while (mem.hasMoreElements()) {
                Principal subprin = (Principal)mem.nextElement();
                AuthnUtil.displayPrincipal(buf, subprin, level + 1);
                ++mems;
            }
            if (mems == 0) {
                buf.append('\n');
                for (int i = 0; i <= level; ++i) {
                    buf.append("  ");
                }
                buf.append("<no members>");
            }
        }
    }

    private static void displayCreds(StringBuffer buf, String type, Collection creds) {
        for (Object cred : creds) {
            buf.append("\n  ");
            buf.append(type);
            buf.append(" credential: ");
            buf.append(cred.toString());
            buf.append(" (");
            AuthnUtil.displayObj(buf, cred);
            buf.append(")");
        }
    }

    private static void displayObj(StringBuffer buf, Object obj) {
        if (obj == null) {
            buf.append("null");
        } else {
            buf.append(obj.getClass().getName());
            buf.append('@');
            buf.append(Integer.toHexString(System.identityHashCode(obj)));
        }
    }

    static DynLoginContext setupJBossClientSecurity(Subject subject) {
        Object cred;
        FnCLM token;
        if (subject == null) {
            return null;
        }
        Set<Principal> prins = subject.getPrincipals();
        if (prins != null && !prins.isEmpty() && (token = AuthnUtil.findFnCLM(subject)) != null && (cred = token.getCred()) != null) {
            Principal curPrin = prins.iterator().next();
            char[] pw = null;
            pw = cred instanceof char[] ? (char[])cred : cred.toString().toCharArray();
            FnceCallbackHandler ch = new FnceCallbackHandler(curPrin.getName(), pw);
            DynLoginContext lc = null;
            try {
                AppConfigurationEntry conf = DynLoginContext.buildConf("org.jboss.security.ClientLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, null, new String[]{"restore-login-identity=true", "multi-threaded=true"});
                lc = new DynLoginContext(null, (CallbackHandler)ch, conf, false);
                lc.login();
            }
            catch (LoginException le) {
                throw AuthnUtil.wrappedException(le);
            }
            return lc;
        }
        AuthnUtil.warn("[AuthnUtil] setupSecurity: FnClientLoginModule not used for authentication");
        return null;
    }

    public static FnCLM findFnCLM(Subject subj) {
        Set<FnCLM> creds;
        Principal prin;
        FnCLM clm = null;
        Set<Principal> prins = subj.getPrincipals();
        if (prins != null && !prins.isEmpty() && (prin = prins.iterator().next()) instanceof FnCLMPrincipal) {
            clm = (FnCLM)((FnCLMPrincipal)prin).getCLM();
        }
        if (clm == null && (creds = subj.getPrivateCredentials(FnCLM.class)) != null && !creds.isEmpty()) {
            clm = creds.iterator().next();
        }
        return clm;
    }

    public static IllegalStateException wrappedException(Exception e) {
        return (IllegalStateException)new IllegalStateException(ExceptionAuthn.E_AUTHN_UNEXPECTED_EXCEPTION.toString(new Object[]{e.getLocalizedMessage()})).initCause(e);
    }

    public static Object cacheCred(Object cred) {
        return new FnCLM(cred);
    }

    public static void hexEncode(byte[] ba, StringBuffer buf) {
        for (int i = 0; i < ba.length; ++i) {
            String s = Integer.toHexString(ba[i] & 0xFF);
            if (s.length() == 1) {
                buf.append('0');
            }
            buf.append(s);
        }
    }

    public static String hexEncode(byte[] ba) {
        StringBuffer buf = new StringBuffer(ba.length * 2);
        AuthnUtil.hexEncode(ba, buf);
        return buf.toString();
    }

    public static class FnCLM
    implements Destroyable,
    Serializable {
        private static final long serialVersionUID = -5275729754068046424L;
        private static final byte[] m = AuthnUtil.class.getName().getBytes();
        private static final int mmax = m.length;
        private static final int rmax = 16;
        private static final ThreadLocal tlsRandom = new ThreadLocal();
        private Object eCred;
        private byte[] r;

        FnCLM(Object cred) {
            this.eCred = cred;
            this.r = FnCLM.getRandomBytes();
            if (cred instanceof char[]) {
                this.eCred = this.crypt();
            }
        }

        public Object getCred() {
            if (this.eCred instanceof char[]) {
                return this.crypt();
            }
            return this.eCred;
        }

        public byte[] getR() {
            byte[] temp = new byte[16];
            System.arraycopy(this.r, 0, temp, 0, 16);
            return temp;
        }

        @Override
        public void destroy() {
            if (this.eCred != null && !(this.eCred instanceof char[])) {
                AuthnUtil.destroyCred(this.eCred);
            }
        }

        @Override
        public boolean isDestroyed() {
            if (this.eCred != null && this.eCred instanceof Destroyable) {
                return ((Destroyable)this.eCred).isDestroyed();
            }
            return false;
        }

        private char[] crypt() {
            char[] s = (char[])this.eCred;
            int cmax = s.length;
            char[] c = new char[cmax];
            int rx = 0;
            int mx = 0;
            for (int i = 0; i < cmax; ++i) {
                int x = (this.r[rx++ % 16] & 0xFF) << 8 | this.r[rx++ % 16] & 0xFF;
                int y = (m[mx++ % mmax] & 0xFF) << 8 | m[mx++ % mmax] & 0xFF;
                c[i] = (char)(s[i] ^ x ^ y);
            }
            return c;
        }

        private static byte[] getRandomBytes() {
            SecureRandom random = (SecureRandom)tlsRandom.get();
            if (random == null) {
                random = new SecureRandom();
                long seedValue = System.nanoTime() + (long)Thread.currentThread().hashCode();
                random.nextInt();
                random.setSeed(seedValue);
                tlsRandom.set(random);
            }
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return bytes;
        }
    }

    private static class LoggerSetup {
        static AuthnLogger logger = null;

        private LoggerSetup() {
        }

        static {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> cLogger = Class.forName("com.filenet.apiimpl.util.BaseLogger", false, cl);
                logger = new AuthnLogger();
            }
            catch (Exception e) {
                System.out.println("[AuthnUtil] cannot use Logger, enabling System.out logging : " + e.getLocalizedMessage());
                logger = null;
            }
        }
    }

    public static class FnGroup
    implements Group,
    Serializable {
        private static final long serialVersionUID = -7038504939808037682L;
        private final String username;
        private Vector<Principal> members;

        public FnGroup(String username) {
            this.username = username;
        }

        public String getName() {
            return this.username;
        }

        public String toString() {
            return this.username;
        }

        public boolean addMember(Principal user) {
            return this.members.add(user);
        }

        public boolean isMember(Principal member) {
            return this.members.indexOf(member) > -1;
        }

        public Enumeration<? extends Principal> members() {
            return this.members.elements();
        }

        public boolean removeMember(Principal user) {
            return false;
        }
    }

    public static class FnPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 8678357608851249260L;
        private final String username;

        public FnPrincipal(String username) {
            this.username = username;
        }

        @Override
        public String getName() {
            return this.username;
        }

        @Override
        public String toString() {
            return this.username;
        }
    }

    public static class FnCLMPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 9028486114176035031L;
        private final String username;
        private Object clm;

        public FnCLMPrincipal(String username) {
            this.username = username;
            this.clm = null;
        }

        public FnCLMPrincipal(String username, Object clm) {
            this.username = username;
            this.clm = clm;
        }

        @Override
        public String getName() {
            return this.username;
        }

        public Object getCLM() {
            return this.clm;
        }

        public void setCLM(Object clm) {
            this.clm = clm;
        }

        @Override
        public String toString() {
            return this.username;
        }
    }
}

