/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class DynLoginContext {
    private Subject subject;
    private CallbackHandler handler;
    private AppConfigurationEntry[] confs;
    private boolean isDebug;
    private LoginModule[] mods;
    private HashMap sharedState;
    private int nmods;
    private boolean isLogin = false;
    private static final String FNAME = "[DynLoginContext] ";

    public DynLoginContext(Subject subject, CallbackHandler handler, AppConfigurationEntry conf, boolean isDebug) {
        this(subject, handler, new AppConfigurationEntry[]{conf}, isDebug);
    }

    public DynLoginContext(Subject subject, CallbackHandler handler, AppConfigurationEntry[] confs, boolean isDebug) {
        this.subject = subject;
        this.handler = handler;
        this.isDebug = isDebug;
        this.confs = confs;
        this.nmods = confs.length;
        this.mods = new LoginModule[this.nmods];
        this.sharedState = new HashMap();
    }

    public void login() throws LoginException {
        if (this.isLogin) {
            throw new IllegalStateException();
        }
        if (this.subject == null) {
            this.subject = new Subject();
        }
        boolean doomed = false;
        for (int phase = 1; phase <= 2; ++phase) {
            int i;
            Exception firstException = null;
            boolean oneSuccess = false;
            for (i = 0; i < this.nmods; ++i) {
                AppConfigurationEntry.LoginModuleControlFlag flag;
                boolean success;
                block22: {
                    success = false;
                    flag = this.confs[i].getControlFlag();
                    try {
                        if (phase == 1) {
                            LoginModule mod;
                            this.mods[i] = mod = (LoginModule)J2EEAuthnUtil.reflectionConstructor(Class.forName(this.confs[i].getLoginModuleName()));
                            mod.initialize(this.subject, this.handler, this.sharedState, this.confs[i].getOptions());
                            success = mod.login();
                        } else if (this.mods[i] != null) {
                            success = this.mods[i].commit();
                        }
                    }
                    catch (Exception e) {
                        if (firstException != null && (doomed || flag != AppConfigurationEntry.LoginModuleControlFlag.REQUIRED)) break block22;
                        firstException = e;
                    }
                }
                if (!success) {
                    if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        doomed = true;
                        continue;
                    }
                    if (flag != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) continue;
                    doomed = true;
                    break;
                }
                oneSuccess = true;
                if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && !doomed) break;
            }
            if (!doomed && oneSuccess) continue;
            for (i = 0; i < this.nmods; ++i) {
                try {
                    if (this.mods[i] == null) continue;
                    this.mods[i].abort();
                    continue;
                }
                catch (Exception success) {
                    // empty catch block
                }
            }
            String logmsg = this.isDebug ? "[DynLoginContext] JAAS " + (phase == 1 ? "login" : "commit") + " phase failed: " : "";
            String msg = null;
            LoginException ex = null;
            if (firstException == null) {
                msg = ExceptionAuthn.SECURITY_ALL_LOGIN_MODULES_IGNORED.toString();
            } else if (firstException instanceof LoginException) {
                ex = (LoginException)firstException;
                msg = firstException.getLocalizedMessage();
            } else {
                msg = ExceptionAuthn.E_AUTHN_UNEXPECTED_EXCEPTION.toString(new Object[]{firstException.getLocalizedMessage()});
            }
            if (this.isDebug) {
                AuthnUtil.log(logmsg + msg);
            }
            if (ex == null) {
                ex = new LoginException(msg);
                if (firstException != null) {
                    ex.initCause(firstException);
                }
            }
            throw ex;
        }
        if (this.subject == null) {
            throw new LoginException(ExceptionAuthn.SECURITY_FAILED_DEFAULT_TGT_LOGIN.toString(new Object[]{ExceptionAuthn.SECURITY_SUBJECT_NULL.toString()}));
        }
        this.isLogin = true;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new IllegalStateException();
        }
        Exception firstException = null;
        boolean doomed = false;
        boolean oneSuccess = false;
        for (int i = 0; i < this.nmods; ++i) {
            AppConfigurationEntry.LoginModuleControlFlag flag;
            boolean success;
            block14: {
                success = false;
                flag = this.confs[i].getControlFlag();
                if (this.mods[i] == null) continue;
                try {
                    success = this.mods[i].logout();
                }
                catch (Exception e) {
                    if (firstException != null && (doomed || flag != AppConfigurationEntry.LoginModuleControlFlag.REQUIRED)) break block14;
                    firstException = e;
                }
            }
            if (!success) {
                if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    doomed = true;
                    continue;
                }
                if (flag != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) continue;
                doomed = true;
                break;
            }
            oneSuccess = true;
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && !doomed) break;
        }
        if (doomed || !oneSuccess) {
            String logmsg = this.isDebug ? "[DynLoginContext] JAAS logout failed: " : "";
            String msg = null;
            LoginException ex = null;
            if (firstException == null) {
                msg = ExceptionAuthn.SECURITY_ALL_LOGIN_MODULES_IGNORED.toString();
            } else if (firstException instanceof LoginException) {
                ex = (LoginException)firstException;
                msg = firstException.getLocalizedMessage();
            } else {
                msg = ExceptionAuthn.E_AUTHN_UNEXPECTED_EXCEPTION.toString(new Object[]{firstException.getLocalizedMessage()});
            }
            if (this.isDebug) {
                AuthnUtil.log(logmsg + msg);
            }
            if (ex == null) {
                ex = new LoginException(msg);
                if (firstException != null) {
                    ex.initCause(firstException);
                }
            }
            throw ex;
        }
    }

    public static AppConfigurationEntry buildConf(String loginModuleClass, AppConfigurationEntry.LoginModuleControlFlag flag, HashMap options, String[] moreOptions) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (moreOptions != null) {
            for (int i = 0; i < moreOptions.length; ++i) {
                String opt = moreOptions[i];
                int eq = opt.indexOf(61);
                options.put(opt.substring(0, eq), opt.substring(eq + 1));
            }
        }
        return new AppConfigurationEntry(loginModuleClass, flag, options);
    }
}

