/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.constants;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class Charsets {
    public static final Charset CHARSET_US_ASCII = Charset.forName("US-ASCII");
    public static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    public static final Charset CHARSET_UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset CHARSET_UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset CHARSET_UTF_16 = Charset.forName("UTF-16");

    public static byte[] getBytes(String s, Charset ch) {
        try {
            return s.getBytes(ch.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(String s) {
        return Charsets.getBytes(s, CHARSET_UTF_8);
    }

    public static String getString(byte[] b, Charset ch) {
        try {
            return new String(b, ch.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getString(byte[] b) {
        return Charsets.getString(b, CHARSET_UTF_8);
    }

    public static Charset getUTF8Encoding() {
        if (!Charset.isSupported("UTF-8")) {
            return Charset.defaultCharset();
        }
        return CHARSET_UTF_8;
    }
}

