/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.core.ObjectReference;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class DependentIdentity
extends ObjectReferenceBase {
    private ObjectReferenceBase parent;
    private Integer index;
    private String propertyName;
    private boolean isNew = false;
    private static final long serialVersionUID = 8492142620051978010L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_PARENT = 2;
    private static final int NULL_INDEX = 4;
    private static final int ZERO_INDEX = 8;
    private static final int NULL_PROPERTY_NAME = 16;
    private static final int IS_NEW = 32;

    public DependentIdentity() {
    }

    public DependentIdentity(String classIdentity, ObjectReferenceBase parent, String propertyName, Integer index) {
        super(classIdentity);
        this.parent = parent;
        this.propertyName = propertyName;
        this.index = index;
    }

    public DependentIdentity(String classIdentity, EngineObjectImpl eo, String propertyName, Integer index) {
        super(classIdentity);
        this.parent = (ObjectReferenceBase)eo.getObjectReference();
        this.propertyName = propertyName;
        this.index = index;
    }

    public DependentIdentity(String className) {
        super(className);
        this.isNew = true;
    }

    public DependentIdentity(String className, ObjectStoreImpl os) {
        super(className);
        this.isNew = true;
        this.parent = new RepositoryIdentity(null, os, null);
    }

    public void setParentReference(ObjectReferenceBase nParent) {
        this.parent = nParent;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" ");
        sb.append(super.toString());
        sb.append(" Parent=(");
        sb.append(this.parent);
        sb.append(")");
        sb.append(" Index=");
        sb.append(this.index);
        sb.append(" PropertyName=");
        sb.append(this.propertyName);
        sb.append(" IsNew=");
        sb.append(this.isNew);
        return sb.toString();
    }

    public ObjectReference getParentReference() {
        return this.parent;
    }

    @Override
    public GlobalIdentity getObjectStoreReference() {
        if (this.parent != null) {
            return this.parent.getObjectStoreReference();
        }
        return null;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = new Integer(idx);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DependentIdentity)) {
            return false;
        }
        DependentIdentity base = (DependentIdentity)object;
        if (this.index != null && base.index == null || base.index != null && this.index == null) {
            return false;
        }
        if (this.propertyName != null && base.propertyName == null || base.propertyName != null && this.propertyName == null) {
            return false;
        }
        if (this.parent != null && base.parent == null || base.parent != null && this.parent == null) {
            return false;
        }
        if (this.index != null && this.index.intValue() != base.index.intValue()) {
            return false;
        }
        if (this.propertyName != null && !this.propertyName.equalsIgnoreCase(base.propertyName)) {
            return false;
        }
        if (this.parent != null && !this.parent.equals(base.parent)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 37 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 37 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 37 * result + super.hashCode();
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isResolved() {
        boolean parentResolved = this.parent != null ? this.parent.isResolved() : false;
        return parentResolved && !this.isNew;
    }

    @Override
    public String getObjectIdentity() {
        return null;
    }

    @Override
    public String getObjectStoreIdentity() {
        return this.parent != null ? this.parent.getObjectStoreIdentity() : null;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    @Override
    public int getClassType() {
        return 1;
    }

    @Override
    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        flags |= this.parent == null ? 2 : 0;
        flags |= this.index == null ? 4 : 0;
        flags |= this.index != null && this.index == 0 ? 8 : 0;
        flags |= this.propertyName == null ? 16 : 0;
        return flags |= this.isNew ? 32 : 0;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.parent != null) {
            s.putObjectReference(this.parent);
        }
        if (this.index != null && this.index != 0) {
            s.writeInt(this.index);
        }
        if (this.propertyName != null) {
            s.writeObject(this.propertyName);
        }
    }

    @Override
    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.parent = s.getObjectReference();
        }
        if ((flags & 4) == 0) {
            this.index = (flags & 8) == 0 ? new Integer(s.readInt()) : INTEGER_ZERO;
        }
        if ((flags & 0x10) == 0) {
            this.propertyName = (String)s.readObject();
        }
        this.isNew = (flags & 0x20) != 0;
    }

    @Override
    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        DependentIdentity source = (DependentIdentity)src;
        this.parent = source.parent;
        this.index = source.index;
        this.propertyName = source.propertyName;
        this.isNew = source.isNew;
    }
}

