/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.action.Create;
import com.filenet.api.action.Delete;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.DispatchEntries;
import com.filenet.apiimpl.core.IndependentObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.util.ObjectStoreIdUtil;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IndependentlyPersistableObjectImpl
extends IndependentObjectImpl
implements IndependentlyPersistableObject {
    private static final String ACTIVE_SECURITY = "activeSecurity";
    private static final String LockSid = "LockSid";
    private static final String PRELOADED_OBJECT = "preloadedObject";
    private static final String INTRNL_IGNORE_REFLECTIVE_PREVENT_ACTION = "IgnoreReflectivePreventAction";
    private static final String INTRNL_STORAGE_AREA_ID = "StorageAreaId";
    private static final String INTRNL_STORAGE_LOCATION = "StorageLocation";
    private static final String INTRNL_NEXT_CONTENT_UNIQUE_ID = "NextContentUniqueId";
    private static final String INTRNL_CREATE_DATE = "CreateDate";
    private static final String INTRNL_REFERRAL_BLOB = "ReferralBlob";
    private static final String INTRNL_RETENTION_DATE = "RetentionDate";
    private static final String INTRNL_DATE_CONTENT_LAST_ACCESSED = "DateContentLastAccessed";
    private static final String INTRNL_RECOVERY_ORIGINAL_OBJECT_REF = "RecoveryOriginalObjects";
    private static final String INTRNL_RECOVERY_RECOVERY_ITEM_ID = "RecoveryItemId";
    private static final String INTRNL_SLICED_TABLE_PRESENCE = "SlicedTablePresence";
    private static final long serialVersionUID = -2059768931716857892L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    protected IndependentlyPersistableObjectImpl(Connection conn, String className, ObjectReferenceBase newoa) {
        super(conn, className, newoa);
    }

    @Override
    public Boolean isCurrent() {
        return DispatchEntries.IsCurrent_34(this);
    }

    @Override
    public final void delete() {
        this.validateChangePreprocessingOperation("delete");
        this.addPendingAction(new Delete());
    }

    @Override
    public final void save(RefreshMode refreshMode) {
        this.save(refreshMode, null);
    }

    @Override
    public void save(RefreshMode refreshMode, PropertyFilter filter) {
        this.validateChangePreprocessingOperation("save");
        Session session = SessionLocator.getSession(this.getConnection());
        session.executeChange(this, filter, refreshMode);
    }

    public static IndependentlyPersistableObject addCreatePendingAction(IndependentlyPersistableObject ip) {
        return IndependentlyPersistableObjectImpl.addCreatePendingAction(ip, null, null, null, null, null);
    }

    public static IndependentlyPersistableObject addCreatePendingAction(IndependentlyPersistableObject ip, Id objectId) {
        return IndependentlyPersistableObjectImpl.addCreatePendingAction(ip, objectId, null, null, null, null);
    }

    public static IndependentlyPersistableObject addCreatePendingAction(IndependentlyPersistableObject ipo, Id objectId, Boolean autoUniqueContainmentName, ReservationType reservationType, Boolean defineSecurityParentage, Id versionSeriesId) {
        IndependentlyPersistableObjectImpl ip = (IndependentlyPersistableObjectImpl)ipo;
        if (objectId == null && (objectId = ip.getObjectId()) == null) {
            objectId = ObjectStoreIdUtil.createIdForNewObject(ip);
        }
        String objIdStr = objectId.toString();
        String verSerIdStr = versionSeriesId == null ? null : versionSeriesId.toString();
        Create c = new Create(ip.getClassName(), objIdStr, autoUniqueContainmentName, reservationType, defineSecurityParentage, verSerIdStr);
        ip.addPendingAction(c);
        return ip;
    }

    @Override
    public Integer getAccessAllowed() {
        Integer access = this.getInternalAccessAllowed();
        int a = access;
        if ((a & 1) == 0 && (a & 0x80000) != 0) {
            access = a | 1;
        }
        return access;
    }

    public String getIgnoreReflectivePreventAction() {
        return (String)this.internalMembers.get(INTRNL_IGNORE_REFLECTIVE_PREVENT_ACTION);
    }

    public void setIgnoreReflectivePreventAction(String propertyName) {
        this.internalMembers.put(INTRNL_IGNORE_REFLECTIVE_PREVENT_ACTION, propertyName);
    }

    public void setActiveSecurity(Object activeSecurity) {
        this.internalMembers.put(ACTIVE_SECURITY, activeSecurity);
    }

    public Object getActiveSecurity() {
        return this.internalMembers.get(ACTIVE_SECURITY);
    }

    public byte[] getLockSid() {
        byte[] lockSid = null;
        if (this.internalMembers.containsKey(LockSid)) {
            lockSid = (byte[])this.internalMembers.get(LockSid);
        }
        return lockSid;
    }

    public void setLockSid(byte[] lockSid) {
        this.internalMembers.put(LockSid, lockSid);
    }

    public IndependentlyPersistableObjectImpl getPreloadedObject() {
        IndependentlyPersistableObjectImpl preloadedObject = (IndependentlyPersistableObjectImpl)this.internalMembers.get(PRELOADED_OBJECT);
        return preloadedObject;
    }

    public void setPreloadedObject(IndependentlyPersistableObjectImpl preloadedObject) {
        this.internalMembers.put(PRELOADED_OBJECT, preloadedObject);
    }

    public void markAsPreloaded() {
        IndependentlyPersistableObjectImpl preload = (IndependentlyPersistableObjectImpl)this.clone();
        this.internalMembers.put(PRELOADED_OBJECT, preload);
    }

    public Id getInternalStorageAreaId() {
        Object v = this.internalMembers.get(INTRNL_STORAGE_AREA_ID);
        if (v instanceof Id) {
            return (Id)v;
        }
        return null;
    }

    public void setInternalStorageAreaId(Id id) {
        this.internalMembers.put(INTRNL_STORAGE_AREA_ID, id);
    }

    public String getInternalStorageLocation() {
        Object v = this.internalMembers.get(INTRNL_STORAGE_LOCATION);
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public void setInternalStorageLocation(String storageLocation) {
        this.internalMembers.put(INTRNL_STORAGE_LOCATION, storageLocation);
    }

    public Integer getInternalNextContentUniqueId() {
        Object v = this.internalMembers.get(INTRNL_NEXT_CONTENT_UNIQUE_ID);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return null;
    }

    public void setInternalNextContentUniqueId(Integer value) {
        this.internalMembers.put(INTRNL_NEXT_CONTENT_UNIQUE_ID, value);
    }

    public Date getInternalCreateDate() {
        Object v = this.internalMembers.get(INTRNL_CREATE_DATE);
        if (v instanceof Date) {
            return (Date)v;
        }
        return null;
    }

    public void setInternalCreateDate(Date dt) {
        this.internalMembers.put(INTRNL_CREATE_DATE, dt);
    }

    public byte[] getInternalReferralBlob() {
        Object v = this.internalMembers.get(INTRNL_REFERRAL_BLOB);
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        return null;
    }

    public void setInternalReferralBlob(byte[] value) {
        this.internalMembers.put(INTRNL_REFERRAL_BLOB, value);
    }

    public Date getInternalRetentionDate() {
        Object v = this.internalMembers.get(INTRNL_RETENTION_DATE);
        if (v instanceof Date) {
            return (Date)v;
        }
        return null;
    }

    public void setInternalRetentionDate(Date dt) {
        this.internalMembers.put(INTRNL_RETENTION_DATE, dt);
    }

    public Date getInternalDateContentLastAccessed() {
        return (Date)this.internalMembers.get(INTRNL_DATE_CONTENT_LAST_ACCESSED);
    }

    public void setInternalDateContentLastAccessed(Date dt) {
        this.internalMembers.put(INTRNL_DATE_CONTENT_LAST_ACCESSED, dt);
    }

    public void setInternalRecoveryOriginalObjects(List list) {
        this.internalMembers.put(INTRNL_RECOVERY_ORIGINAL_OBJECT_REF, list);
    }

    public List getInternalRecoveryOriginalObjects() {
        return (List)this.internalMembers.get(INTRNL_RECOVERY_ORIGINAL_OBJECT_REF);
    }

    public void setInternalRecoveryItemId(Id id) {
        this.internalMembers.put(INTRNL_RECOVERY_RECOVERY_ITEM_ID, id);
    }

    public Id getInternalRecoveryItemId() {
        return (Id)this.internalMembers.get(INTRNL_RECOVERY_RECOVERY_ITEM_ID);
    }

    public boolean hasInternalSlicedTablePresence(String tableName) {
        ArrayList slicedTableList = (ArrayList)this.internalMembers.get(INTRNL_SLICED_TABLE_PRESENCE);
        if (slicedTableList == null) {
            return false;
        }
        return slicedTableList.contains(tableName.toUpperCase());
    }

    public void addInternalSlicedTablePresence(String tableName) {
        ArrayList<String> slicedTableList = (ArrayList<String>)this.internalMembers.get(INTRNL_SLICED_TABLE_PRESENCE);
        if (slicedTableList == null) {
            slicedTableList = new ArrayList<String>();
            this.internalMembers.put(INTRNL_SLICED_TABLE_PRESENCE, slicedTableList);
        }
        slicedTableList.add(tableName.toUpperCase());
    }
}

