/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class RepositoryIdentity
extends ObjectReferenceBase {
    private GlobalIdentity objectStore;
    private Id id;
    private static final long serialVersionUID = 6631314335763365992L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_OBJECT_STORE = 2;
    private static final int NULL_ID = 4;

    public RepositoryIdentity() {
    }

    public RepositoryIdentity(String classIdentity, ObjectStoreImpl objectStore, Id id) {
        super(classIdentity);
        this.objectStore = objectStore.getObjectStoreReference();
        this.id = id;
    }

    public RepositoryIdentity(String classIdentity, GlobalIdentity objectStore, Id id) {
        super(classIdentity);
        this.objectStore = objectStore;
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("classId=");
        sb.append(this.getClassIdentity());
        sb.append("&objectId=");
        sb.append(this.getObjectIdentity());
        sb.append("&objectStore=");
        sb.append(this.getObjectStoreIdentity());
        return sb.toString();
    }

    @Override
    public GlobalIdentity getObjectStoreReference() {
        return this.objectStore;
    }

    @Override
    public Id getObjectId() {
        return this.id;
    }

    public void setObjectStore(ObjectStoreImpl objectStore) {
        this.objectStore = objectStore.getObjectStoreReference();
    }

    public void setObjectStore(GlobalIdentity objectStore) {
        this.objectStore = objectStore;
    }

    public void setObjectId(Id id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RepositoryIdentity)) {
            return false;
        }
        RepositoryIdentity base = (RepositoryIdentity)object;
        if (this.id != null && base.id == null || base.id != null && this.id == null) {
            return false;
        }
        if (this.objectStore != null && base.objectStore == null || base.objectStore != null && this.objectStore == null) {
            return false;
        }
        if (this.id != null && !this.id.equals(base.id)) {
            return false;
        }
        if (this.objectStore != null && !this.objectStore.equals(base.objectStore)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.objectStore != null ? this.objectStore.hashCode() : 0);
        result = 37 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 37 * result + super.hashCode();
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        RepositoryIdentity that = (RepositoryIdentity)obj;
        int cmp = 0;
        if (this.id != that.id) {
            if (this.id == null) {
                return -1;
            }
            if (that.id == null) {
                return 1;
            }
            cmp = this.id.compareTo(that.id);
            if (cmp != 0) {
                return cmp;
            }
        }
        if (this.objectStore != that.objectStore) {
            if (this.objectStore == null) {
                return -1;
            }
            if (that.objectStore == null) {
                return 1;
            }
            cmp = this.objectStore.compareTo(that.objectStore);
            if (cmp != 0) {
                return cmp;
            }
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public String getObjectIdentity() {
        return this.id != null ? this.id.toString() : null;
    }

    @Override
    public String getObjectStoreIdentity() {
        return this.objectStore != null ? this.objectStore.getObjectIdentity() : null;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    @Override
    public int getClassType() {
        return 5;
    }

    @Override
    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        flags |= this.objectStore == null ? 2 : 0;
        return flags |= this.id == null ? 4 : 0;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.objectStore != null) {
            s.putObjectReference(this.objectStore);
        }
        if (this.id != null) {
            s.putId(this.id);
        }
    }

    @Override
    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.objectStore = (GlobalIdentity)s.getObjectReference();
        }
        if ((flags & 4) == 0) {
            this.id = s.getId();
        }
    }

    @Override
    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        RepositoryIdentity source = (RepositoryIdentity)src;
        this.objectStore = source.objectStore;
        this.id = source.id;
    }
}

