/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.util.CacheMap;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.UsernameToken;
import com.filenet.apiimpl.wsi.WSICredential;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

class AccessCache {
    private final CacheMap usernameScopes = new CacheMap();

    AccessCache() {
    }

    synchronized void setEnabled(boolean enabled) {
        this.usernameScopes.setEnabled(enabled);
    }

    synchronized boolean isAccessible(ScopeKey scopeKey, Subject subject) {
        String username = AccessCache.subjectToPrincipalName(subject);
        if (username == null) {
            return true;
        }
        Set scopeKeys = (Set)this.usernameScopes.getValue(username);
        return scopeKeys != null && scopeKeys.contains(scopeKey);
    }

    synchronized void setAccessible(ScopeKey scopeKey, Subject subject) {
        String username = AccessCache.subjectToPrincipalName(subject);
        if (username == null) {
            return;
        }
        HashSet<ScopeKey> scopeKeys = (HashSet<ScopeKey>)this.usernameScopes.getValue(username);
        if (scopeKeys == null) {
            scopeKeys = new HashSet<ScopeKey>();
            this.usernameScopes.putValue(username, scopeKeys);
        }
        scopeKeys.add(scopeKey);
    }

    synchronized void setTTL(long duration) {
        this.usernameScopes.setTTL(duration);
    }

    synchronized void clear() {
        this.usernameScopes.clear();
    }

    private static String subjectToPrincipalName(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> pset = subject.getPrincipals();
        if (pset == null || pset.isEmpty()) {
            Set<WSICredential> wsiCreds = subject.getPrivateCredentials(WSICredential.class);
            if (wsiCreds == null || wsiCreds.isEmpty()) {
                return null;
            }
            Iterator<WSICredential> itw = wsiCreds.iterator();
            WSICredential wsiCred = itw.next();
            if (wsiCred == null) {
                return null;
            }
            Security token = wsiCred.getSecurityToken();
            if (token == null) {
                return null;
            }
            UsernameToken unt = token.UsernameToken;
            if (unt == null) {
                return null;
            }
            String name = unt.Username;
            return name;
        }
        Iterator<Principal> itp = pset.iterator();
        Principal pr = itp.next();
        if (pr == null) {
            return null;
        }
        String name = pr.getName();
        return name;
    }
}

