/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.meta.CachedClassDescription;
import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.util.ContextCache;
import com.filenet.apiimpl.util.ContextKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

class ClassObjects {
    private final ContextCache cache = new ContextCache();
    private static final Util util = Util.INSTANCE;
    private static final int MAX_ALIASES = 16;

    ClassObjects() {
        this.cache.setMaxAliases(16);
    }

    synchronized CachedClassDescription get(ScopeKey scopeKey, String classIdent) {
        return (CachedClassDescription)this.cache.getValue(this.find(scopeKey, classIdent));
    }

    private ContextKey find(ScopeKey scopeKey, String classIdent) {
        Locale locale = UserContext.get().getLocale();
        ContextKey localeKey = this.cache.find(scopeKey, locale);
        if (localeKey == null) {
            return null;
        }
        ContextKey classKey = this.cache.find(localeKey, classIdent);
        if (classKey != null) {
            return classKey;
        }
        classKey = this.cache.find(localeKey, util.getIdent(classIdent));
        if (classKey != null) {
            this.cache.alias(classKey, new ContextKey(localeKey, classIdent));
            return classKey;
        }
        return null;
    }

    synchronized void put(ScopeKey scopeKey, String classIdent, CachedClassDescription object) {
        String classId = object.get_Id().toString();
        String classGuid = util.getIdent(classId);
        String className = object.get_SymbolicName();
        Locale locale = UserContext.get().getLocale();
        ContextKey localeKey = this.cache.make(scopeKey, locale);
        ContextKey classKey = this.cache.make(localeKey, classGuid);
        this.cache.putValue(classKey, object);
        this.cache.alias(classKey, this.cache.make(localeKey, classId));
        this.cache.alias(classKey, this.cache.make(localeKey, classIdent));
        this.cache.alias(classKey, this.cache.make(localeKey, util.getIdent(classIdent)));
        this.cache.alias(classKey, this.cache.make(localeKey, className));
        this.cache.alias(classKey, this.cache.make(localeKey, util.getIdent(className)));
    }

    synchronized void remove(ScopeKey scopeKey, String classIdent) {
        this.cache.remove(this.find(scopeKey, classIdent));
    }

    synchronized Map getAllScopeClassIdents() {
        HashMap<InstantiatingScope, HashSet<String>> map = new HashMap<InstantiatingScope, HashSet<String>>();
        Object[] values = this.cache.getValues();
        for (int i = 0; i < values.length; ++i) {
            CachedClassDescription cd = (CachedClassDescription)values[i];
            InstantiatingScope scope = cd.getInstantiatingScope();
            String classIdent = cd.getObjectReference().getClassIdentity();
            HashSet<String> classIdents = (HashSet<String>)map.get(scope);
            if (classIdents == null) {
                classIdents = new HashSet<String>();
                map.put(scope, classIdents);
            }
            classIdents.add(classIdent);
        }
        return map;
    }

    synchronized boolean isEnabled() {
        return this.cache.isEnabled();
    }

    synchronized void setEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
        if (!enabled) {
            this.clear();
        }
    }

    synchronized void setTTL(long duration) {
        this.cache.setTTL(duration);
    }

    synchronized void clear() {
        this.cache.clear();
    }
}

