/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.meta.ConnectionKeys;
import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.util.ContextCache;
import com.filenet.apiimpl.util.ContextKey;

class ScopeKeys {
    private final ConnectionKeys connectionKeys = new ConnectionKeys();
    private final ContextCache domains = new ContextCache();
    private final ContextCache stores = new ContextCache();
    private static final Util util = Util.INSTANCE;
    private static final int MAX_DOMAINS = 32;
    private static final int MAX_STORES = 128;
    private static final int MAX_ALIASES = 16;
    private static final PropertyFilter DOMAIN_FILTER = new PropertyFilter();
    private static final PropertyFilter STORE_FILTER = new PropertyFilter();

    ScopeKeys() {
        this.domains.setLRUMaxSize(32);
        this.domains.setMaxAliases(16);
        this.stores.setLRUMaxSize(128);
        this.stores.setMaxAliases(16);
    }

    synchronized void setEnabled(boolean enabled) {
        this.connectionKeys.setEnabled(enabled);
        this.domains.setEnabled(enabled);
        this.stores.setEnabled(enabled);
    }

    synchronized void setTTL(long duration) {
        this.connectionKeys.setTTL(duration);
        this.domains.setTTL(duration);
        this.stores.setTTL(duration);
    }

    synchronized void clear() {
        this.connectionKeys.clear();
        this.domains.clear();
        this.stores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScopeKey get(InstantiatingScope scope) {
        String name;
        String guid;
        Domain domain;
        ScopeKey scopeKey;
        ContextKey contextKey;
        Class type = util.getClassInstance(scope);
        IndependentObject object = (IndependentObject)((Object)scope);
        ConnectionImpl connection = util.getConnection(object);
        String oid = object.getObjectReference().getObjectIdentity();
        String uri = this.connectionKeys.get(connection.getURI());
        ContextCache contexts = type == Domain.class ? this.domains : this.stores;
        ScopeKeys scopeKeys = this;
        synchronized (scopeKeys) {
            contextKey = contexts.find(uri, oid);
            scopeKey = (ScopeKey)contexts.getValue(contextKey);
            if (scopeKey != null) {
                return scopeKey;
            }
            String ident = util.getIdent(oid);
            contextKey = contexts.find(uri, ident);
            scopeKey = (ScopeKey)contexts.getValue(contextKey);
            if (scopeKey != null) {
                contexts.alias(contextKey, new ContextKey(uri, oid));
                return scopeKey;
            }
            if (Id.isId(ident)) {
                contextKey = new ContextKey(uri, ident);
                scopeKey = new ScopeKey(uri, type, ident);
                contexts.putValue(contextKey, scopeKey);
                contexts.alias(contextKey, contextKey);
                contexts.alias(contextKey, new ContextKey(uri, oid));
                return scopeKey;
            }
        }
        String display = null;
        if (type == Domain.class) {
            domain = Factory.Domain.fetchInstance(connection, oid, DOMAIN_FILTER);
            guid = domain.get_Id().toString();
            name = domain.get_Name();
        } else {
            domain = (Domain)((EngineObjectImpl)((Object)scope)).getScope();
            ObjectStore store = Factory.ObjectStore.fetchInstance(domain, oid, STORE_FILTER);
            guid = store.get_Id().toString();
            name = store.get_SymbolicName();
            display = store.get_DisplayName();
        }
        String ident = util.getIdent(guid);
        contextKey = new ContextKey(uri, ident);
        scopeKey = new ScopeKey(uri, type, ident);
        ScopeKeys scopeKeys2 = this;
        synchronized (scopeKeys2) {
            contexts.putValue(contextKey, scopeKey);
            contexts.alias(contextKey, contextKey);
            contexts.alias(contextKey, contexts.make(uri, guid));
            contexts.alias(contextKey, contexts.make(uri, oid));
            contexts.alias(contextKey, contexts.make(uri, util.getIdent(oid)));
            contexts.alias(contextKey, contexts.make(uri, name));
            contexts.alias(contextKey, contexts.make(uri, util.getIdent(name)));
            if (display != null) {
                contexts.alias(contextKey, contexts.make(uri, display));
                contexts.alias(contextKey, contexts.make(uri, util.getIdent(display)));
            }
        }
        return scopeKey;
    }

    static {
        DOMAIN_FILTER.addIncludeProperty(0, null, null, "Id Name ", null);
        STORE_FILTER.addIncludeProperty(0, null, null, "Id SymbolicName DisplayName ", null);
    }
}

