/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.authentication.Credentials;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ExtendedInputStream;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.ContentElementInfoData;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.UniToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClientInputStream
extends ExtendedInputStream {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ClientInputStream.class, SubSystem.API);
    private static final BaseLogger cstgLogger = BaseLogger.getBaseLogger(ClientInputStream.class, SubSystem.ContentStorage);
    private ConnectionImpl connection;
    private ObjectReferenceBase source;
    private Integer elementSequenceNumber;
    private String continueFrom;
    private byte[] content;
    private InputStream contentAsStream;
    private Long totalSize;
    private transient ContentElementInfoData ceiData = null;
    private transient int curPosInByteBuffer = 0;
    private transient long curReadPosition = 0L;
    private transient long nextReadPosition = 0L;
    private transient long currentChunkBeginningOffset = 0L;
    private transient boolean isClosed = false;
    private transient boolean inUse = false;
    private transient Session session = null;
    private transient UniToken uniToken = null;
    private Credentials originalCredentials;
    private static final String OKEY = "offset=";

    public ClientInputStream() {
        this.initOriginalCredentials();
    }

    public ClientInputStream(ConnectionImpl connection, ObjectReferenceBase source, Integer elementSequenceNumber, String continueFrom, byte[] content, Long totalSize) {
        this.connection = connection;
        this.source = source;
        this.elementSequenceNumber = elementSequenceNumber;
        this.continueFrom = continueFrom;
        this.content = content;
        this.totalSize = totalSize != null && totalSize < 0L ? null : totalSize;
        this.initOriginalCredentials();
        if (logger.isDetailTraceEnabled() || cstgLogger.isDetailTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("cookie='").append(this.continueFrom).append("', ");
            sb.append("totalSize=").append(this.totalSize).append(", ");
            sb.append("bsize=").append(this.content == null ? null : Integer.valueOf(this.content.length)).append(", ");
            sb.append("esn=").append(this.elementSequenceNumber).append(", ");
            sb.append("src='").append(this.source).append("', ");
            sb.append("conn='").append(this.connection == null ? null : this.connection.getURI()).append("', ");
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("B new " + this.getClass().getSimpleName() + " " + sb);
            } else {
                cstgLogger.traceDetail("B new " + this.getClass().getSimpleName() + " " + sb);
            }
        }
    }

    public ClientInputStream(ConnectionImpl connection, ObjectReferenceBase source, Integer elementSequenceNumber, String continueFrom, InputStream contentStream, Long totalSize, Integer bufferedSize) {
        this.connection = connection;
        this.source = source;
        this.elementSequenceNumber = elementSequenceNumber;
        this.continueFrom = continueFrom;
        this.contentAsStream = contentStream;
        this.totalSize = totalSize != null && totalSize < 0L ? null : totalSize;
        if (bufferedSize != null && bufferedSize > 0) {
            this.content = this.getContent();
            if (this.content.length != bufferedSize) {
                if (source != null) {
                    throw new EngineRuntimeException(ExceptionCode.API_CONTENT_STREAM_TO_BYTES_SIZE_MISMATCH, new Object[]{(int)bufferedSize, this.content.length}, ExceptionContext.CONTENT_OBJECT, new Object[]{source.getObjectId(), elementSequenceNumber});
                }
                throw new EngineRuntimeException(ExceptionCode.API_CONTENT_STREAM_TO_BYTES_SIZE_MISMATCH, new Object[]{(int)bufferedSize, this.content.length});
            }
        }
        this.initOriginalCredentials();
        if (logger.isDetailTraceEnabled() || cstgLogger.isDetailTraceEnabled()) {
            int available = 0;
            boolean traceAvailable = ConfigValueLookup.getValueAsBoolean("Content.LogClientInputStreamAvailableSize", false);
            if (traceAvailable) {
                try {
                    available = this.content != null ? this.content.length : contentStream.available();
                }
                catch (IOException e) {
                    available = -2;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("cookie='").append(this.continueFrom).append("', ");
            sb.append("totalSize='").append(this.totalSize).append("', ");
            if (traceAvailable) {
                sb.append("iavail='").append(available).append("', ");
            }
            sb.append("esn='").append(this.elementSequenceNumber).append("', ");
            sb.append("src='").append(this.source).append("', ");
            sb.append("conn='").append(this.connection == null ? null : this.connection.getURI()).append("', ");
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("I new " + this.getClass().getSimpleName() + " " + sb);
            } else {
                cstgLogger.traceDetail("I new " + this.getClass().getSimpleName() + " " + sb);
            }
        }
    }

    public Integer getBufferedSize() {
        if (this.content == null || this.content.length == 0) {
            return null;
        }
        return this.content.length;
    }

    public Credentials getOriginalCredentials() {
        return this.originalCredentials;
    }

    public void setOriginalCredentials(Credentials creds) {
        this.originalCredentials = creds;
    }

    public void initOriginalCredentials() {
        this.originalCredentials = Credentials.getCurrent();
    }

    public void setConnection(ConnectionImpl conn) {
        this.connection = conn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setSession(Session sess) {
        this.session = sess;
    }

    public void setUniToken(UniToken tok) {
        this.uniToken = tok;
    }

    public void setContentElementInfoData(ContentElementInfoData ceiData) {
        this.ceiData = ceiData;
    }

    public ObjectReferenceBase getSource() {
        return this.source;
    }

    public Integer getElementSequenceNumber() {
        return this.elementSequenceNumber;
    }

    public byte[] getContent() {
        this.checkClosedRuntime();
        try {
            if (this.contentAsStream != null) {
                this.content = ClientInputStream.gatherStreamToBytes(this.contentAsStream);
                this.curReadPosition = 0L;
                this.nextReadPosition = 0L;
                this.contentAsStream = null;
            }
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return this.content;
    }

    public InputStream getContentAsStream() {
        this.checkClosedRuntime();
        if (this.contentAsStream != null) {
            return this.contentAsStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return null;
    }

    public Long getTotalSize() {
        return this.totalSize;
    }

    public String getContinueFrom() {
        return this.continueFrom;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        this.checkClosedIO();
        if (this.nextReadPosition == -1L) {
            return -1;
        }
        if (null != this.contentAsStream) {
            return this.fillBufferFromStream(buffer, off, len);
        }
        return this.fillBuffer(buffer, off, len);
    }

    @Override
    public int readAt(long position, byte[] buffer, int off, int len) throws IOException {
        this.checkClosedIO();
        if (this.sizeSupported() && position >= this.size()) {
            this.nextReadPosition = -1L;
            return -1;
        }
        this.position(position);
        if (null != this.contentAsStream) {
            return this.fillBufferFromStream(buffer, off, len);
        }
        return this.fillBufferExactly(buffer, off, len);
    }

    private int fillBufferFromStream(byte[] buffer, int off, int len) throws IOException {
        if (this.curReadPosition != this.nextReadPosition) {
            this.positionStream(true);
        }
        if (this.nextReadPosition == -1L) {
            return -1;
        }
        int totalBytesRead = -1;
        while (totalBytesRead < len) {
            int read;
            int readLength = len;
            if (totalBytesRead > 0) {
                readLength -= totalBytesRead;
            }
            if ((read = this.contentAsStream.read(buffer, off, readLength)) > 0) {
                this.curReadPosition += (long)read;
                this.nextReadPosition = this.curReadPosition;
            }
            if (-1 == read) {
                if (null != this.continueFrom) {
                    this.nextChunk(this.continueFrom, null, null);
                    read = this.contentAsStream.read(buffer, off, readLength);
                    if (read > 0) {
                        this.curReadPosition += (long)read;
                        this.nextReadPosition = this.curReadPosition;
                    }
                } else {
                    this.nextReadPosition = -1L;
                    break;
                }
            }
            if (-1 == totalBytesRead) {
                totalBytesRead = 0;
            }
            if (-1 == read) continue;
            totalBytesRead += read;
            off += read;
        }
        return totalBytesRead;
    }

    private void positionStream(boolean mustSucceed) throws IOException {
        if (this.curReadPosition == this.nextReadPosition) {
            return;
        }
        if (this.sizeSupported() && this.nextReadPosition >= this.size()) {
            this.nextReadPosition = -1L;
            this.curReadPosition = this.size();
            return;
        }
        if (this.contentAsStream instanceof ExtendedInputStream) {
            ((ExtendedInputStream)this.contentAsStream).position(this.nextReadPosition);
            this.curReadPosition = ((ExtendedInputStream)this.contentAsStream).position();
            if (this.curReadPosition != this.nextReadPosition) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("ClientInputStream.positionStream: Attempted to position stream to offset " + this.nextReadPosition + " but was only able to set it to offset " + this.curReadPosition + ".  This may be due to attempting to position past EOF.");
                } else if (cstgLogger.isDetailTraceEnabled()) {
                    cstgLogger.traceDetail("ClientInputStream.positionStream: Attempted to position stream to offset " + this.nextReadPosition + " but was only able to set it to offset " + this.curReadPosition + ".  This may be due to attempting to position past EOF.");
                }
                this.nextReadPosition = this.curReadPosition;
            }
        } else if (this.nextReadPosition > this.curReadPosition) {
            long origReadPosition = this.curReadPosition;
            long amountSkipped = 0L;
            do {
                long skipAmount = this.nextReadPosition - this.curReadPosition;
                amountSkipped = this.contentAsStream.skip(skipAmount);
                this.curReadPosition += amountSkipped;
            } while (this.curReadPosition < this.nextReadPosition && amountSkipped > 0L);
            if (this.curReadPosition != this.nextReadPosition) {
                byte[] buf = new byte[32768];
                int numRead = this.contentAsStream.read(buf);
                if (numRead > 0) {
                    this.curReadPosition += (long)numRead;
                    while (numRead > 0 && this.curReadPosition < this.nextReadPosition) {
                        numRead = this.contentAsStream.read(buf);
                        if (numRead <= 0) continue;
                        this.curReadPosition += (long)numRead;
                    }
                }
                if (numRead < 0) {
                    this.nextReadPosition = -1L;
                    return;
                }
                if (this.curReadPosition != this.nextReadPosition) {
                    if (mustSucceed) {
                        long expectedSkipAmount = this.nextReadPosition - origReadPosition;
                        long actualSkipAmount = this.curReadPosition - origReadPosition;
                        throw new EngineRuntimeException(ExceptionCode.CONTENT_CA_SKIP_FAILED, new Object[]{expectedSkipAmount, actualSkipAmount});
                    }
                    if (logger.isModerateTraceEnabled()) {
                        logger.traceModerate("ClientInputStream: Unable to postion stream to desired offset of " + this.nextReadPosition + ".  Current offset is " + this.curReadPosition + "after skipping " + (this.curReadPosition - origReadPosition) + " bytes.");
                    } else if (cstgLogger.isModerateTraceEnabled()) {
                        cstgLogger.traceModerate("ClientInputStream: Unable to postion stream to desired offset of " + this.nextReadPosition + ".  Current offset is " + this.curReadPosition + "after skipping " + (this.curReadPosition - origReadPosition) + " bytes.");
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException("Not an ExtendedInputStream");
        }
    }

    private int fillBuffer(byte[] buffer, int off, int len) throws IOException {
        if (this.curReadPosition != this.nextReadPosition) {
            this.positionByteBuffer(null);
        }
        if (this.nextReadPosition == -1L) {
            return -1;
        }
        int bytesRead = -1;
        while (bytesRead < len) {
            if (null == this.content && null != this.continueFrom) {
                this.nextChunk(this.continueFrom, null, null);
            }
            if (this.content == null || this.content.length <= 0) {
                return bytesRead;
            }
            if (this.curPosInByteBuffer >= this.content.length) {
                if (this.continueFrom != null) {
                    this.nextChunk(this.continueFrom, null, null);
                    if (this.content == null || this.content.length <= 0) {
                        return bytesRead;
                    }
                } else {
                    return bytesRead;
                }
            }
            if (-1 == bytesRead) {
                bytesRead = 0;
            }
            int read = Math.min(len - bytesRead, this.content.length - this.curPosInByteBuffer);
            System.arraycopy(this.content, this.curPosInByteBuffer, buffer, off, read);
            off += read;
            this.curPosInByteBuffer += read;
            bytesRead += read;
            this.curReadPosition += (long)read;
            this.nextReadPosition = this.curReadPosition;
        }
        return bytesRead;
    }

    private int fillBufferExactly(byte[] buffer, int off, int len) throws IOException {
        if (this.curReadPosition != this.nextReadPosition) {
            this.positionByteBuffer(len);
        }
        if (this.nextReadPosition == -1L) {
            return -1;
        }
        int bytesRead = -1;
        while (bytesRead < len) {
            if (null == this.content && null != this.continueFrom) {
                this.nextChunk(this.continueFrom, null, len);
            }
            if (this.content == null || this.content.length <= 0) {
                return bytesRead;
            }
            if (this.curPosInByteBuffer >= this.content.length) {
                if (this.continueFrom != null) {
                    int remainingLength = len;
                    if (bytesRead > 0) {
                        remainingLength = len - bytesRead;
                    }
                    this.nextChunk(this.continueFrom, null, remainingLength);
                    if (this.content == null || this.content.length <= 0) {
                        return bytesRead;
                    }
                } else {
                    return bytesRead;
                }
            }
            if (-1 == bytesRead) {
                bytesRead = 0;
            }
            int read = Math.min(len - bytesRead, this.content.length - this.curPosInByteBuffer);
            System.arraycopy(this.content, this.curPosInByteBuffer, buffer, off, read);
            off += read;
            this.curPosInByteBuffer += read;
            bytesRead += read;
            this.curReadPosition += (long)read;
            this.nextReadPosition = this.curReadPosition;
        }
        return bytesRead;
    }

    private void positionByteBuffer(Integer chunkSize) throws IOException {
        if (this.curReadPosition == this.nextReadPosition) {
            return;
        }
        if (this.sizeSupported() && this.nextReadPosition >= this.size()) {
            this.nextReadPosition = -1L;
            this.curReadPosition = this.size();
            return;
        }
        if (this.content == null || this.content.length <= 0) {
            this.nextChunk(this.continueFrom, this.nextReadPosition, chunkSize);
            if ((this.content == null || this.content.length <= 0) && this.continueFrom == null) {
                this.nextReadPosition = -1L;
            }
            return;
        }
        if (this.nextReadPosition >= this.currentChunkBeginningOffset && this.nextReadPosition < this.currentChunkBeginningOffset + (long)this.content.length) {
            this.curPosInByteBuffer = (int)(this.nextReadPosition - this.currentChunkBeginningOffset);
            this.curReadPosition = this.nextReadPosition;
        } else {
            this.nextChunk(this.continueFrom, this.nextReadPosition, chunkSize);
            if ((this.content == null || this.content.length <= 0) && this.continueFrom == null) {
                this.nextReadPosition = -1L;
            }
        }
    }

    private void nextChunk(String contFrom, Long startOffset, Integer chunkSize) throws IOException {
        this.checkClosedRuntime();
        if (this.contentAsStream != null) {
            this.contentAsStream.close();
        }
        if (this.session == null) {
            this.session = SessionLocator.getSession(this.connection);
            this.session.beginGetContentSession(this.connection);
        }
        this.currentChunkBeginningOffset = startOffset != null ? startOffset.longValue() : this.getOffset(contFrom);
        if (logger.isDetailTraceEnabled() || cstgLogger.isDetailTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("cookie='").append(contFrom).append("', ");
            sb.append("startOffset='").append(startOffset).append("', ");
            sb.append("totalSize=").append(this.totalSize).append(", ");
            sb.append("chunkSize=").append(chunkSize).append(", ");
            sb.append("esn=").append(this.elementSequenceNumber).append(", ");
            sb.append("src='").append(this.source).append("', ");
            sb.append("conn='").append(this.connection == null ? null : this.connection.getURI()).append("', ");
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("get chunk " + this.getClass().getSimpleName() + " " + sb);
            } else {
                cstgLogger.traceDetail("get chunk " + this.getClass().getSimpleName() + " " + sb);
            }
        }
        Credentials fallbackCredentials = this.originalCredentials;
        if (this.uniToken != null) {
            UniToken renewedToken = this.uniToken.renew();
            if (renewedToken == null) {
                throw new EngineRuntimeException(ExceptionCode.E_NOT_AUTHENTICATED);
            }
            this.uniToken = renewedToken;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientInputStream: original credentials=" + fallbackCredentials);
            } else if (cstgLogger.isDetailTraceEnabled()) {
                cstgLogger.traceDetail("ClientInputStream: original credentials=" + fallbackCredentials);
            }
            fallbackCredentials = null;
        }
        ClientInputStream res = this.session.getContentStream(this.connection, fallbackCredentials, this.source, this.elementSequenceNumber, startOffset, this.totalSize, chunkSize, contFrom, this.ceiData);
        if (this.uniToken != null) {
            this.uniToken.destroy();
        }
        this.source = res.source;
        this.elementSequenceNumber = res.elementSequenceNumber;
        this.continueFrom = res.continueFrom;
        this.totalSize = res.totalSize;
        this.content = res.content;
        this.contentAsStream = res.contentAsStream;
        this.curPosInByteBuffer = 0;
        if (this.totalSize != null && this.currentChunkBeginningOffset > this.totalSize) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientInputStream: Resetting currentChunkBeginningOffset [" + this.currentChunkBeginningOffset + "] to match totalSize [" + this.totalSize + "]");
            } else if (cstgLogger.isDetailTraceEnabled()) {
                cstgLogger.traceDetail("ClientInputStream: Resetting currentChunkBeginningOffset [" + this.currentChunkBeginningOffset + "] to match totalSize [" + this.totalSize + "]");
            }
            this.currentChunkBeginningOffset = this.totalSize;
        }
        this.curReadPosition = this.currentChunkBeginningOffset;
        this.nextReadPosition = this.currentChunkBeginningOffset;
    }

    @Override
    public int available() throws IOException {
        this.checkClosedIO();
        if (this.contentAsStream != null) {
            return this.contentAsStream.available();
        }
        if (this.content == null || this.content.length <= 0 || this.content.length - this.curPosInByteBuffer <= 0) {
            return 0;
        }
        return this.content.length - this.curPosInByteBuffer;
    }

    public static byte[] gatherStreamToBytes(InputStream istr) throws IOException {
        if (istr == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] blob = new byte[32768];
        int len = istr.read(blob);
        while (len > 0) {
            out.write(blob, 0, len);
            len = istr.read(blob);
        }
        istr.close();
        return out.toByteArray();
    }

    public void setInUse() {
        this.inUse = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.connection = null;
        this.source = null;
        this.content = null;
        this.curPosInByteBuffer = -1;
        if (this.contentAsStream != null) {
            this.contentAsStream.close();
            this.contentAsStream = null;
        }
        if (this.session != null) {
            this.session.finishGetContentSession(this.connection);
            this.session = null;
        }
        if (this.uniToken != null) {
            this.uniToken.destroy();
        }
        super.close();
    }

    private void checkClosedRuntime() throws EngineRuntimeException {
        if (this.isClosed) {
            throw new EngineRuntimeException(ExceptionCode.E_CLOSED_STREAM, null);
        }
    }

    private void checkClosedIO() throws IOException {
        if (this.isClosed) {
            throw new IOException(ExceptionCode.E_CLOSED_STREAM.toString(null));
        }
    }

    @Override
    public long position() throws IOException {
        return this.nextReadPosition;
    }

    @Override
    public void position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            if (this.source != null) {
                throw new EngineRuntimeException(ExceptionCode.API_EXTENDED_STREAM_INVALID_POSITION, new Object[]{newPosition}, ExceptionContext.CONTENT_OBJECT, new Object[]{this.source.getObjectId(), this.elementSequenceNumber});
            }
            throw new EngineRuntimeException(ExceptionCode.API_EXTENDED_STREAM_INVALID_POSITION, new Object[]{newPosition});
        }
        this.nextReadPosition = newPosition;
    }

    @Override
    public boolean sizeSupported() {
        if (this.totalSize != null && this.totalSize >= 0L) {
            return true;
        }
        if (null != this.contentAsStream && this.contentAsStream instanceof ExtendedInputStream) {
            return ((ExtendedInputStream)this.contentAsStream).sizeSupported();
        }
        return false;
    }

    @Override
    public long size() throws IOException {
        if (this.totalSize != null && this.totalSize >= 0L) {
            return this.totalSize;
        }
        if (null != this.contentAsStream && this.contentAsStream instanceof ExtendedInputStream) {
            return ((ExtendedInputStream)this.contentAsStream).size();
        }
        if (this.source != null) {
            throw new EngineRuntimeException(ExceptionCode.API_EXTENDED_STREAM_SIZE_UNAVAILABLE, null, ExceptionContext.CONTENT_OBJECT, new Object[]{this.source.getObjectId(), this.elementSequenceNumber});
        }
        throw new EngineRuntimeException(ExceptionCode.API_EXTENDED_STREAM_SIZE_UNAVAILABLE, null);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.nextReadPosition == -1L) {
            return 0L;
        }
        long attemptSkipped = n;
        long prevNextPosition = this.nextReadPosition;
        this.nextReadPosition += n;
        if (this.sizeSupported() && this.nextReadPosition > this.size()) {
            this.nextReadPosition = this.size();
            attemptSkipped = this.nextReadPosition - prevNextPosition;
        }
        if (this.contentAsStream != null) {
            this.positionStream(false);
        } else {
            this.positionByteBuffer(null);
        }
        long actualSkipped = this.curReadPosition - prevNextPosition;
        if (actualSkipped != attemptSkipped) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientInputStream: attempted to skip " + attemptSkipped + " bytes, but only skipped " + actualSkipped + " bytes.");
            } else if (cstgLogger.isDetailTraceEnabled()) {
                cstgLogger.traceDetail("ClientInputStream: attempted to skip " + attemptSkipped + " bytes, but only skipped " + actualSkipped + " bytes.");
            }
        }
        return actualSkipped;
    }

    private long getOffset(String cookie) {
        if (cookie == null) {
            return 0L;
        }
        String[] items = cookie.split(";");
        if (items == null) {
            return 0L;
        }
        for (int ii = 0; ii < items.length; ++ii) {
            String item = items[ii];
            if (!item.startsWith(OKEY)) continue;
            String value = item.substring(OKEY.length());
            long offset = Long.parseLong(value);
            return offset;
        }
        return 0L;
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.putObjectReference(this.source);
        s.writeObject(this.elementSequenceNumber);
        s.writeObject(this.continueFrom);
        s.writeObject(this.getContent());
        s.writeObject(this.totalSize);
    }

    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.connection = (ConnectionImpl)conn;
        this.source = s.getObjectReference();
        this.elementSequenceNumber = (Integer)s.readObject();
        this.continueFrom = (String)s.readObject();
        this.content = (byte[])s.readObject();
        this.totalSize = (Long)s.readObject();
        this.isClosed = false;
        this.inUse = false;
        this.ceiData = null;
        this.session = null;
        this.uniToken = null;
        this.curPosInByteBuffer = 0;
        this.curReadPosition = 0L;
        this.nextReadPosition = 0L;
        this.currentChunkBeginningOffset = 0L;
        if (logger.isDetailTraceEnabled() || cstgLogger.isDetailTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("cookie='").append(this.continueFrom).append("', ");
            sb.append("totalSize=").append(this.totalSize).append(", ");
            sb.append("bsize=").append(this.content == null ? null : Integer.valueOf(this.content.length)).append(", ");
            sb.append("esn=").append(this.elementSequenceNumber).append(", ");
            sb.append("src='").append(this.source).append("', ");
            sb.append("conn='").append(this.connection == null ? null : this.connection.getURI()).append("', ");
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("D new " + this.getClass().getSimpleName() + " " + sb);
            } else {
                cstgLogger.traceDetail("D new " + this.getClass().getSimpleName() + " " + sb);
            }
        }
    }
}

