/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.property.PropertyIndependentObjectSet;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;

public class PropertyEngineObjectSetImpl
extends PropertyImpl
implements PropertyIndependentObjectSet {
    private static final long serialVersionUID = -3592494494688626283L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public PropertyEngineObjectSetImpl(String propertyName, IndependentObjectSet val, byte access) {
        super(propertyName, val, access);
        if (this.value == null) {
            this.value = new SubSetImpl(EngineObjectImpl.class, (ArrayList)null);
        }
    }

    public PropertyEngineObjectSetImpl(UnevaluatedPropertyValue obj, Connection connection, byte access) {
        super(obj.getPropertyName(), obj, access);
        this.connection = connection;
    }

    public PropertyEngineObjectSetImpl(PropertyEngineObjectSetImpl source) {
        super(source);
    }

    @Override
    public final IndependentObjectSet fetchIndependentObjectSetValue(PropertyFilter pf) {
        return this.fetchIndependentObjectSetValue(pf, null);
    }

    @Override
    public final IndependentObjectSet fetchIndependentObjectSetValue(PropertyFilter pf, int pageSize) {
        Integer size = pageSize > 0 ? new Integer(pageSize) : null;
        return this.fetchIndependentObjectSetValue(pf, size);
    }

    protected IndependentObjectSet fetchIndependentObjectSetValue(PropertyFilter pf, Integer pageSize) {
        IndependentObjectSet set = this.fetchIndependentObjectSetValue(this.value, pf, pageSize);
        this.value = set;
        return set;
    }

    protected IndependentObjectSet fetchIndependentObjectSetValue(Object value, PropertyFilter pf, Integer pageSize) {
        if (value == null) {
            return null;
        }
        if (value instanceof SubSetImpl && ((SubSetImpl)value).isEmpty()) {
            return (IndependentObjectSet)value;
        }
        if (!(value instanceof UnevaluatedPropertyValue)) {
            throw new EngineRuntimeException(ExceptionCode.API_EXPECTED_UNEVALUATED_STATE, this.getPropertyName());
        }
        PropertyImpl tProp = this.getSession().getProperty((ConnectionImpl)this.connection, (UnevaluatedPropertyValue)value, null, pf, pageSize);
        value = tProp != null ? tProp.value : null;
        return (IndependentObjectSet)value;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    PropertyImpl getModifiedData(EngineObject parent) {
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    }

    @Override
    public int getSerializeMask() {
        return super.getSerializeMask() | 0x400000 | 7;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.putObject(this.value);
    }

    @Override
    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.value = s.getObject();
        this.connection = conn;
    }
}

