/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query.parser;

import com.filenet.apiimpl.query.parser.Node;
import com.filenet.apiimpl.query.parser.QueryParser;
import com.filenet.apiimpl.query.parser.QueryParserConstants;
import com.filenet.apiimpl.query.parser.QueryParserTreeConstants;
import com.filenet.apiimpl.query.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected QueryParser parser;
    String m_text;
    Token first;
    Token last;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(QueryParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getText() {
        return this.m_text;
    }

    public String toString() {
        if (this.m_text != null) {
            return this.getNodeName() + "[" + this.m_text + "]";
        }
        return this.getNodeName();
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public String token(int i) {
        return QueryParserConstants.tokenImage[i];
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public String tsField(String field, String value) {
        String ts = new String();
        if (value != null && value.length() > 0) {
            ts = ts + " " + field + ": " + value;
        }
        return ts;
    }

    public String tsBoolean(boolean test, String commentary) {
        String ts = new String();
        if (test) {
            ts = " " + commentary;
        }
        return ts;
    }

    public String tsBooleanNot(boolean test, String commentary) {
        return this.tsBoolean(!test, commentary);
    }

    public String getNodeName() {
        return QueryParserTreeConstants.jjtNodeName[this.id];
    }

    @Override
    public int getNodeType() {
        return this.id;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    public int getFirstLine() {
        return this.first.beginLine;
    }

    public int getLastLine() {
        return this.last.endLine;
    }

    public int getFirstColumn() {
        return this.first.beginColumn;
    }

    public int getLastColumn() {
        return this.last.endColumn;
    }
}

