/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.util.ConfigValueLookup;

public class PerformanceTimer {
    private static final int TIMER_MODE_DUAL = 1;
    private static final int TIMER_MODE_MILLIS = 2;
    private static final int TIMER_MODE_NANOS = 3;
    private static int timerMode = ConfigValueLookup.getValueAsInt("com.filenet.apiimpl.smm.timerMode", 1);
    private long startNanoTicks = 0L;
    private long stopNanoTicks = 0L;
    private long startMilliTicks = 0L;
    private long stopMilliTicks = 0L;

    private static long getNanoTime() {
        return System.nanoTime();
    }

    private static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    private double getElapsedNanoTime() {
        double elapsedTime = (double)(this.stopNanoTicks - this.startNanoTicks) / 1000000.0;
        double elapsedTimeMillis = this.getElapsedCurrentTimeMillis();
        if (elapsedTime < 0.0 || Math.abs(elapsedTimeMillis - elapsedTime) > 120.0) {
            elapsedTime = elapsedTimeMillis;
            if (timerMode != 3) {
                timerMode = 2;
                System.out.println("com.filenet.apiimpl.smm.PerformanceTimer - getElapsedNanoTime() encountered negative or skewed time, switching to millisecond accuracy.");
            }
        }
        return elapsedTime;
    }

    private double getElapsedCurrentTimeMillis() {
        if (this.stopMilliTicks > this.startMilliTicks) {
            return this.stopMilliTicks - this.startMilliTicks;
        }
        return 0.0;
    }

    protected static long getMillis() {
        if (timerMode == 2) {
            return PerformanceTimer.getCurrentTimeMillis();
        }
        return PerformanceTimer.getNanoTime() / 1000000L;
    }

    public PerformanceTimer(boolean startTimer) {
        if (startTimer) {
            this.start();
        }
    }

    public void start() {
        if (timerMode != 2) {
            this.startNanoTicks = PerformanceTimer.getNanoTime();
        }
        this.startMilliTicks = PerformanceTimer.getCurrentTimeMillis();
    }

    public void stop() {
        if (timerMode != 2) {
            this.stopNanoTicks = PerformanceTimer.getNanoTime();
        }
        this.stopMilliTicks = PerformanceTimer.getCurrentTimeMillis();
    }

    public double getElapsedTime(boolean stopTimer) {
        if (stopTimer) {
            this.stop();
        }
        if (timerMode == 2) {
            return this.getElapsedCurrentTimeMillis();
        }
        return this.getElapsedNanoTime();
    }
}

