/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.DependentObject;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import java.util.HashMap;

public class DuplicateObjectCache {
    private HashMap bestChoice = null;
    private boolean isDisabled = false;

    public boolean putInCache(EngineObjectImpl eo, int level) {
        if (this.isDisabled) {
            return true;
        }
        if (!(eo instanceof DependentObject)) {
            ObjectReferenceBase oref = (ObjectReferenceBase)eo.getObjectReference();
            BestChoiceEntry dce = (BestChoiceEntry)this.bestChoice().get(oref);
            if (dce == null || dce.level > level) {
                this.bestChoice().put(oref, new BestChoiceEntry(eo, level));
                return true;
            }
        }
        return false;
    }

    public EngineObjectImpl getBestChoice(ObjectReferenceBase oa, int level) {
        if (this.isDisabled) {
            return null;
        }
        if (!(oa instanceof DependentIdentity)) {
            BestChoiceEntry dce = (BestChoiceEntry)this.bestChoice().get(oa);
            if (dce != null && dce.level <= level) {
                return dce.value;
            }
            return null;
        }
        return null;
    }

    public boolean setDisabled(boolean disabled) {
        boolean prevValue = this.isDisabled;
        this.isDisabled = disabled;
        return this.isDisabled;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    private HashMap bestChoice() {
        if (this.bestChoice == null) {
            this.bestChoice = new HashMap();
        }
        return this.bestChoice;
    }

    private static class BestChoiceEntry {
        int level;
        EngineObjectImpl value;

        BestChoiceEntry(EngineObjectImpl v, int l) {
            this.level = l;
            this.value = v;
        }
    }
}

