/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.smm.TimerMeasurement;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.ObjectRequest;
import com.filenet.apiimpl.transport.PutContentBatchRequest;
import com.filenet.apiimpl.transport.PutContentRequest;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.TraceDetail;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.XMLHelper;
import java.security.Principal;

public class TransportLogger
extends BaseLogger {
    private static final boolean logRequestWithError = ConfigValueLookup.getValueAsBoolean("com.filenet.engine.LogRequestWithError", false);
    public static final String GET_OBJECTS = "getObjects       ";
    public static final String GET_CONTENT = "getContent       ";
    public static final String EXECUTE_CHANGES = "executeChanges   ";
    public static final String EXECUTE_SEARCH = "executeSearch    ";
    public static final String GET_SEARCH_METADATA = "getSearchMetadata";
    public static final String PUT_CONTENT = "putContent       ";
    public static final String COMM_REQUEST = "commRequest      ";
    private static final String NEWLINE_ESCAPE = "\\n";
    private static final String ESCAPE_ESCAPE = "\\\\";

    private TransportLogger(String name, SubSystem sub) {
        super(name, sub);
    }

    public static TransportLogger getLogger(Class clazz, SubSystem sub) {
        return new TransportLogger(clazz.getName(), sub);
    }

    public boolean isCallTraceEnabled() {
        return this.isDetailTraceEnabled() || this.isModerateTraceEnabled() || this.isSummaryTraceEnabled();
    }

    public void traceRequest(ClientCallContext ccc, String operation, Message request) {
        try {
            if (this.isDetailTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, request, true);
                this.traceDetail(XMLHelper.trace(operation, detail, true));
            } else if (this.isModerateTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, request);
                this.traceModerate(XMLHelper.trace(operation, detail, false));
            } else if (this.isSummaryTraceEnabled()) {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append(operation);
                buffer.append(" request batch-size=").append(request.getBatchSize());
                buffer.append(this.getObjectReferences(request));
                this.traceSummary(buffer);
            }
        }
        catch (EngineRuntimeException ere) {
            this.logError(ere);
        }
        catch (Throwable t) {
            this.logError(new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null));
        }
    }

    private StringBuffer getObjectReferences(Message request) {
        StringBuffer resp = new StringBuffer();
        if (request instanceof ExecuteChangesRequest) {
            resp.append(" ObjectReferences [");
            ChangeRequest[] batch = ((ExecuteChangesRequest)request).getBatch();
            if (batch == null || batch.length < 1) {
                resp.append("]");
                return resp;
            }
            for (int lp = 0; lp < batch.length; ++lp) {
                ChangeRequest cr;
                if (lp > 0) {
                    resp.append(",");
                }
                resp.append((cr = batch[lp]).getObjectReference() != null ? cr.getObjectReference().toString() : "");
            }
            resp.append("]");
        } else if (request instanceof GetObjectRequest) {
            resp.append(" ObjectReferences [");
            ObjectRequest[] batch = ((GetObjectRequest)request).getBatch();
            if (batch == null || batch.length < 1) {
                resp.append("]");
                return resp;
            }
            for (int lp = 0; lp < batch.length; ++lp) {
                ObjectRequest cr;
                if (lp > 0) {
                    resp.append(",");
                }
                resp.append((cr = batch[lp]).getObjectReference() != null ? cr.getObjectReference().toString() : "");
            }
            resp.append("]");
        } else if (request instanceof GetContentRequest) {
            resp.append(" ObjectReferences [");
            ContentRequest[] batch = ((GetContentRequest)request).getBatch();
            if (batch == null || batch.length < 1) {
                resp.append("]");
                return resp;
            }
            for (int lp = 0; lp < batch.length; ++lp) {
                ContentRequest cr;
                if (lp > 0) {
                    resp.append(",");
                }
                resp.append((cr = batch[lp]).getObjectReference() != null ? cr.getObjectReference().toString() : "");
            }
            resp.append("]");
        } else if (request instanceof PutContentBatchRequest) {
            resp.append(" ObjectReferences [");
            PutContentRequest[] batch = ((PutContentBatchRequest)request).getBatch();
            if (batch == null || batch.length < 1) {
                resp.append("]");
                return resp;
            }
            for (int lp = 0; lp < batch.length; ++lp) {
                PutContentRequest cr;
                if (lp > 0) {
                    resp.append(",");
                }
                resp.append((cr = batch[lp]).getObjectReference() != null ? cr.getObjectReference().toString() : "");
            }
            resp.append("]");
        } else if (request instanceof SearchRequest) {
            SearchRequest sr = (SearchRequest)request;
            resp.append(" ");
            resp.append(sr.getSearchScope() != null ? sr.getSearchScope().toString() : "");
        } else if (request instanceof MetadataSearchRequest) {
            MetadataSearchRequest msr = (MetadataSearchRequest)request;
            resp.append(" ");
            resp.append(msr.getSearchScope() != null ? msr.getSearchScope().toString() : "");
        }
        return resp;
    }

    public void traceResponse(ClientCallContext ccc, String operation, Message response, long start) {
        if (start == 0L) {
            return;
        }
        try {
            if (this.isDetailTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, response, TransportLogger.elapsed(start));
                this.traceDetail(XMLHelper.trace(operation, detail, true));
            } else if (this.isModerateTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, response, TransportLogger.elapsed(start));
                this.traceModerate(XMLHelper.trace(operation, detail, false));
            } else if (this.isSummaryTraceEnabled()) {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append(operation);
                buffer.append(" response elapsed=").append(TransportLogger.elapsed(start));
                buffer.append(" batch-size=").append(response.getBatchSize());
                this.traceSummary(buffer);
            }
        }
        catch (EngineRuntimeException ere) {
            this.logError(ere);
        }
        catch (Throwable t) {
            this.logError(new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null));
        }
    }

    public void traceException(String operation, Throwable exception, long start) {
        this.traceException(null, operation, exception, start);
    }

    public void traceException(ClientCallContext ccc, String operation, Throwable exception, long start) {
        if (start == 0L) {
            return;
        }
        try {
            if (this.isDetailTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, exception, TransportLogger.elapsed(start));
                this.traceDetail(XMLHelper.trace(operation, detail));
            } else if (this.isModerateTraceEnabled()) {
                TraceDetail detail = new TraceDetail(ccc, exception, TransportLogger.elapsed(start));
                this.traceModerate(XMLHelper.trace(operation, detail));
            } else if (this.isSummaryTraceEnabled()) {
                StringBuffer buffer = new StringBuffer(256);
                buffer.append(operation);
                buffer.append(" elapsed=").append(TransportLogger.elapsed(start));
                buffer.append(" exception: ").append(exception.getClass().getName());
                String message = exception.getMessage();
                if (message != null && (message = message.trim()).length() > 0) {
                    buffer.append(": ").append(message);
                }
                this.traceSummary(buffer);
            }
        }
        catch (EngineRuntimeException ere) {
            this.logError(ere);
        }
        catch (Throwable t) {
            this.logError(new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null));
        }
    }

    private static long elapsed(long start) {
        return TimerMeasurement.getMillis() - start;
    }

    public void logErrorWithRequest(ClientCallContext ccc, String operation, Message request, EngineRuntimeException erte) {
        try {
            Boolean isInUserInitTran;
            String principalName = "";
            Principal prin = J2EEUtil.getInstance().getCurrentPrincipal();
            if (prin != null) {
                principalName = prin.getName();
            }
            Boolean isInGlobalTran = ccc != null ? Boolean.valueOf((Boolean)ccc.getParam("iigt")) : null;
            Boolean bl = isInUserInitTran = ccc != null ? Boolean.valueOf((Boolean)ccc.getParam("iiuit")) : null;
            if (logRequestWithError) {
                TraceDetail detail = new TraceDetail(ccc, request);
                String requestString = XMLHelper.trace(operation, detail, false);
                StringBuffer requestBuf = new StringBuffer(requestString.length() + 100);
                this.escapeNewlines(requestString, requestBuf);
                this.logErrorExtended(erte, principalName, isInGlobalTran, isInUserInitTran, requestBuf.toString());
            } else {
                this.logError(erte, principalName, isInGlobalTran, isInUserInitTran);
            }
        }
        catch (EngineRuntimeException ere) {
            this.logError(ere);
        }
        catch (Throwable t) {
            this.logError(new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null));
        }
    }

    private void escapeNewlines(String msg, StringBuffer sbuf) {
        int current = 0;
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (c == '\n' || c == '\f') {
                sbuf.append(msg.substring(current, i));
                sbuf.append(NEWLINE_ESCAPE);
                current = i + 1;
                continue;
            }
            if (c == '\r') {
                sbuf.append(msg.substring(current, i));
                sbuf.append(NEWLINE_ESCAPE);
                if (i + 1 < len && msg.charAt(i + 1) == '\n') {
                    ++i;
                }
                current = i + 1;
                continue;
            }
            if (c != '\\') continue;
            sbuf.append(msg.substring(current, i));
            sbuf.append(ESCAPE_ESCAPE);
            current = i + 1;
        }
        if (current < len) {
            sbuf.append(msg.substring(current));
        }
    }
}

