/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AliasMap {
    private final Map values = new HashMap();
    private final Map aliases = new HashMap();
    private int max = Integer.MAX_VALUE;

    public void setMaxAliases(int count) {
        this.max = count;
    }

    public int getMaxAliases() {
        return this.max;
    }

    public Object get(Object alias) {
        return this.values.get(alias);
    }

    public boolean add(Object value, Object alias) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (this.max <= 0) {
            return false;
        }
        ArrayList<Object> list = (ArrayList<Object>)this.aliases.get(value);
        if (list != null && list.size() >= this.max) {
            return false;
        }
        Object prior = this.values.put(alias, value);
        if (prior != null) {
            this.values.put(alias, prior);
            return false;
        }
        if (list == null) {
            list = new ArrayList<Object>();
            this.aliases.put(value, list);
        }
        list.add(alias);
        return true;
    }

    public Object remove(Object alias) {
        Object value = this.values.remove(alias);
        if (value == null) {
            return null;
        }
        List list = (List)this.aliases.get(value);
        if (list != null && list.remove(alias) && list.size() == 0) {
            this.aliases.remove(value);
        }
        return value;
    }

    public boolean removeValue(Object value) {
        List list = (List)this.aliases.remove(value);
        if (list == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.values.remove(list.get(i));
        }
        return true;
    }

    public boolean containsValue(Object value) {
        return this.aliases.containsKey(value);
    }

    public Object[] getAliases(Object value) {
        List list = (List)this.aliases.get(value);
        return list == null ? null : list.toArray();
    }

    public int size() {
        return this.aliases.size();
    }

    public void clear() {
        this.values.clear();
        this.aliases.clear();
    }

    public String toString() {
        return "{values=" + this.values + ", aliases=" + this.aliases + ", max=" + this.max + "}";
    }
}

