/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.PendingAction;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.DependentObject;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.query.SearchContext;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.Streamable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class BinaryOutputStream
extends DelegateOutputStream {
    int level = 0;

    public static BinaryOutputStream getInstance(short version, OutputStream v) throws IOException {
        if (version <= 20) {
            return new BinaryOutputStream(version, v);
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNSUPPORTED_STREAM, new Object[]{new Integer(version), BinaryInputStream.class.getName()});
    }

    public static BinaryOutputStream getInstance(short version, ObjectOutputStream v) throws IOException {
        if (version <= 20) {
            return new BinaryOutputStream(version, v);
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNSUPPORTED_STREAM, new Object[]{new Integer(version), BinaryInputStream.class.getName()});
    }

    protected BinaryOutputStream(short versionVal, OutputStream v) throws IOException {
        super(versionVal, v);
    }

    protected BinaryOutputStream(short versionVal, ObjectOutputStream v) throws IOException {
        super(versionVal, v);
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.delegated.writeObject(obj);
    }

    @Override
    public void putObject(Object obj) throws IOException {
        if (obj instanceof Streamable) {
            Streamable so = (Streamable)obj;
            this.writeShort(so.getStreamType());
            so.putStreamValue(this);
        } else if (obj instanceof PropertyImpl) {
            this.writeShort(4);
            this.putProperty((PropertyImpl)obj);
        } else if (obj instanceof ObjectReferenceBase) {
            this.writeShort(9);
            this.putObjectReference((ObjectReferenceBase)obj);
        } else if (obj instanceof PropertiesImpl) {
            this.writeShort(3);
            this.putProperties((PropertiesImpl)obj);
        } else if (obj instanceof EngineObjectImpl) {
            this.writeShort(2);
            this.putEngineObject((EngineObjectImpl)obj);
        } else if (obj instanceof ListImpl) {
            this.writeShort(6);
            this.putListCollection((ListImpl)obj);
        } else if (obj instanceof EngineRuntimeException) {
            this.writeShort(8);
            this.putException((EngineRuntimeException)obj);
        } else if (obj instanceof PropertyFilter) {
            this.writeShort(11);
            this.putPropertyFilter((PropertyFilter)obj);
        } else if (obj instanceof PendingAction[]) {
            this.writeShort(10);
            this.putPendingActions((PendingAction[])obj);
        } else if (obj instanceof ClientInputStream) {
            this.writeShort(12);
            this.putClientInputStream((ClientInputStream)obj);
        } else if (obj instanceof ChangeRequest) {
            this.writeShort(13);
            this.putChangeRequest((ChangeRequest)obj);
        } else {
            this.writeShort(1);
            this.writeObject(obj);
        }
    }

    @Override
    public void putChangeRequest(ChangeRequest cr) throws IOException {
        this.putPendingActions(cr.getPendingActions());
        this.putObjectReference(cr.getObjectReference());
        this.putPropertyFilter(cr.getPropertyFilter());
        this.putProperties(cr.getProperties());
        this.writeObject(cr.getCorrelationId());
        this.writeObject(cr.getUpdateSequenceNumber());
    }

    @Override
    public void putClientInputStream(ClientInputStream cis) throws IOException {
        this.writeBoolean(cis == null);
        if (cis != null) {
            cis.serializeValue(this);
        }
    }

    @Override
    public void putPropertyFilter(PropertyFilter pf) throws IOException {
        this.writeObject(pf);
    }

    public void putFilterElement(FilterElement fe) throws IOException {
        this.writeObject(fe);
    }

    @Override
    public void putPendingActions(PendingAction[] actions) throws IOException {
        if (actions == null) {
            this.writeShort(0);
        } else {
            int size = actions.length;
            this.writeShort(size);
            for (int lp = 0; lp < size; lp = (int)((short)(lp + 1))) {
                this.writeObject(actions[lp]);
            }
        }
    }

    @Override
    public void putException(EngineRuntimeException ert) throws IOException {
        this.writeObject(ert);
    }

    @Override
    public void putObjectReference(ObjectReferenceBase reference) throws IOException {
        if (reference == null) {
            this.writeByte(0);
        } else {
            this.writeByte(reference.getClassType());
            reference.serializeValue(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putProperty(PropertyImpl pi) throws IOException {
        if (pi == null) {
            this.writeInt(-1);
            return;
        }
        int mask = pi.getSerializeMask();
        this.writeInt(mask);
        this.writeObject(pi.getPropertyName());
        if ((mask >> 16 & 0x10) == 0) {
            boolean origDupCache = this.dupObjectCache.isDisabled();
            if (this.version >= 5 && (pi.getPropertyName().equals("SourceObject") || pi.getPropertyName().equals("OriginalObject"))) {
                this.dupObjectCache.setDisabled(true);
            }
            try {
                pi.serializeValue(this);
            }
            finally {
                this.dupObjectCache.setDisabled(origDupCache);
            }
        }
    }

    @Override
    public void putProperties(PropertiesImpl props) throws IOException {
        if (props != null) {
            this.writeShort(props.size());
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                this.putProperty((PropertyImpl)iter.next());
            }
        } else {
            this.writeShort(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEngineObject(EngineObjectImpl eo) throws IOException {
        int savedLevel = this.level++;
        try {
            this.writeBoolean(eo == null);
            if (eo == null) {
                return;
            }
            ObjectReferenceBase oa = (ObjectReferenceBase)eo.getObjectReference();
            if (oa == null) {
                throw new NullPointerException("eo.getObjectReference() == null");
            }
            if (eo instanceof DependentObject || this.dupObjectCache.putInCache(eo, this.level)) {
                this.writeEngineObject(eo);
            } else {
                this.putObjectReference(oa);
            }
        }
        finally {
            this.level = savedLevel;
        }
    }

    private void writeEngineObject(EngineObjectImpl eo) throws IOException {
        ObjectReferenceBase oa = (ObjectReferenceBase)eo.getObjectReference();
        String[] superClasses = eo.getSuperClasses();
        Integer accessAllowed = eo.getInternalAccessAllowed();
        PropertiesImpl propertyCache = eo.getPropertiesImpl();
        PendingAction[] pendingActions = eo.getPendingActions();
        Integer updateSequenceNumber = eo.getUpdateSequenceNumber();
        this.putObjectReference(oa);
        short superClassesSize = (short)(superClasses != null ? superClasses.length : 0);
        this.writeShort(superClassesSize);
        for (short lp = 0; lp < superClassesSize; lp = (short)(lp + 1)) {
            this.writeObject(superClasses[lp]);
        }
        this.writeObject(accessAllowed);
        this.writeObject(updateSequenceNumber);
        this.putPendingActions(pendingActions);
        this.putProperties(propertyCache);
    }

    @Override
    public void putDependentObject(EngineObjectImpl eo) throws IOException {
        this.writeBoolean(eo == null);
        if (eo == null) {
            return;
        }
        String[] superClasses = eo.getSuperClasses();
        Integer accessAllowed = eo.getInternalAccessAllowed();
        PropertiesImpl propertyCache = eo.getPropertiesImpl();
        int superClassesSize = superClasses != null ? superClasses.length : 0;
        this.writeInt(superClassesSize);
        for (int lp = 0; lp < superClassesSize; ++lp) {
            this.writeObject(superClasses[lp]);
        }
        this.writeObject(accessAllowed);
        this.putProperties(propertyCache);
    }

    @Override
    public void putRepositoryRowCollection(RepositoryRowCollectionImpl rrc) throws IOException {
        this.writeBoolean(rrc == null);
        if (rrc == null) {
            return;
        }
        rrc.serializeValue(this);
    }

    @Override
    public void putSetCollection(SetImpl ssi) throws IOException {
        this.writeBoolean(ssi == null);
        if (ssi == null) {
            return;
        }
        ssi.serializeValue(this);
    }

    @Override
    public void putListCollection(ListImpl sli) throws IOException {
        this.writeBoolean(sli == null);
        if (sli == null) {
            return;
        }
        int size = sli != null ? sli.size() : 0;
        Class ic = sli != null ? sli.getContainedType() : null;
        String icClassName = ic != null ? ic.getName() : null;
        this.writeInt(size);
        this.writeObject(icClassName);
        this.writeBoolean(sli.hasBeenAttached());
        if (size < 1) {
            return;
        }
        Iterator iter = sli.iterator();
        boolean holdsEO = EngineObject.class.isAssignableFrom(ic);
        DependentIdentity di = null;
        if (holdsEO && size > 0) {
            di = (DependentIdentity)((EngineObjectImpl)sli.get(0)).getObjectReference();
            this.putObjectReference((ObjectReferenceBase)di.getParentReference());
            this.writeObject(di.getPropertyName());
        }
        while (iter.hasNext()) {
            Object v = iter.next();
            if (holdsEO) {
                EngineObjectImpl eo = (EngineObjectImpl)v;
                this.writeObject(eo.getClassName());
                this.putDependentObject(eo);
                continue;
            }
            this.writeObject(v);
        }
    }

    @Override
    public void putSearchContext(SearchContext context) throws IOException {
        this.writeBoolean(context == null);
        if (context == null) {
            return;
        }
        context.serializeValue(this);
    }

    @Override
    public void putPagingContext(DefaultPaging paging) throws IOException {
        if (paging == null) {
            this.writeByte(0);
        } else {
            this.writeByte(paging.getClassType());
            paging.serializeValue(this);
        }
    }

    @Override
    public void putSearch(Search search) throws IOException {
        this.writeObject(search);
    }

    @Override
    public void putMergeMode(MergeMode mode) throws IOException {
        this.writeByte(mode == null ? -1 : mode.getValue());
    }

    @Override
    public void putId(Id id) throws IOException {
        this.writeObject(id == null ? null : id.getBytes());
    }
}

