/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BufferedBlock;
import java.io.IOException;
import java.io.InputStream;

public abstract class BlockBasedInputStream
extends InputStream {
    private int currentBlockOffset = 0;
    private BufferedBlock currentBlock = null;
    private byte[] oneByte = new byte[1];

    protected BlockBasedInputStream(BufferedBlock firstBlock) {
        this.currentBlock = firstBlock;
    }

    protected BlockBasedInputStream() {
        this.currentBlock = BufferedBlock.INITIAL_EMPTY_BLOCK;
    }

    protected abstract BufferedBlock fetchNextBlock() throws IOException;

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.oneByte, 0, 1);
        if (bytesRead == 1) {
            return this.oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int bytesRead = -1;
        while (length > 0) {
            int copy;
            if (this.currentBlockOffset == this.currentBlock.getSize()) {
                if (!this.currentBlock.lastBlock()) {
                    this.currentBlock = this.fetchNextBlock();
                    this.currentBlockOffset = 0;
                } else {
                    return bytesRead;
                }
            }
            if ((copy = this.currentBlock.getSize() - this.currentBlockOffset) <= 0) continue;
            if (copy > length) {
                copy = length;
            }
            System.arraycopy(this.currentBlock.getBytes(), this.currentBlockOffset, buffer, offset, copy);
            this.currentBlockOffset += copy;
            offset += copy;
            length -= copy;
            if (bytesRead == -1) {
                bytesRead = copy;
                continue;
            }
            bytesRead += copy;
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.currentBlock.getSize() - this.currentBlockOffset;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentBlock = null;
    }

    @Override
    public long skip(long skipCount) throws IOException {
        long skipped = 0L;
        while (skipCount > 0L) {
            int maxSkipInCurrentBlock = this.currentBlock.getSize() - this.currentBlockOffset;
            if ((long)maxSkipInCurrentBlock >= skipCount) {
                this.currentBlockOffset += (int)skipCount;
                return skipped += skipCount;
            }
            skipped += (long)maxSkipInCurrentBlock;
            skipCount -= (long)maxSkipInCurrentBlock;
            this.currentBlockOffset = this.currentBlock.getSize();
            if (this.currentBlock.lastBlock()) {
                return skipped;
            }
            this.currentBlock = this.fetchNextBlock();
            this.currentBlockOffset = 0;
        }
        return skipped;
    }
}

