/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ExtendedInputStream;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.BlockBasedInputStream;
import com.filenet.apiimpl.util.BufferedBlock;
import com.filenet.apiimpl.util.FilterExtendedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;

public class BlockedCompression {
    public static final int MIN_COMPRESSABLE_SIZE = 1024;
    private static byte[] fileHeader = new byte[]{70, 78, 66, 67, 1, 0, 0, 0};
    private static int FILE_HEADER_SIZE = fileHeader.length;
    private static int BLOCK_HEADER_SIZE = 10;
    private static byte[] blockHeaderPrefix = new byte[]{77, 83};

    public static Writer conditionalGetWriter(byte[] firstChunk, int chunkLength, OutputStream out, int thresholdPercent, int maxBlockSize, Cipher encryptor) throws IOException {
        BlockProducer producer;
        if (chunkLength < 1024) {
            return null;
        }
        int nextBlockLen = maxBlockSize;
        if (nextBlockLen > chunkLength) {
            nextBlockLen = chunkLength;
        }
        if ((producer = BlockedCompression.getBlockProducer(firstChunk, nextBlockLen, thresholdPercent, maxBlockSize, encryptor)) != null) {
            Writer writer = new Writer(out, maxBlockSize, producer);
            writer.continueWritingChunk(firstChunk, nextBlockLen, chunkLength);
            return writer;
        }
        return null;
    }

    public static InputStream conditionalGetCompressingStream(InputStream in, int thresholdPercent, int maxBlockSize, Cipher encryptor) throws IOException {
        BlockProducer producer;
        byte[] inputBuffer = new byte[maxBlockSize];
        int bytesRead = BlockedCompression.readMaximum(in, inputBuffer, maxBlockSize);
        if (bytesRead == -1) {
            return in;
        }
        if (bytesRead >= 1024 && (producer = BlockedCompression.getBlockProducer(inputBuffer, bytesRead, thresholdPercent, maxBlockSize, encryptor)) != null) {
            return new Compresser(in, maxBlockSize, inputBuffer, producer);
        }
        return new SequenceInputStream(new ByteArrayInputStream(inputBuffer, 0, bytesRead), in);
    }

    private static BlockProducer getBlockProducer(byte[] firstChunk, int chunkLen, int thresholdPercent, int maxBlockSize, Cipher encryptor) {
        Deflater deflater = new Deflater();
        byte[] compressed = new byte[maxBlockSize + FILE_HEADER_SIZE + BLOCK_HEADER_SIZE];
        long startTime = System.nanoTime();
        int compressedSize = BlockedCompression.compressBlock(deflater, firstChunk, 0, chunkLen, compressed, FILE_HEADER_SIZE + BLOCK_HEADER_SIZE);
        long compressionTime = System.nanoTime() - startTime;
        int compressedPercent = compressedSize * 100 / chunkLen;
        if (compressedPercent < thresholdPercent) {
            BlockProducer producer = new BlockProducer(deflater, compressed, encryptor);
            producer.prepareFirstBlock(chunkLen, compressedSize, compressionTime);
            return producer;
        }
        return null;
    }

    public static Writer getContinuationWriter(OutputStream out, int maxBlockSize, Cipher encryptor) {
        return new Writer(out, maxBlockSize, new Deflater(), new byte[maxBlockSize + BLOCK_HEADER_SIZE], encryptor);
    }

    public static InputStream getDecompressedStream(InputStream in, Cipher decryptor, long uncompressedSize) {
        return new Reader(in, decryptor, uncompressedSize).wrapIfNeeded();
    }

    private static int compressBlock(Deflater deflater, byte[] input, int offset, int length, byte[] output, int outOffset) {
        int compressedSize = length;
        if (length >= 1024) {
            deflater.setInput(input, offset, length);
            deflater.finish();
            compressedSize = deflater.deflate(output, outOffset, output.length - outOffset);
            deflater.reset();
        }
        if (compressedSize >= length) {
            System.arraycopy(input, offset, output, outOffset, length);
            compressedSize = length;
        }
        return compressedSize;
    }

    private static void integerToHeader(byte[] output, int value, int offset) {
        offset += 3;
        for (int I = 0; I < 4; ++I) {
            output[offset] = (byte)value;
            --offset;
            value >>>= 8;
        }
    }

    private static int readMaximum(InputStream in, byte[] buffer, int expected) throws IOException {
        int bytesRead;
        int readThisTime;
        for (bytesRead = 0; bytesRead < expected; bytesRead += readThisTime) {
            readThisTime = in.read(buffer, bytesRead, expected - bytesRead);
            if (readThisTime != -1) continue;
            if (bytesRead == 0) {
                return -1;
            }
            return bytesRead;
        }
        return bytesRead;
    }

    private static String toHex(byte[] binary, int len) {
        String res = "0x";
        for (int i = 0; i < len; ++i) {
            if ((binary[i] & 0xF0) == 0) {
                res = res + "0";
            }
            res = res + Integer.toHexString(binary[i] & 0xFF);
        }
        return res;
    }

    private static void printBytes(byte[] hash, String preamble) {
        String res = "";
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xF0) == 0) {
                res = res + "0";
            }
            res = res + Integer.toHexString(hash[i] & 0xFF);
            if (i % 4 != 3) continue;
            res = res + " ";
        }
    }

    private static class Reader
    extends FilterExtendedInputStream {
        private int currentBlockIndex = -1;
        private Inflater inflater = new Inflater();
        private Cipher decryptor;
        int currentBlockLength = 0;
        int currentBlockOffset = 0;
        byte[] uncompressed;
        byte[] compressed;
        byte[] header = new byte[BlockedCompression.access$1500()];
        private boolean initialized = false;
        private ArrayList<BlockInfo> blocks = null;

        private Reader(InputStream in, Cipher decryptor, long uncompressedSize) {
            super(in, 0L);
            this.totalSize = uncompressedSize;
            this.decryptor = decryptor;
            this.isExtended = in instanceof ExtendedInputStream;
            if (this.isExtended) {
                this.blocks = new ArrayList();
            }
        }

        @Override
        public int read() throws IOException {
            this.checkInitialized();
            if (this.currentBlockOffset == this.currentBlockLength) {
                this.fetchNextBlock();
            }
            if (this.currentBlockLength == -1) {
                return -1;
            }
            ++this.logicalPosition;
            return this.uncompressed[this.currentBlockOffset++] & 0xFF;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            this.checkInitialized();
            if (length == 0) {
                return 0;
            }
            int bytesRead = -1;
            while (length > 0) {
                if (this.currentBlockOffset == this.currentBlockLength) {
                    this.fetchNextBlock();
                }
                if (this.currentBlockLength == -1) {
                    return bytesRead;
                }
                int copy = this.currentBlockLength - this.currentBlockOffset;
                if (copy > length) {
                    copy = length;
                }
                System.arraycopy(this.uncompressed, this.currentBlockOffset, buffer, offset, copy);
                this.currentBlockOffset += copy;
                offset += copy;
                length -= copy;
                this.logicalPosition += (long)copy;
                if (bytesRead == -1) {
                    bytesRead = copy;
                    continue;
                }
                bytesRead += copy;
            }
            return bytesRead;
        }

        @Override
        public int available() throws IOException {
            this.checkInitialized();
            if (this.currentBlockLength == -1 || this.currentBlockOffset == this.currentBlockLength) {
                return 0;
            }
            return this.currentBlockLength - this.currentBlockOffset;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.inflater = null;
            this.decryptor = null;
            this.uncompressed = null;
            this.compressed = null;
            this.header = null;
        }

        @Override
        public long skip(long skipCount) throws IOException {
            this.checkInitialized();
            if (this.currentBlockLength == -1) {
                return 0L;
            }
            int maxSkipInCurrentBlock = this.currentBlockLength - this.currentBlockOffset;
            if ((long)maxSkipInCurrentBlock >= skipCount) {
                this.currentBlockOffset += (int)skipCount;
                this.logicalPosition += skipCount;
                return skipCount;
            }
            long skipped = maxSkipInCurrentBlock;
            this.logicalPosition += skipped;
            skipCount -= (long)maxSkipInCurrentBlock;
            while (skipCount > 0L) {
                int compressedSize = this.readHeader();
                if (compressedSize == -1) {
                    return skipped;
                }
                if (skipCount <= (long)this.currentBlockLength) {
                    this.readAndDecompress(compressedSize);
                    this.currentBlockOffset = (int)skipCount;
                    this.logicalPosition += skipCount;
                    return skipped + skipCount;
                }
                long compressedSkip = this.skipInner(compressedSize);
                if (compressedSkip != (long)compressedSize) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_CA_SKIP_FAILED, new Object[]{(long)compressedSize, compressedSkip});
                }
                skipped += (long)this.currentBlockLength;
                skipCount -= (long)this.currentBlockLength;
                this.logicalPosition += (long)this.currentBlockLength;
            }
            return skipped;
        }

        @Override
        public void position(long newPosition) throws IOException {
            if (!this.isExtended) {
                throw new UnsupportedOperationException("Not an ExtendedInputStream");
            }
            if (newPosition == this.logicalPosition) {
                return;
            }
            for (int blockIndex = 0; blockIndex < this.blocks.size(); ++blockIndex) {
                BlockInfo bi = this.blocks.get(blockIndex);
                if (bi.logicalPosition > newPosition || bi.logicalPosition + (long)bi.uncompressedSize <= newPosition) continue;
                this.positionInner(bi.physicalPosition);
                this.currentBlockIndex = blockIndex - 1;
                this.fetchNextBlock();
                this.logicalPosition = bi.logicalPosition;
                if (this.logicalPosition < newPosition) {
                    this.skip(newPosition - this.logicalPosition);
                }
                return;
            }
            this.skip(newPosition - this.logicalPosition);
        }

        private void fetchNextBlock() throws IOException {
            this.currentBlockOffset = 0;
            int compressedSize = this.readHeader();
            if (compressedSize == -1) {
                return;
            }
            this.readAndDecompress(compressedSize);
        }

        private int readHeader() throws IOException {
            long startPhysicalPosition = this.physicalPosition;
            int bytesRead = this.readExpected(this.header, this.header.length, true);
            if (bytesRead == -1) {
                this.currentBlockLength = -1;
                return -1;
            }
            for (int I = 0; I < blockHeaderPrefix.length; ++I) {
                if (this.header[I] == blockHeaderPrefix[I]) continue;
                throw new EngineRuntimeException(ExceptionCode.CONTENT_COMPRESSION_BLOCK_HEADER_ERROR, new Object[]{I, (int)blockHeaderPrefix[I], this.header[I] & 0xFF});
            }
            this.currentBlockLength = this.integerFromHeader(2);
            int compressedSize = this.integerFromHeader(6);
            ++this.currentBlockIndex;
            if (this.isExtended && this.currentBlockIndex >= this.blocks.size()) {
                BlockInfo bi = new BlockInfo(startPhysicalPosition, this.logicalPosition, compressedSize, this.currentBlockLength);
                this.blocks.add(bi);
            }
            return compressedSize;
        }

        private void readAndDecompress(int compressedSize) throws IOException {
            if (this.compressed == null || this.compressed.length < compressedSize) {
                this.compressed = new byte[compressedSize];
            }
            this.readExpected(this.compressed, compressedSize, false);
            if (this.uncompressed == null || this.uncompressed.length < this.currentBlockLength) {
                this.uncompressed = new byte[this.currentBlockLength];
            }
            if (this.decryptor != null) {
                try {
                    this.decryptor.doFinal(this.compressed, 0, compressedSize, this.compressed);
                }
                catch (Throwable t) {
                    throw new EngineRuntimeException(t, ExceptionCode.CONTENT_CA_READ_FAILED, new Object[]{"Blocked-Compression"}, ExceptionContext.CONTENT_DECRYPTION_ERROR, null);
                }
            }
            if (compressedSize < this.currentBlockLength) {
                int decompressedSize = 0;
                try {
                    this.inflater.setInput(this.compressed, 0, compressedSize);
                    decompressedSize = this.inflater.inflate(this.uncompressed);
                }
                catch (Throwable t) {
                    throw new EngineRuntimeException(t, ExceptionCode.CONTENT_COMPRESSION_DECOMPRESSION_ERROR, null);
                }
                if (decompressedSize != this.currentBlockLength) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_COMPRESSION_DECOMPRESSED_SIZE_MISMATCH, new Object[]{this.currentBlockLength, decompressedSize});
                }
                this.inflater.reset();
            } else {
                System.arraycopy(this.compressed, 0, this.uncompressed, 0, this.currentBlockLength);
            }
        }

        private int readExpected(byte[] buffer, int expected, boolean allowEOF) throws IOException {
            int bytesRead = this.readFully(buffer, 0, expected);
            if (bytesRead < expected && !allowEOF) {
                throw new EngineRuntimeException(ExceptionCode.CONTENT_COMPRESSION_SHORT_READ, new Object[]{expected, bytesRead});
            }
            return bytesRead;
        }

        private int integerFromHeader(int offset) {
            int value = 0;
            for (int I = 0; I < 4; ++I) {
                value = (value << 8) + (this.header[offset + I] & 0xFF);
            }
            return value;
        }

        private synchronized void checkInitialized() throws IOException {
            if (!this.initialized) {
                byte[] fileHeaderIn = new byte[fileHeader.length];
                int bytesRead = this.in.read(fileHeaderIn);
                if (bytesRead != fileHeader.length || !Arrays.equals(fileHeaderIn, fileHeader)) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_COMPRESSION_BAD_HEADER, new Object[]{BlockedCompression.toHex(fileHeader, fileHeader.length), BlockedCompression.toHex(fileHeaderIn, bytesRead)});
                }
                this.initialized = true;
                this.physicalPosition = bytesRead;
            }
        }

        private static class BlockInfo {
            long physicalPosition;
            long logicalPosition;
            int compressedSize;
            int uncompressedSize;

            BlockInfo(long pP, long lP, int cS, int uS) {
                this.physicalPosition = pP;
                this.logicalPosition = lP;
                this.compressedSize = cS;
                this.uncompressedSize = uS;
            }

            public String toString() {
                return "Physical position=" + this.physicalPosition + ";logical position=" + this.logicalPosition + ";compressed size=" + this.compressedSize + ";uncompressed size=" + this.uncompressedSize;
            }
        }
    }

    public static class Compresser
    extends BlockBasedInputStream {
        private InputStream in;
        private int maxBlockSize;
        private byte[] inputBuffer;
        private BlockProducer producer;

        private Compresser(InputStream in, int maxBlockSize, byte[] inputBuffer, BlockProducer producer) {
            super(new BufferedBlock(producer.currentBlock(), producer.currentBlockSize(), false));
            this.in = in;
            this.maxBlockSize = maxBlockSize;
            this.inputBuffer = inputBuffer;
            this.producer = producer;
        }

        public long getCompressedSize() {
            return this.producer.getCompressedSize();
        }

        public long getCompressionTime() {
            return this.producer.getCompressionTime();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        protected BufferedBlock fetchNextBlock() throws IOException {
            int bytesRead = this.in.read(this.inputBuffer, 0, this.maxBlockSize);
            if (bytesRead == -1) {
                return BufferedBlock.FINAL_EMPTY_BLOCK;
            }
            this.producer.prepareNextBlock(this.inputBuffer, 0, bytesRead);
            return new BufferedBlock(this.producer.currentBlock(), this.producer.currentBlockSize(), false);
        }
    }

    private static class BlockProducer {
        private Deflater deflater;
        private Cipher encryptor;
        private byte[] compressionOutput;
        private long sizeOnDisk = 0L;
        private long compressionTime = 0L;
        private int currentBlockSize = 0;

        private BlockProducer(Deflater deflater, byte[] compressionOutput, Cipher encryptor) {
            this.deflater = deflater;
            this.compressionOutput = compressionOutput;
            this.encryptor = encryptor;
        }

        private byte[] currentBlock() {
            return this.compressionOutput;
        }

        private int currentBlockSize() {
            return this.currentBlockSize;
        }

        private long getCompressedSize() {
            return this.sizeOnDisk;
        }

        private long getCompressionTime() {
            return this.compressionTime;
        }

        private void prepareFirstBlock(int uncompressedSize, int compressedSize, long compressionTime) {
            System.arraycopy(fileHeader, 0, this.compressionOutput, 0, FILE_HEADER_SIZE);
            this.finishBlock(FILE_HEADER_SIZE, uncompressedSize, compressedSize);
            this.compressionTime = compressionTime;
        }

        private void prepareNextBlock(byte[] uncompressed, int offset, int uncompressedSize) {
            long startTime = System.nanoTime();
            int compressedSize = BlockedCompression.compressBlock(this.deflater, uncompressed, offset, uncompressedSize, this.compressionOutput, BLOCK_HEADER_SIZE);
            this.compressionTime += System.nanoTime() - startTime;
            this.finishBlock(0, uncompressedSize, compressedSize);
        }

        private void finishBlock(int baseOffset, int uncompressedSize, int compressedSize) {
            System.arraycopy(blockHeaderPrefix, 0, this.compressionOutput, baseOffset, 2);
            BlockedCompression.integerToHeader(this.compressionOutput, uncompressedSize, baseOffset + 2);
            BlockedCompression.integerToHeader(this.compressionOutput, compressedSize, baseOffset + 6);
            if (this.encryptor != null) {
                try {
                    this.encryptor.doFinal(this.compressionOutput, baseOffset + BLOCK_HEADER_SIZE, compressedSize, this.compressionOutput, baseOffset + BLOCK_HEADER_SIZE);
                }
                catch (Throwable t) {
                    throw new EngineRuntimeException(t, ExceptionCode.CONTENT_ENCRYPTION_ERROR, new Object[]{"Blocked-Compression"});
                }
            }
            this.currentBlockSize = baseOffset + BLOCK_HEADER_SIZE + compressedSize;
            this.sizeOnDisk += (long)this.currentBlockSize;
        }

        private void close() {
            this.deflater.end();
        }
    }

    public static class Writer {
        private OutputStream out;
        private int maxBlockSize;
        private BlockProducer producer;

        public void writeChunk(byte[] chunk, int chunkLength) throws IOException {
            this.continueWritingChunk(chunk, 0, chunkLength);
        }

        public long getCompressedSize() {
            return this.producer.getCompressedSize();
        }

        public long getCompressionTime() {
            return this.producer.getCompressionTime();
        }

        public void close() throws IOException {
            this.out.close();
            this.producer.close();
        }

        private Writer(OutputStream out, int maxBlockSize, BlockProducer producer) throws IOException {
            this.out = out;
            this.maxBlockSize = maxBlockSize;
            this.producer = producer;
            out.write(producer.currentBlock(), 0, producer.currentBlockSize());
        }

        private Writer(OutputStream out, int maxBlockSize, Deflater deflater, byte[] compressionOutput, Cipher encryptor) {
            this.out = out;
            this.maxBlockSize = maxBlockSize;
            this.producer = new BlockProducer(deflater, compressionOutput, encryptor);
        }

        private void continueWritingChunk(byte[] chunk, int offset, int length) throws IOException {
            while (offset < length) {
                int nextBlockLen = this.maxBlockSize;
                if (nextBlockLen > length - offset) {
                    nextBlockLen = length - offset;
                }
                this.producer.prepareNextBlock(chunk, offset, nextBlockLen);
                this.out.write(this.producer.currentBlock(), 0, this.producer.currentBlockSize());
                offset += nextBlockLen;
            }
        }
    }
}

