/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.PendingAction;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectByName;
import com.filenet.apiimpl.core.ObjectByPath;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.meta.SearchScopeIdentity;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyFloat64Impl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.PropertyInteger32Impl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.property.PropertySetPaging;
import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.property.PropertyUpdateList;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.query.SearchContext;
import com.filenet.apiimpl.query.SearchObjectPaging;
import com.filenet.apiimpl.query.SearchRowPaging;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;

public abstract class DelegateInputStream
extends ObjectInputStream {
    protected short version;
    protected ObjectInputStream delegated;
    protected DuplicateObjectCache dupObjectCache = new DuplicateObjectCache();

    public DelegateInputStream(short versionVal, InputStream is) throws IOException {
        this.version = versionVal;
        this.delegated = new ObjectInputStream(is);
    }

    public DelegateInputStream(short versionVal, ObjectInputStream ois) throws IOException {
        this.version = versionVal;
        this.delegated = ois;
    }

    public short getVersion() {
        return this.version;
    }

    public abstract Object getObject() throws IOException, ClassNotFoundException;

    public abstract PropertyImpl getProperty() throws IOException, ClassNotFoundException;

    public abstract PropertiesImpl getProperties() throws IOException, ClassNotFoundException;

    public abstract EngineObjectImpl getEngineObject() throws IOException, ClassNotFoundException;

    public abstract EngineObjectImpl getDependentObject(DependentIdentity var1) throws IOException, ClassNotFoundException;

    public abstract RepositoryRowCollectionImpl getRepositoryRowCollection() throws IOException, ClassNotFoundException;

    public abstract SetImpl getSetCollection() throws IOException, ClassNotFoundException;

    public abstract ListImpl getListCollection() throws IOException, ClassNotFoundException;

    public abstract EngineRuntimeException getException() throws IOException, ClassNotFoundException;

    public abstract ObjectReferenceBase getObjectReference() throws IOException, ClassNotFoundException;

    public abstract PendingAction[] getPendingActions() throws IOException, ClassNotFoundException;

    public abstract PropertyFilter getPropertyFilter() throws IOException, ClassNotFoundException;

    public abstract ClientInputStream getClientInputStream() throws IOException, ClassNotFoundException;

    public abstract SearchContext getSearchContext() throws IOException, ClassNotFoundException;

    public abstract DefaultPaging getPagingContext() throws IOException, ClassNotFoundException;

    public abstract Search getSearch() throws IOException, ClassNotFoundException;

    public abstract MergeMode getMergeMode() throws IOException, ClassNotFoundException;

    public abstract Id getId() throws IOException, ClassNotFoundException;

    public abstract ChangeRequest getChangeRequest() throws IOException, ClassNotFoundException;

    public DuplicateObjectCache getObjectCache() {
        return this.dupObjectCache;
    }

    public void setObjectCache(DuplicateObjectCache v) {
        this.dupObjectCache = v;
    }

    public PropertyImpl createPropertyWithNullValue(String name, int mask) {
        int propMask = mask >> 16;
        int propType = mask << 16 >> 16;
        byte access = (byte)(propMask & 0xF);
        switch (propType) {
            case 1: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyBinaryListImpl(name, null, access);
                }
                return new PropertyBinaryImpl(name, null, access);
            }
            case 2: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyBooleanListImpl(name, null, access);
                }
                return new PropertyBooleanImpl(name, null, access);
            }
            case 9: {
                return new PropertyContentImpl(name, (ClientInputStream)null, access);
            }
            case 3: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyDateTimeListImpl(name, null, access);
                }
                return new PropertyDateTimeImpl(name, null, access);
            }
            case 7: {
                if ((propMask & 0x40) != 0) {
                    if ((propMask & 0x80) != 0) {
                        return new PropertyEngineObjectListImpl(name, (DependentObjectList)null, access);
                    }
                    return new PropertyEngineObjectSetImpl(name, (IndependentObjectSet)null, access);
                }
                return new PropertyEngineObjectImpl(name, null, access);
            }
            case 4: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyFloat64ListImpl(name, null, access);
                }
                return new PropertyFloat64Impl(name, null, access);
            }
            case 5: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyIdListImpl(name, null, access);
                }
                return new PropertyIdImpl(name, null, access);
            }
            case 6: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyInteger32ListImpl(name, null, access);
                }
                return new PropertyInteger32Impl(name, null, access);
            }
            case 8: {
                if ((propMask & 0x40) != 0) {
                    return new PropertyStringListImpl(name, null, access);
                }
                return new PropertyStringImpl(name, null, access);
            }
            case 10: {
                return new PropertyUpdateList(name, null);
            }
        }
        return null;
    }

    protected ObjectReferenceBase createObjectReference(int classType) throws IOException {
        switch (classType) {
            case 0: {
                return null;
            }
            case 1: {
                return new DependentIdentity();
            }
            case 2: {
                return new GlobalIdentity();
            }
            case 3: {
                return new ObjectByName();
            }
            case 4: {
                return new ObjectByPath();
            }
            case 5: {
                return new RepositoryIdentity();
            }
            case 6: {
                return new SearchScopeIdentity();
            }
            case 7: {
                return new UnevaluatedPropertyValue();
            }
        }
        throw new InvalidClassException(String.valueOf(classType));
    }

    protected DefaultPaging createPagingContext(int classType) throws IOException {
        switch (classType) {
            case 0: {
                return null;
            }
            case 1: {
                return new DefaultPaging();
            }
            case 2: {
                return new PropertySetPaging();
            }
            case 3: {
                return new SearchObjectPaging();
            }
            case 4: {
                return new SearchRowPaging();
            }
        }
        throw new InvalidClassException(String.valueOf(classType));
    }

    @Override
    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.delegated.readObject();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.delegated.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.delegated.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.delegated.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.delegated.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.delegated.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.delegated.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.delegated.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.delegated.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.delegated.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.delegated.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.delegated.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.delegated.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.delegated.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.delegated.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.delegated.readUTF();
    }

    @Override
    public void close() throws IOException {
        this.delegated.close();
    }
}

