/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class DoAsideInputStream
extends InputStream {
    private InputStream in;
    private byte[] oneByte = new byte[1];

    protected DoAsideInputStream(InputStream in) {
        this.in = in;
    }

    protected abstract void processRead(byte[] var1, int var2, int var3);

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.oneByte, 0, 1);
        if (bytesRead == 1) {
            return this.oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.in.read(buffer, offset, length);
        if (bytesRead != -1) {
            this.processRead(buffer, offset, bytesRead);
        } else {
            this.processRead(null, 0, 0);
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }

    @Override
    public long skip(long skipCount) throws IOException {
        throw new UnsupportedOperationException();
    }
}

