/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.LocaleUtils;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizableText
implements Serializable {
    private static final BaseLogger stLogger = BaseLogger.getBaseLogger(LocalizableText.class, SubSystem.API);
    private static Map mapNameToLocalizableTextInstance = new HashMap();
    private static final String RES_BASE_NAME = "res/LocalizableText";
    public static final Locale stDefaultLocale = Locale.getDefault();
    protected String mKey;
    protected String mEnglishString;
    public static final LocalizableText IMEX_MISSING_INCLUDE_OPTION = new LocalizableText("IMEX_MISSING_INCLUDE_OPTION", "Missing include options for object: {0}");
    public static final LocalizableText IMEX_EXPORT_INTERRUPTED = new LocalizableText("IMEX_EXPORT_INTERRUPTED", "The export process was interrupted by the application.");
    public static final LocalizableText IMEX_EXPORT_CAN_NOT_FETCH = new LocalizableText("IMEX_EXPORT_CAN_NOT_FETCH", "The export process could not fetch an object that was in the export manifest file. The object will not be present in export data set and can not be imported {0}");
    public static final LocalizableText IMEX_INVALID_OBJECT_ID = new LocalizableText("IMEX_INVALID_OBJECT_ID", "An invalid object id was found in the export manifest file {0} This object will not be exported.");
    public static final LocalizableText IMEX_UNSUPPORTED_OBJECT = new LocalizableText("IMEX_UNSUPPORTED_OBJECT", "An unsupported object was found and will not be imported {0}");
    public static final LocalizableText IMEX_OBJECT_NOT_IMPORTED_FAILURE = new LocalizableText("IMEX_OBJECT_NOT_IMPORTED_FAILURE", "Object has failed the import process because of an error {0}");
    public static final LocalizableText IMEX_IMPORT_PREPARING = new LocalizableText("IMEX_IMPORT_PREPARING", "An import run is preparing to start");
    public static final LocalizableText IMEX_IMPORT_RUN_START = new LocalizableText("IMEX_IMPORT_RUN_START", "An import run has started");
    public static final LocalizableText IMEX_IMPORT_RUN_COMPLETE = new LocalizableText("IMEX_IMPORT_RUN_COMPLETE", "An import run has completed; status: {0}, objects processed {1}, updates {2}, creates {3}, failures {4}, skipped {5}");
    public static final LocalizableText IMEX_IMPORT_OBJECT_NOT_NEWER = new LocalizableText("IMEX_IMPORT_OBJECT_NOT_NEWER", "The following object will not be imported because a newer object exists at the destination, and you set the update option to not import source objects that are older than the destination objects : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDataSet={4}, lastModifiedInDestination={5}");
    public static final LocalizableText IMEX_IMPORT_OBJECT_NOT_NEWER_SYNC = new LocalizableText("IMEX_IMPORT_OBJECT_NOT_NEWER_SYNC", "The following object will not be imported because an object exists at the destination with the same last modified date, and you set the update option to not import source objects unless they are newer : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDataSet={4}, lastModifiedInDestination={5}");
    public static final LocalizableText IMEX_IMPORT_MISSING_DATE_LAST_MODIFIED = new LocalizableText("IMEX_IMPORT_MISSING_DATE_LAST_MODIFIED", "The target object can not be updated. The DateLastModified property is missing from the export data set {0}");
    public static final LocalizableText IMEX_IMPORT_CONTROLLER_SKIP = new LocalizableText("IMEX_IMPORT_CONTROLLER_SKIP", "The import controller has determined that an object should be skipped and not imported. {0}");
    public static final LocalizableText IMEX_IMPORT_RESERVATION_EXISTS = new LocalizableText("IMEX_IMPORT_RESERVATION_EXISTS", "An object can not be imported as a new version in the version series because a reservation already exist for this version series {0}");
    public static final LocalizableText IMEX_IMPORT_DUP_DTOK = new LocalizableText("IMEX_IMPORT_DUP_DTOK", "The following object will not be imported because it already exists at the destination, and you set the update option to never import existing object at the destination : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDataSet={4}, lastModifiedInDestination={5}");
    public static final LocalizableText IMEX_IMPORT_DUP_OUT_OF_SYNC = new LocalizableText("IMEX_IMPORT_DUP_OUT_OF_SYNC", "The following object will not be imported because it already exist at the destination, and you set the update option to never import existing object at the destination. The last modified date for the source object and destination object do not match. The data for these objects may not be the same : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDataSet={4}, lastModifiedInDestination={5}");
    public static final LocalizableText IMEX_IMPORT_MISSING_OBJECT = new LocalizableText("IMEX_IMPORT_MISSING_OBJECT", "The following object cannot be imported because one of the objects it references does not exist at the destination : objectName={0}, objectId={1}, className={2}, classId={3}, {4}");
    public static final LocalizableText IMEX_IMPORT_CONFIG_OPTION = new LocalizableText("IMEX_IMPORT_CONFIG_OPTION", "Import configuration option name: {0} value: {1}");
    public static final LocalizableText IMEX_IMPORT_OPTION_SET = new LocalizableText("IMEX_IMPORT_OPTION_SET", "Import option {0} is set");
    public static final LocalizableText IMEX_IMPORT_OPTION_NOT_SET = new LocalizableText("IMEX_IMPORT_OPTION_NOT_SET", "Import option {0} is NOT set");
    public static final LocalizableText IMEX_IMPORT_CONTROLLER = new LocalizableText("IMEX_IMPORT_CONTROLLER", "Import Controller: {0}");
    public static final LocalizableText IMEX_IMPORT_UPDATE = new LocalizableText("IMEX_IMPORT_UPDATE", "Import Update: {0}");
    public static final LocalizableText IMEX_IMPORT_OPTIONAL_STORAGE_POLICY = new LocalizableText("IMEX_IMPORT_OPTIONAL_STORAGE_POLICY", "Import optional storage policy (class[/name]): ({0})");
    public static final LocalizableText IMEX_EXPORT_PREPARING = new LocalizableText("IMEX_EXPORT_PREPARING", "An export run is preparing to start");
    public static final LocalizableText IMEX_EXPORT_RUN_START = new LocalizableText("IMEX_EXPORT_RUN_START", "An export run has started");
    public static final LocalizableText IMEX_EXPORT_RUN_COMPLETE = new LocalizableText("IMEX_EXPORT_RUN_COMPLETE", "An export run has completed; status: {0}, objects processed {1} failures {2}");
    public static final LocalizableText IMEX_EXPORT_OBJECT_COUNT = new LocalizableText("IMEX_EXPORT_OBJECT_COUNT", "Exported {0} item(s) of type {1}");
    public static final LocalizableText IMEX_EXPORT_CONFIG_OPTION = new LocalizableText("IMEX_EXPORT_CONFIG_OPTION", "Export configuration option name: {0} value: {1}");
    public static final LocalizableText IMEX_EXPORT_OPTION_SET = new LocalizableText("IMEX_EXPORT_OPTION_SET", "Export option {0} is set");
    public static final LocalizableText IMEX_EXPORT_OPTION_NOT_SET = new LocalizableText("IMEX_EXPORT_OPTION_NOT_SET", "Export option {0} is NOT set");
    public static final LocalizableText IMEX_EXPORT_OBJECT_REPROCESSED = new LocalizableText("IMEX_EXPORT_OBJECT_REPROCESSED", "Object {0} was reprocessed with more pre-requisite included due to includeOption change after it has been written out. You may want to re-arrange exporting objects with most inclusive includeOptions first.");
    public static final LocalizableText IMEX_BUILD_VERSION = new LocalizableText("IMEX_BUILD_VERSION", "Build version: {0}");
    public static final LocalizableText IMEX_JAVA_VERSION = new LocalizableText("IMEX_JAVA_VERSION", "Java version: {0}");
    public static final LocalizableText IMEX_EXPORT_CONTROLLER = new LocalizableText("IMEX_EXPORT_CONTROLLER", "Export Controller: {0}");
    public static final LocalizableText IMEX_IMPORT_STOP_ON_EXCEPTION = new LocalizableText("IMEX_IMPORT_STOP_ON_EXCEPTION", "The import process is stopping because an exception is being thrown");
    public static final LocalizableText IMEX_EXPORT_STOP_ON_EXCEPTION = new LocalizableText("IMEX_EXPORT_STOP_ON_EXCEPTION", "The export process is stopping because an exception is being thrown {0}");
    public static final LocalizableText IMEX_CAN_NOT_FIND_SUPERCLASS = new LocalizableText("IMEX_CAN_NOT_FIND_SUPERCLASS", "A class definition can not be imported because the super class can not be located {0}");
    public static final LocalizableText IMEX_CAN_NOT_FIND_CLASS_DESCRIPTION = new LocalizableText("IMEX_CAN_NOT_FIND_CLASS_DESCRIPTION", "An object can not be imported because the class description can not be located {0}");
    public static final LocalizableText IMEX_IMPORT_SYSTEM_PROP_NO_RIGHTS = new LocalizableText("IMEX_IMPORT_SYSTEM_PROP_NO_RIGHTS", "The current import process is attempting to update system properties and the current user does not have security right to do this for object store {0}. Some or all of this import may fail until the current user is assigned the \"modify certain system properties\" right on the object store.");
    public static final LocalizableText IMEX_EXPORT_CAN_NOT_FETCH_CONTROLLER_PREREQ = new LocalizableText("IMEX_EXPORT_CAN_NOT_FETCH_CONTROLLER_PREREQ", "The export process could not fetch an object that it was given as from the calling application through the export controller. The object will not be present in export data set and can not be imported {0}");
    public static final LocalizableText IMEX_NO_STACK = new LocalizableText("IMEX_NO_STACK", "{0} {1}");
    public static final LocalizableText IMEX_UNRESOLVED_CIRCULAR_REFERENCE_CHAIN = new LocalizableText("IMEX_UNRESOLVED_CIRCULAR_REFERENCE_CHAIN", "The following objects involved in circular reference chain can not be imported. {0}");
    public static final LocalizableText IMEX_IMPORT_DUP_NO_DLM_SOURCE_DEST_IF_NEWER = new LocalizableText("IMEX_IMPORT_DUP_NO_DLM_SOURCE_DEST_IF_NEWER", "The following object will not be imported because it already exists at the destination, and you set the update option to not import source objects unless they are newer. It has not been modified at the source and target object stores since it was created : objectName={0}, objectId={1}, className={2}, classId={3}");
    public static final LocalizableText IMEX_IMPORT_DUP_NO_DLM_SOURCE_IF_NEWER = new LocalizableText("IMEX_IMPORT_DUP_NO_DLM_SOURCE_IF_NEWER", "The following object will not be imported because it already exists at the destination, and you set the update option to not import source objects unless they are newer. It has been modified at the target object store since it was created but not at the source object store. The data for these objects may not be the same : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDestination={4}");
    public static final LocalizableText IMEX_IMPORT_DUP_NO_DLM_SOURCE_DEST_NEVER = new LocalizableText("IMEX_IMPORT_DUP_NO_DLM_SOURCE_DEST_NEVER", "The following object will not be imported because it already exist at the destination, and you set the update option to never import existing object at the destination. It has not been modified at the source and target object stores since it was created : objectName={0}, objectId={1}, className={2}, classId={3}");
    public static final LocalizableText IMEX_IMPORT_DUP_NO_DLM_SOURCE_NEVER = new LocalizableText("IMEX_IMPORT_DUP_NO_DLM_SOURCE_NEVER", "The following object will not be imported because it already exist at the destination, and you set the update option to never import existing object at the destination. It has been modified at the target object store since it was created but not at the source object store. The data for these objects may not be the same : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDestination={4}");
    public static final LocalizableText IMEX_IMPORT_DUP_NO_DLM_TARGET_NEVER = new LocalizableText("IMEX_IMPORT_DUP_NO_DLM_TARGET_NEVER", "The following object will not be imported because it already exist at the destination, and you set the update option to never import existing object at the destination. It has been modified at the source object store since it was created but not at the target object store. The data for these objects may not be the same : objectName={0}, objectId={1}, className={2}, classId={3}, lastModifiedInDataSet={4}");
    public static final LocalizableText IMEX_IMPORT_NO_TARGET_CREATE_NEVER = new LocalizableText("IMEX_IMPORT_NO_TARGET_CREATE_NEVER", "The following object will not be imported because it does not exist at the destination, and you set the create option to never import new objects at the destination. It has been exported from the source object store but will not exist at the destination : objectName={0}, objectId={1}, className={2}, classId={3}");
    public static final LocalizableText IMEX_IMPORT_RETENTION_NO_RIGHTS = new LocalizableText("IMEX_IMPORT_RETENTION_NO_RIGHTS", "The current import process is attempting to update retention and the current user does not have security right to do this for object store {0}. Some or all of this import may fail until the current user is assigned the \"modify retention\" right on the object store.");
    public static final LocalizableText IMEX_IMPORT_OBJECT_RETENTION_EARLIER = new LocalizableText("IMEX_IMPORT_OBJECT_RETENTION_EARLIER", "The retention date of the source object is earlier than the retention date of the target object, the retention date of the target object will be left unaltered : objectId={0}, className={1}, classId={2}, sourceRetentionDate={3}, destinationRetentionDate={4}");
    public static final LocalizableText IMEX_SKIP_IMPORT_NON_MODIFIABLE_CD = new LocalizableText("IMEX_SKIP_IMPORT_NON_MODIFIABLE_CD", "The following class definition will not be imported because it is system owned and protected against modifications : className={0}, classId={1}");
    public static final LocalizableText IMEX_SKIP_IMPORT_SUPERCD_FAILED_TO_IMPORT = new LocalizableText("IMEX_SKIP_IMPORT_SUPERCD_FAILED_TO_IMPORT", "A class definition will not be imported because its super class failed on import : classId={0}, superClassId={1}");
    public static final LocalizableText LT_EXAMPLE = new LocalizableText("LT_EXAMPLE", "This is some sample localizable text.");
    private static final long serialVersionUID = -4846791583317622768L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private LocalizableText(String key, String englishString) {
        this.mKey = key;
        this.mEnglishString = englishString;
        mapNameToLocalizableTextInstance.put(key, this);
    }

    protected String getBaseName() {
        return RES_BASE_NAME;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getDefaultEnglishString() {
        return this.mEnglishString;
    }

    public static LocalizableText getLocalizableText(String key) {
        return (LocalizableText)mapNameToLocalizableTextInstance.get(key);
    }

    public String toString(Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, UserContext.get().getLocale(), args);
    }

    public String toString() {
        return this.toStringHelper(RES_BASE_NAME, UserContext.get().getLocale(), null);
    }

    private synchronized String toStringHelper(String BaseName, Locale le, Object[] args) {
        String formattedString;
        String patternString;
        try {
            if (BaseName == null || le == null || this.mKey == null) {
                patternString = this.mEnglishString;
            } else {
                String[] lc = new String[]{le.getLanguage(), le.getCountry()};
                boolean didChange = LocaleUtils.localeSpecialCaseSwitcheroo(lc);
                if (didChange) {
                    lc[1] = lc[1] == null ? null : lc[1].toUpperCase();
                    le = new Locale(lc[0], lc[1]);
                }
                ResourceBundle bundle = ResourceBundle.getBundle(BaseName, le);
                patternString = bundle.getString(this.mKey);
            }
        }
        catch (MissingResourceException ex) {
            patternString = this.mEnglishString;
            le = Locale.US;
        }
        try {
            if (args != null && args.length > 0) {
                MessageFormat form = new MessageFormat(patternString, le);
                formattedString = form.format(args);
            } else {
                formattedString = patternString;
            }
        }
        catch (Exception ex) {
            formattedString = this.mEnglishString;
            try {
                stLogger.error("Failed formating resource string: " + patternString, ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formattedString;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mKey);
        s.writeObject(this.mEnglishString);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mKey = (String)s.readObject();
        this.mEnglishString = (String)s.readObject();
    }

    private Object readResolve() throws ObjectStreamException {
        return LocalizableText.getLocalizableText(this.mKey);
    }
}

