/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LoggerMessageMap {
    public static final String ID_AUTOMATIC_UPGRADE_DOMAIN = "AU_DOMAIN";
    public static final String ID_AUTOMATIC_UPGRADE_OBJECTSTORE = "AU_OBJECTSTORE";
    public static final String ID_ASYNC_UPGRADE_OBJECTSTORE = "ASYNCUPGRADE_OBJECTSTORE";
    public static final int STATUS_IN_PROGRESS = 0;
    public static final int STATUS_COMPLETED = 1;
    public static final int STATUS_NOT_AVAILABLE = 2;
    public static final int STATUS_ASYNC_UPGRADE_IN_PROGRESS = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_NOT_APPLICABLE = 5;
    public static final int STATUS_DISABLED = 6;
    private static final int MESSAGETYPE_SCHEMA_REVISION = 0;
    public static final String PATH_DELIMITER = "\\";
    private static final boolean isTestMode = true;
    private static HashMap topLevelMap = new HashMap();
    private static HashMap statusMap = new HashMap();

    public static HashMap getDomainMassageMap() {
        return LoggerMessageMap.getMapFromPath(ID_AUTOMATIC_UPGRADE_DOMAIN);
    }

    public static HashMap getObjectStoreMassageMap() {
        return LoggerMessageMap.getMapFromPath(ID_AUTOMATIC_UPGRADE_OBJECTSTORE);
    }

    public static List getAllObjectStores() {
        ArrayList<String> osList = new ArrayList<String>();
        Object[] keyArray = statusMap.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            if (key.indexOf(ID_AUTOMATIC_UPGRADE_OBJECTSTORE) < 0) continue;
            osList.add(key.substring(key.lastIndexOf(PATH_DELIMITER) + 1));
        }
        return osList;
    }

    public static List getAllDomains() {
        ArrayList<String> osList = new ArrayList<String>();
        Object[] keyArray = statusMap.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            if (key.indexOf(ID_AUTOMATIC_UPGRADE_DOMAIN) < 0) continue;
            osList.add(key.substring(key.lastIndexOf(PATH_DELIMITER) + 1));
        }
        return osList;
    }

    public static int getDomainUpgradeStatus(String domainKey) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainKey}));
    }

    public static void setDomainUpgradeStatus(String domainKey, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainKey}), status);
    }

    public static int getObjectStoreUpgradeStatus(String osKey) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osKey}));
    }

    public static void setObjectStoreUpgradeStatus(String osKey, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osKey}), status);
    }

    public static int getObjectStoreAsyncUpgradeStatus(String osKey) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_ASYNC_UPGRADE_OBJECTSTORE, osKey}));
    }

    public static void setObjectStoreAsyncUpgradeStatus(String osKey, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_ASYNC_UPGRADE_OBJECTSTORE, osKey}), status);
    }

    public static String getObjectStoreSchemaRevision(String osKey) {
        return LoggerMessageMap.getMessageStringFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osKey}), 0);
    }

    public static void setObjectStoreSchemaRevision(String osKey, String schemaRevision) {
        LoggerMessageMap.updateMessageStringFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osKey}), 0, schemaRevision);
    }

    public static void clearDomainStatus(String domainKey) {
        LoggerMessageMap.clearStatus(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainKey}));
    }

    public static void clearObjectStoreStatus(String osKey) {
        LoggerMessageMap.clearStatus(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osKey}));
        LoggerMessageMap.clearStatus(LoggerMessageMap.buildPath(new String[]{ID_ASYNC_UPGRADE_OBJECTSTORE, osKey}));
    }

    private static void clearStatus(String path) {
        statusMap.remove(path);
    }

    private static String buildPath(String[] orderedElementNameArray) {
        String result = "";
        if (orderedElementNameArray == null || orderedElementNameArray.length == 0) {
            return null;
        }
        if (orderedElementNameArray.length == 1) {
            return orderedElementNameArray[0];
        }
        for (int i = 0; i < orderedElementNameArray.length - 1; ++i) {
            result = result + orderedElementNameArray[i] + PATH_DELIMITER;
        }
        return result + orderedElementNameArray[orderedElementNameArray.length - 1];
    }

    private static HashMap getMapFromPath(String path) {
        HashMap currentMap = topLevelMap;
        StringTokenizer st = new StringTokenizer(path, PATH_DELIMITER);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!currentMap.containsKey(key)) {
                HashMap newMap = new HashMap();
                currentMap.put(key, newMap);
                currentMap = newMap;
                continue;
            }
            currentMap = (HashMap)currentMap.get(key);
        }
        return currentMap;
    }

    private static int getStatusFromPath(String path) {
        if (!statusMap.containsKey(path)) {
            throw new NoSuchElementException("Failed to find status from path: " + path);
        }
        return ((NodeStatus)statusMap.get(path)).getStatus();
    }

    private static void updateStatusFromPath(String path, int newStatus) {
        NodeStatus ns = (NodeStatus)statusMap.get(path);
        if (ns == null) {
            ns = new NodeStatus();
            statusMap.put(path, ns);
        }
        ns.setStatus(newStatus);
    }

    private static String getMessageStringFromPath(String path, int messageType) {
        if (!statusMap.containsKey(path)) {
            throw new NoSuchElementException("Failed to find message from path: " + path);
        }
        return ((NodeStatus)statusMap.get(path)).getMessageString(messageType);
    }

    private static void updateMessageStringFromPath(String path, int messageType, String newMessage) {
        NodeStatus ns = (NodeStatus)statusMap.get(path);
        if (ns == null) {
            ns = new NodeStatus();
            statusMap.put(path, ns);
        }
        ns.setMessageString(messageType, newMessage);
    }

    public static void runTest(int mode) {
        topLevelMap.clear();
        statusMap.clear();
        String domainName1 = "{00000000-0000-0000-0000-000000000000}:sebastopol";
        String osName1 = "{00000000-0000-0000-0000-000000000000}:SqlOS";
        String osName2 = "{00000000-0000-0000-0000-000000000000}:OraOS";
        LoggerMessageMap.setDomainUpgradeStatus(domainName1, 0);
        LoggerMessageMap.addTestMessage(domainName1, LoggerMessageMap.getDomainMassageMap(), true);
        LoggerMessageMap.setDomainUpgradeStatus(domainName1, 1);
        LoggerMessageMap.setObjectStoreUpgradeStatus(osName1, 0);
        LoggerMessageMap.setObjectStoreSchemaRevision(osName1, "18.3.7 DB");
        LoggerMessageMap.setObjectStoreUpgradeStatus(osName2, 1);
        LoggerMessageMap.setObjectStoreSchemaRevision(osName2, "19.1.31");
        LoggerMessageMap.addTestMessage(osName1, LoggerMessageMap.getObjectStoreMassageMap(), false);
        if (mode == 2) {
            String tenant1 = "{11111111-0000-0000-0000-000000000000}:Tenant1";
            String tenant1OS1 = "{11111111-0000-0000-0000-000000000000}:SqlTenant";
            String tenant1OS2 = "{11111111-0000-0000-0000-000000000000}:SqlTenant2";
            String tenant2 = "{22222222-0000-0000-0000-000000000000}:Tenant2";
            String tenant2OS1 = "{22222222-0000-0000-0000-000000000000}:OraTenant";
            String tenant2OS2 = "{22222222-0000-0000-0000-000000000000}:OraTenant2";
            LoggerMessageMap.setDomainUpgradeStatus(tenant1, 1);
            LoggerMessageMap.addTestMessage(tenant1, LoggerMessageMap.getDomainMassageMap(), true);
            LoggerMessageMap.setObjectStoreUpgradeStatus(tenant1OS1, 0);
            LoggerMessageMap.setObjectStoreSchemaRevision(tenant1OS1, "19.1.31 MISC");
            LoggerMessageMap.setObjectStoreUpgradeStatus(tenant1OS2, 1);
            LoggerMessageMap.setObjectStoreSchemaRevision(tenant1OS2, "19.1.31");
            LoggerMessageMap.setObjectStoreAsyncUpgradeStatus(tenant1OS1, 2);
            LoggerMessageMap.addTestMessage(tenant1OS1, LoggerMessageMap.getObjectStoreMassageMap(), false);
            LoggerMessageMap.setDomainUpgradeStatus(tenant2, 1);
            LoggerMessageMap.setObjectStoreUpgradeStatus(tenant2OS1, 0);
            LoggerMessageMap.setObjectStoreSchemaRevision(tenant2OS2, "19.1.31 Install UAOs");
            LoggerMessageMap.setObjectStoreUpgradeStatus(tenant2OS2, 1);
            LoggerMessageMap.setObjectStoreSchemaRevision(tenant2OS2, "19.1.31");
            LoggerMessageMap.setObjectStoreAsyncUpgradeStatus(tenant2OS2, 4);
            LoggerMessageMap.addTestMessage(tenant2OS2, LoggerMessageMap.getObjectStoreMassageMap(), false);
        }
    }

    private static void addTestMessage(String key, HashMap map, boolean forDomain) {
        String name = key.substring(key.indexOf(":") + 1);
        ArrayList<String> messages = new ArrayList<String>();
        if (forDomain) {
            messages.add("2014-05-28T17:39:18.569 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Performing domain upgrade sequence from version '5.2.0.2.9' to version '5.2.1.0.26'...");
            messages.add("2014-05-28T17:39:18.642 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on ObjectStore '" + name + "'...");
            messages.add("2014-05-28T17:39:18.741 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on TraceLoggingConfiguration...");
            messages.add("2014-05-28T17:39:18.774 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on CmProcessEngineConfiguration...");
            messages.add("2014-05-28T17:39:18.800 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on CmSweepConfiguration...");
            messages.add("2014-05-28T17:39:18.824 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on ContentConfiguration...");
            messages.add("2014-05-28T17:39:18.848 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting default values of new properties on VirtualServer 'myServer'...");
            messages.add("2014-05-28T17:39:28.768 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Adding domain-level subsystem configuration objects ...");
            messages.add("2014-05-28T17:39:28.786 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Creating new system AddOns (as necessary)...");
            messages.add("2014-05-28T17:39:36.096 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Creating 5.2.0 FP1|FP2 UpgradeAddOns...");
            messages.add("2014-05-28T17:39:36.213 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Setting DocumentationURL property to 'http://pic.dhe.ibm.com/infocenter/p8docs/v5r2m1/topic/'...");
            messages.add("2014-05-28T17:39:36.228 012480CA ENG  FNRCE0000I - INFO DomainUpgrade(" + name + ") Completed domain upgrade sequence from version '5.2.0.2.9' to version '5.2.1.0.26'.");
        } else {
            messages.add("2014-05-28T17:39:43.364 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '18.3.7' to phase '18.3.7 DB'...");
            messages.add("2014-05-28T17:39:43.436 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '18.3.7' to phase '18.3.7 DB'.");
            messages.add("2014-05-28T17:39:53.280 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '18.3.7 DB' to phase '18.3.7 MISC'...");
            messages.add("2014-05-28T17:39:57.228 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '18.3.7 DB' to phase '18.3.7 MISC'.");
            messages.add("2014-05-28T17:40:05.280 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '18.3.7 MISC' to phase '19.1.31 MISC'...");
            messages.add("2014-05-28T17:40:05.976 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '18.3.7 MISC' to phase '19.1.31 MISC'.");
            messages.add("2014-05-28T17:41:21.682 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '19.1.31 MISC' to phase '19.1.31 TIME'...");
            messages.add("2014-05-28T17:41:21.723 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '19.1.31 MISC' to phase '19.1.31 TIME'.");
            messages.add("2014-05-28T17:41:33.688 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '19.1.31 TIME' to phase '19.1.31 REPL'...");
            messages.add("2014-05-28T17:41:33.698 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '19.1.31 TIME' to phase '19.1.31 REPL'.");
            messages.add("2014-05-28T17:41:45.691 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '19.1.31 REPL' to phase '19.1.31 InstallUAOs'...");
            messages.add("2014-05-28T17:41:45.712 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '19.1.31 REPL' to phase '19.1.31 InstallUAOs'.");
            messages.add("2014-05-28T17:41:59.889 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Performing object store upgrade sequence from phase '19.1.31 InstallUAOs' to phase '19.1.31'...");
            messages.add("2014-05-28T17:41:59.940 012480CA ENG  FNRCE0000I - INFO ObjectStoreUpgrade(" + name + ") Completed object store upgrade sequence from phase '19.1.31 InstallUAOs' to phase '19.1.31'.");
        }
        map.put(key, messages);
    }

    private static class NodeStatus {
        private int status;
        private HashMap messageMap = new HashMap();

        public NodeStatus() {
            this.status = 0;
        }

        public NodeStatus(int initStatus) {
            this.status = initStatus;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int newStatus) {
            this.status = newStatus;
        }

        public String getMessageString(int messageType) {
            return (String)this.messageMap.get(new Integer(messageType));
        }

        public void setMessageString(int messageType, String value) {
            this.messageMap.put(new Integer(messageType), value);
        }
    }
}

