/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.SpillStreamFactory;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public abstract class MultipartInputStreamManager {
    protected static final TransportLogger logger = TransportLogger.getLogger(MultipartInputStreamManager.class, SubSystem.WSI);
    private String rootContentId = null;
    private ManagedInputStream rootInputStream = null;
    private SpillStreamFactory ssF;
    private Map<String, ManagedInputStream> bypassedParts = null;
    private ManagedInputStream activeMIS = null;
    private byte[] drainBuffer = null;

    private int read(ManagedInputStream requestingMIS, byte[] b, int off, int len) throws IOException {
        this.ensureThisMisIsActive(requestingMIS);
        if (requestingMIS.getSpillStream() != null) {
            return requestingMIS.read(b, off, len);
        }
        if (this.isManagedInputStreamAtLogicalEOF()) {
            return -1;
        }
        int availableRightNow = this.availableRightNow();
        if (availableRightNow == 0) {
            this.makeSomethingAvailable();
            availableRightNow = this.availableRightNow();
        }
        int howManyToEat = Math.min(availableRightNow, len);
        int howManyDidEat = this.eatBytesFromBuffer(b, off, howManyToEat);
        return howManyDidEat;
    }

    private int available(ManagedInputStream requestingMIS) throws IOException {
        this.ensureThisMisIsActive(requestingMIS);
        if (requestingMIS.getSpillStream() != null) {
            return requestingMIS.available();
        }
        if (requestingMIS.isClosed()) {
            return 0;
        }
        int availableRightNow = this.availableRightNow();
        if (availableRightNow > 0) {
            return availableRightNow;
        }
        if (this.isManagedInputStreamAtLogicalEOF()) {
            return 0;
        }
        this.makeSomethingAvailable();
        return this.available(requestingMIS);
    }

    private void close(ManagedInputStream requestingMIS) throws IOException {
        this.ensureThisMisIsActive(requestingMIS);
        if (requestingMIS.getSpillStream() != null) {
            requestingMIS.close();
        }
    }

    private long skip(ManagedInputStream requestingMIS, long howManyToSkip) throws IOException {
        this.ensureThisMisIsActive(requestingMIS);
        if (requestingMIS.getSpillStream() != null) {
            return requestingMIS.skip(howManyToSkip);
        }
        if (howManyToSkip < 0L) {
            return 0L;
        }
        for (long skippedSoFar = 0L; skippedSoFar < howManyToSkip; ++skippedSoFar) {
            try {
                requestingMIS.read();
                continue;
            }
            catch (IOException e) {
                return skippedSoFar;
            }
        }
        return howManyToSkip;
    }

    protected MultipartInputStreamManager(String rootContentId, SpillStreamFactory ssF) {
        this.rootContentId = rootContentId;
        this.ssF = ssF;
    }

    protected void setRootContentId(String rootContentId) {
        this.rootContentId = rootContentId;
    }

    public String getRootContentId() {
        return this.rootContentId;
    }

    private ManagedInputStream getBypassedPart(String contentID) {
        if (this.bypassedParts == null) {
            return null;
        }
        ManagedInputStream mis = this.bypassedParts.get(contentID);
        if (mis != null) {
            return mis;
        }
        String decoded = MultipartInputStreamManager.urlDecode(contentID);
        mis = this.bypassedParts.get(decoded);
        return mis;
    }

    private void putBypassedPart(ManagedInputStream mis, long totalBytesBypassed) {
        if (this.bypassedParts == null) {
            this.bypassedParts = new HashMap<String, ManagedInputStream>();
        }
        this.bypassedParts.put(mis.getContentId(), mis);
        if (logger.isDetailTraceEnabled()) {
            String verb = totalBytesBypassed == 0L ? "finished" : "bypassed";
            logger.traceDetail("iPART " + verb + "   CID=" + mis.getContentId() + "; MIS=" + System.identityHashCode(mis) + " " + mis.getClass().getSimpleName() + "; unread bytes " + totalBytesBypassed);
        }
    }

    public ManagedInputStream getActiveMIS() {
        return this.activeMIS;
    }

    public InputStream getRootInputStream() {
        if (this.rootInputStream == null) {
            this.rootInputStream = (ManagedInputStream)this.instantiateContentInputStream(this.rootContentId);
        }
        return this.rootInputStream;
    }

    public InputStream instantiateContentInputStream(String contentId) {
        ManagedInputStream bypassedPart = this.getBypassedPart(contentId);
        if (bypassedPart != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("iPART bypassfind CID=" + contentId + "; MIS=" + System.identityHashCode(bypassedPart) + " " + bypassedPart.getClass().getSimpleName());
            }
            return bypassedPart;
        }
        if (contentId != null && !contentId.isEmpty() && (this.rootContentId == null || this.rootContentId.isEmpty())) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("iPart rootfixup CID=" + contentId + "; MIS=" + System.identityHashCode(this.rootInputStream));
            }
            this.rootContentId = contentId;
            if (this.rootInputStream != null) {
                this.rootInputStream.setContentId(contentId);
                return this.rootInputStream;
            }
        }
        ManagedInputStream mis = new ManagedInputStream(this, contentId);
        if (logger.isDetailTraceEnabled()) {
            String mention = "forwrdref ";
            if (MultipartInputStreamManager.contentIdsMatch(this.rootContentId, contentId, null)) {
                mention = "forwrdrefR";
            }
            logger.traceDetail("iPART " + mention + " CID=" + contentId + "; MIS=" + System.identityHashCode(mis) + " " + mis.getClass().getSimpleName());
        }
        return mis;
    }

    private void drainActiveMisToSpillStream() throws IOException {
        int howMany;
        boolean needSpillStream;
        if (this.activeMIS == null) {
            return;
        }
        if (this.activeMIS.hasActiveSpillStream()) {
            return;
        }
        boolean bl = needSpillStream = this.ssF != null && this.activeMIS.getSpillStream() == null;
        if (this.drainBuffer == null) {
            this.drainBuffer = new byte[2048];
        }
        OutputStream ssOs = null;
        SpillStreamFactory ssInstance = null;
        if (needSpillStream) {
            ssInstance = this.ssF.getInstance(logger);
            ssOs = ssInstance.getOutputStream(this.activeMIS.getContentId());
        }
        long totalBytesBypassed = 0L;
        boolean previousIsClosed = this.activeMIS.isClosed();
        while ((howMany = this.activeMIS.read(this.drainBuffer)) >= 0) {
            if (!needSpillStream) continue;
            ssOs.write(this.drainBuffer, 0, howMany);
            totalBytesBypassed += (long)howMany;
        }
        if (totalBytesBypassed == 0L) {
            this.activeMIS.setSpillStream(this.activeMIS);
        } else if (needSpillStream) {
            ssOs.close();
            this.activeMIS.setSpillStream(ssInstance.getInputStream());
            this.activeMIS.setIsClosed(previousIsClosed);
        }
        this.putBypassedPart(this.activeMIS, totalBytesBypassed);
    }

    public static final boolean contentIdsMatch(String activeID, String desiredID, String whyCalled) {
        if (whyCalled != null && logger.isDetailTraceEnabled()) {
            logger.traceDetail("  CID matching raw A=" + activeID + "; D=" + desiredID + "; " + whyCalled);
        }
        if (desiredID == null) {
            return true;
        }
        if (activeID == null) {
            return false;
        }
        if (desiredID.equals(activeID)) {
            return true;
        }
        if (desiredID.length() >= activeID.length() && (desiredID.indexOf("%") >= 0 || desiredID.indexOf("+") >= 0)) {
            String decodedDesiredID = MultipartInputStreamManager.urlDecode(desiredID);
            if (whyCalled != null && logger.isDetailTraceEnabled()) {
                logger.traceDetail("  CID matching dec A=" + activeID + "; D=" + decodedDesiredID + "; " + whyCalled);
            }
            if (decodedDesiredID.equals(activeID)) {
                return true;
            }
        }
        return false;
    }

    private static String urlDecode(String raw) {
        String decoded;
        try {
            decoded = URLDecoder.decode(raw, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            decoded = URLDecoder.decode(raw);
        }
        return decoded;
    }

    public ManagedInputStream activateNextContentInputStream() throws IOException {
        this.drainActiveMisToSpillStream();
        this.activeMIS = this.getNextContentInputStream();
        return this.activeMIS;
    }

    private void ensureThisMisIsActive(ManagedInputStream desiredMIS) throws IOException {
        String desiredID;
        if (this.activeMIS == desiredMIS) {
            return;
        }
        String activeID = this.activeMIS == null ? "\u0001" : this.activeMIS.getContentId();
        String string = desiredID = desiredMIS == null ? "\u0002" : desiredMIS.getContentId();
        if (this.activeMIS != null && MultipartInputStreamManager.contentIdsMatch(activeID, desiredID, null)) {
            return;
        }
        ManagedInputStream previouslySeenMIS = this.getBypassedPart(desiredID);
        if (previouslySeenMIS != null) {
            this.drainActiveMisToSpillStream();
            this.activeMIS = previouslySeenMIS;
        } else {
            do {
                this.drainActiveMisToSpillStream();
                this.activeMIS = this.getNextContentInputStream();
                String string2 = desiredID = desiredMIS == null ? "\u0002" : desiredMIS.getContentId();
                if (this.activeMIS != null) continue;
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_MISSING_BODY_PART, (Object[])new String[]{desiredID});
            } while (!MultipartInputStreamManager.contentIdsMatch(this.activeMIS.getContentId(), desiredID, "becameActive?"));
        }
        if (this.activeMIS != null) {
            desiredMIS.setIsClosed(this.activeMIS.isClosed());
            if (this.activeMIS.isSpillStreamExhausted()) {
                desiredMIS.setSpillStream(desiredMIS);
            } else {
                desiredMIS.setSpillStream(this.activeMIS.getSpillStream());
            }
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("iPART activated  CID=" + desiredID + "; MIS=" + System.identityHashCode(desiredMIS) + System.identityHashCode(desiredMIS) + " " + desiredMIS.getClass().getSimpleName());
        }
        this.activeMIS = desiredMIS;
    }

    protected abstract int availableRightNow();

    protected abstract int eatBytesFromBuffer(byte[] var1, int var2, int var3) throws IOException;

    protected abstract ManagedInputStream getNextContentInputStream() throws IOException;

    protected abstract boolean isManagedInputStreamAtLogicalEOF() throws IOException;

    protected abstract void makeSomethingAvailable() throws IOException;

    public static final class ManagedInputStream
    extends InputStream {
        private boolean closed = false;
        private String contentId;
        private final MultipartInputStreamManager mgr;
        private InputStream spillStream = null;

        private boolean isClosed() {
            return this.closed;
        }

        private void setIsClosed(boolean isClosed) {
            this.closed = isClosed;
        }

        private void setContentId(String newId) {
            this.contentId = newId;
        }

        public String getContentId() {
            return this.contentId;
        }

        private ManagedInputStream(MultipartInputStreamManager mgr, String contentId) {
            this.mgr = mgr;
            this.contentId = contentId;
        }

        private void setSpillStream(InputStream spillStream) {
            this.spillStream = spillStream;
        }

        private InputStream getSpillStream() {
            return this.spillStream;
        }

        private boolean isSpillStreamExhausted() {
            return this.spillStream == this;
        }

        private boolean hasActiveSpillStream() {
            return this.spillStream != null && this.spillStream != this;
        }

        @Override
        public int available() throws IOException {
            if (this.isClosed() || this.isSpillStreamExhausted()) {
                return 0;
            }
            if (this.spillStream == null) {
                return this.mgr.available(this);
            }
            return this.spillStream.available();
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed() || this.isSpillStreamExhausted()) {
                return;
            }
            if (this.spillStream == null) {
                this.mgr.close(this);
            } else {
                this.spillStream.close();
                this.spillStream = this;
            }
            this.setIsClosed(true);
        }

        @Override
        public int read() throws IOException {
            byte[] oneByte = new byte[1];
            int result = this.read(oneByte);
            if (result < 0) {
                return result;
            }
            return 0xFF & oneByte[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            int howMany = this.read(b, 0, b.length);
            return howMany;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isClosed() || this.isSpillStreamExhausted()) {
                return -1;
            }
            int howMany = this.spillStream == null ? this.mgr.read(this, b, off, len) : this.spillStream.read(b, off, len);
            if (howMany < 0) {
                this.close();
            }
            return howMany;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.isClosed() || this.isSpillStreamExhausted()) {
                return 0L;
            }
            long howMany = this.spillStream == null ? this.mgr.skip(this, n) : this.spillStream.skip(n);
            return howMany;
        }
    }
}

