/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.UniToken;

public class UnifiedContext {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(UnifiedContext.class, SubSystem.Security);
    private UniToken impToken;
    private UserContext savedContext;
    private static ThreadLocal tl = new ThreadLocal();
    private static ThreadLocal tlServerComm = new ThreadLocal();

    public UnifiedContext(UniToken impToken, UserContext savedContext) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("[UnifiedContext] constructor 0x" + Integer.toHexString(this.hashCode()) + "\r\nimpToken=" + impToken);
        }
        this.impToken = impToken;
        this.savedContext = savedContext;
    }

    public UniToken getImpToken() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("[UnifiedContext] getImpToken 0x" + Integer.toHexString(this.hashCode()) + "\r\ntoken=" + this.impToken);
        }
        return this.impToken;
    }

    public UserContext getSavedContext() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("[UnifiedContext] getSavedContext 0x" + Integer.toHexString(this.hashCode()));
        }
        return this.savedContext;
    }

    public void destroy() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("[UnifiedContext] destroy 0x" + Integer.toHexString(this.hashCode()) + "\r\ntoken=" + this.impToken);
        }
        if (this.impToken != null) {
            this.impToken.destroy();
        }
        this.impToken = null;
        this.savedContext = null;
    }

    public static UnifiedContext get() {
        return (UnifiedContext)tl.get();
    }

    public static void set(UnifiedContext ucxt) {
        tl.set(ucxt);
    }

    public static UnifiedContext getServerCommCtx() {
        return (UnifiedContext)tlServerComm.get();
    }

    public static void setServerCommCtx(UnifiedContext ucxt) {
        tlServerComm.set(ucxt);
    }
}

