/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.ApiToEngineBridge;
import com.filenet.apiimpl.util.UniBinary;
import com.filenet.apiimpl.util.UniBinaryKeyGen;
import com.filenet.apiimpl.util.UniToken;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;

public final class UnifiedUtil {
    public static final String SERVER_COMM = "#SERVERCOMM-";
    public static final String PE_SERVER_USER = UnifiedUtil.setUpPeServerUsername();

    private UnifiedUtil() {
    }

    private static String setUpPeServerUsername() {
        String name = ApiToEngineBridge.getPeServerUsername();
        if (name == null) {
            name = "#";
        }
        return name;
    }

    public static void beginImp(String username) {
        ApiToEngineBridge.beginImp(username);
    }

    public static void endImp() {
        ApiToEngineBridge.endImp();
    }

    public static UniToken renewImp(UniToken oldToken) {
        return ApiToEngineBridge.renewImp(oldToken);
    }

    public static Subject getPeServiceSubject() {
        return ApiToEngineBridge.getPeServiceSubject();
    }

    public static Subject getKrb5Subject(String principalName, String ccacheFile) {
        return ApiToEngineBridge.getKrb5Subject(principalName, ccacheFile);
    }

    public static String getCeConnectionUrl(Id tenantId) {
        return ApiToEngineBridge.getCeConnectionUrl(tenantId);
    }

    public static boolean isAvailable() {
        return ApiToEngineBridge.isInCEServer();
    }

    public static byte[] getBits() {
        return ApiToEngineBridge.getBits();
    }

    public static boolean isUnifUsername(String username) {
        return ApiToEngineBridge.isUnifUsername(username);
    }

    public static byte[] mDec(byte[] data, Id tenantId) {
        return ApiToEngineBridge.mDec(data, tenantId);
    }

    public static byte[] mEnc(byte[] data, Id tenantId) {
        return ApiToEngineBridge.mEnc(data, tenantId);
    }

    public static UniToken newUniToken(String username) {
        return ApiToEngineBridge.newUniToken(username);
    }

    public static UniToken newUniToken(char[] rawToken) {
        return ApiToEngineBridge.newUniToken(rawToken);
    }

    public static UniBinary newUniBinary(String username) {
        return ApiToEngineBridge.newUniBinary(username);
    }

    public static UniBinary newUniBinary(char[] b64Token, byte[] key) {
        return ApiToEngineBridge.newUniBinary(b64Token, key);
    }

    public static UniBinary newUniBinary(char[] b64Token, UniBinaryKeyGen keygen, long clockSkew) {
        return ApiToEngineBridge.newUniBinary(b64Token, keygen, clockSkew);
    }

    public static HashSet<String> getSecurityTokenShortNames(String userName, Id tenantId) {
        return ApiToEngineBridge.getSecurityTokenShortNames(userName, tenantId);
    }

    public static List<Id> getTenantIds() {
        return ApiToEngineBridge.getTenantIds();
    }

    public static Id getTenantId(URI connectionUri) {
        return ApiToEngineBridge.getTenantId(connectionUri);
    }

    public static Id getTenantId(String tenantName) {
        return ApiToEngineBridge.getTenantId(tenantName);
    }

    public static String getMasterAdminGroupName(Id tenantId) {
        return ApiToEngineBridge.getMasterAdminGroupName(tenantId);
    }
}

