/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.authentication.Credentials;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;

public class UserContextImpl {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(UserContextImpl.class, SubSystem.API);
    private static boolean verboseLogging = ConfigValueLookup.getValueAsBoolean("com.filenet.verboseUserContextLogging", false);
    protected Locale loc;
    protected ArrayList<Credentials> creds = new ArrayList();
    private String creatorThreadIdentity;
    private UserContext ucOwner;
    private static ThreadLocal<UserContextImpl> tl = new ThreadLocal();

    public UserContextImpl(UserContext ucOwner) {
        this.ucOwner = ucOwner;
        this.creatorThreadIdentity = UserContextImpl.formatId(Thread.currentThread().getId());
        if (verboseLogging && logger.isDetailTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("UserContext <");
            msg.append(UserContextImpl.formatId(System.identityHashCode(this)));
            msg.append("> created in Thread <");
            msg.append(this.creatorThreadIdentity);
            msg.append("> AmbientPrincipal <");
            msg.append(UserContextImpl.getAmbientPrincipal());
            msg.append(">.");
            logger.traceDetail(msg.toString());
        }
    }

    public void setLocale(Locale locale) {
        this.loc = locale;
    }

    public Locale getLocale() {
        return this.loc == null ? Locale.getDefault() : this.loc;
    }

    public UserContext getOwner() {
        return this.ucOwner;
    }

    private String getCreatorThreadIdentity() {
        return this.creatorThreadIdentity;
    }

    public UserContextImpl cloneContext(UserContext ucOwner) {
        UserContextImpl uc = new UserContextImpl(ucOwner);
        if (logger.isDetailTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            String currentThreadIdentity = UserContextImpl.formatId(Thread.currentThread().getId());
            msg.append("UserContext cloning invoked in Thread <");
            msg.append(currentThreadIdentity);
            msg.append("> for UserContext <");
            msg.append(UserContextImpl.formatId(System.identityHashCode(uc)));
            msg.append(">.  UserContext will be cloned.");
            logger.traceDetail(msg.toString());
        }
        uc.loc = this.loc;
        uc.creds = (ArrayList)this.creds.clone();
        return uc;
    }

    public static UserContextImpl getImpl() {
        UserContextImpl cntx = tl.get();
        if (cntx == null) {
            UserContext uc = new UserContext();
            UserContext.set(uc);
            cntx = tl.get();
        }
        return cntx;
    }

    public boolean isThreadOwned() {
        String currentThreadIdentity = UserContextImpl.formatId(Thread.currentThread().getId());
        return this.creatorThreadIdentity.equals(currentThreadIdentity);
    }

    public static void set(UserContextImpl uci) {
        if (verboseLogging && logger.isDetailTraceEnabled()) {
            String currentThreadIdentity = UserContextImpl.formatId(Thread.currentThread().getId());
            if (uci == null) {
                StringBuilder msg = new StringBuilder();
                msg.append("UserContext.set() invoked in its creator Thread <");
                msg.append(currentThreadIdentity);
                msg.append("> for UserContext <null>>");
                logger.traceDetail(msg.toString());
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("UserContext.set() invoked in its creator Thread <");
                msg.append(currentThreadIdentity);
                msg.append("> AmbientPrincipal <");
                msg.append(UserContextImpl.getAmbientPrincipal());
                msg.append(">.");
                logger.traceDetail(msg.toString());
            }
        }
        tl.set(uci);
    }

    public synchronized void pushCredentials(Credentials cr) {
        this.creds.add(cr);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("UserContext.pushCredentials: " + cr.toString() + " issued by ambient principal " + UserContextImpl.getAmbientPrincipal());
        }
    }

    public synchronized Credentials popCredentials() {
        if (this.creds.isEmpty()) {
            return null;
        }
        Credentials cr = this.creds.remove(this.creds.size() - 1);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("UserContext.popCredentials: " + cr.toString() + " issued by ambient principal " + UserContextImpl.getAmbientPrincipal());
        }
        return cr;
    }

    public synchronized Credentials getTopCredentials() {
        if (this.creds.isEmpty()) {
            return null;
        }
        return this.creds.get(this.creds.size() - 1);
    }

    private static String getAmbientPrincipal() {
        String ambientPrincipalStr = null;
        try {
            Principal ambientPrincipal = J2EEUtil.getInstance().getCurrentPrincipal();
            if (ambientPrincipal != null) {
                ambientPrincipalStr = ambientPrincipal.getName();
            }
        }
        catch (Exception e) {
            ambientPrincipalStr = null;
        }
        return ambientPrincipalStr;
    }

    private static String formatId(long id) {
        return String.format("%08X", id);
    }
}

