/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CRCLHelper;
import com.filenet.apiimpl.util.classloader.CrossReleaseClassLoader;
import com.filenet.apiimpl.util.classloader.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class CRCLConfig {
    public static final boolean CRCL_CHATTY_LOGGING = ConfigValueLookup.getValueAsBoolean("com.filenet.api.crcl.logging.chatty", false);
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CRCLHelper.class, SubSystem.API);
    private static final String jarLocationGlobal = ConfigValueLookup.getValue("FileNet.crcl.implementation.api.location", null);
    private static final String jarLocationsGlobal = ConfigValueLookup.getValue("FileNet.crcl.implementation.api.locations", null);
    private static final String jarUrlsGlobal = ConfigValueLookup.getValue("FileNet.crcl.implementation.api.urls", null);
    private static final Map<String, Map<String, String>> urlsConfigToMapMap;
    private static final Map<String, Map<String, String>> locationsConfigToMapMap;
    private static Map<String, CrossReleaseClassLoader> filePathToCRCLMap;
    private static final ThreadLocal<CrossReleaseClassLoader> mostRecentCrclForThread;

    private CRCLConfig() {
    }

    public static boolean isSomebodyUsingCrcl(Connection conn, ClassLoader cl) {
        boolean result = CRCLConfig._isSomebodyUsingCrcl(conn, cl);
        if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: somebodyUsing? " + result + "; " + conn + "; " + cl);
        }
        return result;
    }

    private static boolean _isSomebodyUsingCrcl(Connection conn, ClassLoader cl) {
        if (cl instanceof CrossReleaseClassLoader) {
            return true;
        }
        if (jarLocationGlobal != null) {
            return true;
        }
        if (jarLocationsGlobal != null) {
            return true;
        }
        if (jarUrlsGlobal != null) {
            return true;
        }
        if (conn != null) {
            if (conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_LOCATION) != null) {
                return true;
            }
            if (conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_LOCATIONS) != null) {
                return true;
            }
            if (conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_URLS) != null) {
                return true;
            }
        }
        return false;
    }

    public static String locateTheJarFile(Connection conn) {
        String tagLocation;
        String connectionUrlKey;
        String urlTag;
        String jarLocation = null;
        String jarLocations = null;
        String jarUrls = null;
        if (conn == null) {
            return jarLocationGlobal;
        }
        Object oL = conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_LOCATION);
        if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: connection FileNet.crcl.implementation.api.location=" + oL);
        }
        if (oL != null) {
            jarLocation = oL.toString();
        } else {
            Object oUs = conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_URLS);
            Object oLs = conn.getParameter(ConfigurationParameter.CONNECTION_IMPLEMENTATION_API_LOCATIONS);
            if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: connection FileNet.crcl.implementation.api.locations=" + oLs);
                logger.traceDetail("CRCL: connection FileNet.crcl.implementation.api.urls=" + oUs);
            }
            if (oUs == null && oLs != null || oUs != null && oLs == null) {
                throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_PAIRWISE_CONFIG, (Object[])null);
            }
            if (oUs != null && oLs != null) {
                jarUrls = oUs.toString();
                jarLocations = oLs.toString();
            }
        }
        if (jarLocation == null && jarLocations == null && (jarLocation = jarLocationGlobal) == null) {
            jarLocations = jarLocationsGlobal;
            jarUrls = jarUrlsGlobal;
            if (jarUrls == null && jarLocations != null || jarUrls != null && jarLocations == null) {
                throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_PAIRWISE_CONFIG, (Object[])null);
            }
        }
        if (jarLocation == null && jarLocations == null) {
            return null;
        }
        if (jarLocation != null) {
            return jarLocation;
        }
        Map<String, String> urlMap = urlsConfigToMapMap.get(jarUrls);
        if (urlMap == null) {
            urlMap = Util.parseDelimTrimToMap(jarUrls);
            urlsConfigToMapMap.put(jarUrls, urlMap);
        }
        if ((urlTag = urlMap.get(connectionUrlKey = Util.urlWithoutQueryPart(conn.getURI()))) == null || urlTag.length() == 0) {
            return null;
        }
        Map<String, String> locationsMap = locationsConfigToMapMap.get(jarLocations);
        if (locationsMap == null) {
            locationsMap = Util.parseDelimTrimToMap(jarLocations);
            locationsConfigToMapMap.put(jarLocations, locationsMap);
        }
        if ((tagLocation = locationsMap.get(urlTag)) == null || tagLocation.length() == 0) {
            return null;
        }
        return tagLocation;
    }

    static CrossReleaseClassLoader locateTheClassLoader(String jarFilePath) {
        URL jarFileURL;
        CrossReleaseClassLoader thisClassLoader = filePathToCRCLMap.get(jarFilePath);
        if (thisClassLoader != null) {
            if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: for JAR " + jarFilePath + ", reusing classloader " + thisClassLoader);
            }
            CRCLConfig.setMostRecentCrclForThread(thisClassLoader);
            return thisClassLoader;
        }
        File jarFile = new File(jarFilePath);
        if (!jarFile.exists()) {
            throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_MISSING_JAR, new Object[]{jarFilePath});
        }
        if (!jarFile.canRead()) {
            throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_UNREADABLE_JAR, new Object[]{jarFilePath});
        }
        if (jarFile.isDirectory()) {
            throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_JAR_IS_DIECTORY, new Object[]{jarFilePath});
        }
        try {
            jarFileURL = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_CRCL_CONFIG, (Object[])null);
        }
        thisClassLoader = new CrossReleaseClassLoader(jarFileURL);
        filePathToCRCLMap.put(jarFilePath, thisClassLoader);
        CRCLConfig.setMostRecentCrclForThread(thisClassLoader);
        return thisClassLoader;
    }

    static CrossReleaseClassLoader getMostRecentCrclForThread() {
        CrossReleaseClassLoader thisClassLoader = mostRecentCrclForThread.get();
        if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: get MRCFT classloader " + thisClassLoader);
        }
        return thisClassLoader;
    }

    static void setMostRecentCrclForThread(CrossReleaseClassLoader thisClassLoader) {
        if (CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: set MRCFT classloader " + thisClassLoader);
        }
        mostRecentCrclForThread.set(thisClassLoader);
    }

    static {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: global FileNet.crcl.implementation.api.location=" + jarLocationGlobal);
            logger.traceDetail("CRCL: global FileNet.crcl.implementation.api.locations=" + jarLocationsGlobal);
            logger.traceDetail("CRCL: global FileNet.crcl.implementation.api.urls=" + jarUrlsGlobal);
        }
        if (jarUrlsGlobal == null && jarLocationsGlobal != null || jarUrlsGlobal != null && jarLocationsGlobal == null) {
            throw new EngineRuntimeException(ExceptionCode.API_CRCL_CONFIG, (Object[])null, ExceptionContext.API_CRCL_PAIRWISE_CONFIG, (Object[])null);
        }
        urlsConfigToMapMap = Collections.synchronizedMap(new TreeMap());
        locationsConfigToMapMap = Collections.synchronizedMap(new TreeMap());
        filePathToCRCLMap = Collections.synchronizedMap(new HashMap());
        mostRecentCrclForThread = new ThreadLocal();
    }
}

