/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.collection.EngineCollection;
import com.filenet.api.collection.EngineSet;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.meta.Cache;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CRCLConfig;
import com.filenet.apiimpl.util.classloader.CrossReleaseClassLoader;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.UsernameToken;
import com.filenet.apiimpl.wsi.WSICredential;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

public class CRCLHelper {
    public static final String CRCL_NOT_USED = "CRCL not used";
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CRCLHelper.class, SubSystem.API);
    private static final ClassLoader VISIBLE_API_CLASSLOADER = Connection.class.getClassLoader();
    private static final String WSI_CRED_CLASS_NAME = WSICredential.class.getName();
    private static final Class[] types_ss = new Class[]{String.class, String.class};
    private static final String[] WSI_CRED_SIG = new String[]{"new WSICredential(String{String}, String{String})"};
    private static final String PIES_CLASS_NAME = PropertiesImpl.class.getName();
    private static final ThreadLocal<Boolean> isAlreadyCRCL = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private CRCLHelper() {
    }

    static ClassLoader getVisibleApiClassloader() {
        return VISIBLE_API_CLASSLOADER;
    }

    public static Object doCRCLcall(String targetClassName, String targetMethodName, Class[] types, Object ... args) {
        return CRCLHelper.doCRCLcall(null, targetClassName, targetMethodName, types, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doCRCLcall(Object target, String targetClassName, String targetMethodName, Class[] types, Object ... args) {
        if (isAlreadyCRCL.get().booleanValue()) {
            return CRCL_NOT_USED;
        }
        try {
            isAlreadyCRCL.set(true);
            Object object = CRCLHelper._doCRCLcall(target, targetClassName, targetMethodName, types, args);
            return object;
        }
        finally {
            isAlreadyCRCL.set(false);
        }
    }

    private static Object _doCRCLcall(Object target, String targetClassName, String targetMethodName, Class[] types, Object ... args) {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            String methodSig = CRCLHelper.recreateMethodSignature(targetClassName, targetMethodName, types, args);
            logger.traceDetail("CRCL: calling " + methodSig + " for target object " + target);
        }
        ClassLoader thisClassLoader = null;
        Connection conn = null;
        if (target != null) {
            thisClassLoader = target.getClass().getClassLoader();
        } else {
            conn = CRCLHelper.locateTheConnection(args);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: connection " + conn);
            }
            String jarFile = CRCLConfig.locateTheJarFile(conn);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: API JAR " + jarFile);
            }
            if (jarFile != null) {
                thisClassLoader = CRCLConfig.locateTheClassLoader(jarFile);
            } else if (conn == null) {
                thisClassLoader = CRCLConfig.getMostRecentCrclForThread();
            }
        }
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: classloader " + thisClassLoader);
        }
        if (!(thisClassLoader instanceof CrossReleaseClassLoader)) {
            CRCLHelper.tcclPop(conn, thisClassLoader);
            CRCLConfig.setMostRecentCrclForThread(null);
            return CRCL_NOT_USED;
        }
        CRCLHelper.tcclPush(conn, (CrossReleaseClassLoader)thisClassLoader);
        return CRCLHelper.performReflectiveCall(thisClassLoader, target, targetClassName, targetMethodName, types, args);
    }

    public static Object getAppropriateConstant(String className, String fieldName) {
        Field thisField;
        Class<?> thisClass;
        ClassLoader thisClassLoader = CRCLConfig.getMostRecentCrclForThread();
        if (thisClassLoader == null) {
            thisClassLoader = VISIBLE_API_CLASSLOADER;
        }
        try {
            thisClass = thisClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        try {
            thisField = thisClass.getField(fieldName);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        try {
            Object value = thisField.get(null);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: constant " + className + "." + fieldName + "=" + value + " via " + thisClassLoader);
            }
            return value;
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public static MetadataCache findCRCLdefaultCMC(Connection conn) {
        if (isAlreadyCRCL.get().booleanValue()) {
            return null;
        }
        try {
            isAlreadyCRCL.set(true);
            MetadataCache metadataCache = CRCLHelper._findCRCLdefaultCMC(conn);
            return metadataCache;
        }
        finally {
            isAlreadyCRCL.set(false);
        }
    }

    private static MetadataCache _findCRCLdefaultCMC(Connection conn) {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:cmc connection " + conn);
        }
        String jarFile = CRCLConfig.locateTheJarFile(conn);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:cmc API JAR " + jarFile);
        }
        if (jarFile == null) {
            return null;
        }
        CrossReleaseClassLoader thisClassLoader = CRCLConfig.locateTheClassLoader(jarFile);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:cmc classloader " + thisClassLoader);
        }
        if (!(thisClassLoader instanceof CrossReleaseClassLoader)) {
            CRCLHelper.tcclPop(conn, thisClassLoader);
            CRCLConfig.setMostRecentCrclForThread(null);
            return null;
        }
        CRCLHelper.tcclPush(conn, thisClassLoader);
        try {
            Class<?> implementationCmcClass = ((ClassLoader)thisClassLoader).loadClass(Cache.class.getName());
            Field defaultField = implementationCmcClass.getField("DEFAULT");
            Object defaultFieldValue = defaultField.get(null);
            return (MetadataCache)defaultFieldValue;
        }
        catch (Throwable e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{"Cache.DEFAULT"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object constructCRCLdelegateObject(String name, Class[] delegateConstructorTypes, Object ... args) {
        if (isAlreadyCRCL.get().booleanValue()) {
            return null;
        }
        try {
            isAlreadyCRCL.set(true);
            Object object = CRCLHelper._constructCRCLdelegateObject(name, delegateConstructorTypes, args);
            return object;
        }
        finally {
            isAlreadyCRCL.set(false);
        }
    }

    private static Object _constructCRCLdelegateObject(String name, Class[] delegateConstructorTypes, Object ... args) {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            String methodSig = CRCLHelper.recreateConstructorSignature(name, delegateConstructorTypes, args);
            logger.traceDetail("CRCL: calling " + methodSig);
        }
        Connection conn = CRCLHelper.locateTheConnection(args);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:dlgt connection " + conn);
        }
        CrossReleaseClassLoader thisClassLoader = null;
        if (conn == null) {
            thisClassLoader = CRCLConfig.getMostRecentCrclForThread();
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:dlgt no Connection, pulling MRCFT " + thisClassLoader);
            }
        } else {
            String jarFile = CRCLConfig.locateTheJarFile(conn);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:dlgt API JAR " + jarFile);
            }
            if (jarFile != null) {
                thisClassLoader = CRCLConfig.locateTheClassLoader(jarFile);
            }
        }
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:dlgt classloader " + thisClassLoader);
        }
        if (thisClassLoader == null) {
            return null;
        }
        CRCLHelper.tcclPush(conn, thisClassLoader);
        return CRCLHelper.performReflectiveNew(thisClassLoader, name, delegateConstructorTypes, args);
    }

    private static void tcclPop(Connection conn, ClassLoader cl) {
        if (!CRCLConfig.isSomebodyUsingCrcl(conn, cl)) {
            return;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        tccl = CRCLHelper.findNonCRCLParent(tccl);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:tccl popto   " + tccl);
        }
        Thread.currentThread().setContextClassLoader(tccl);
    }

    private static void tcclPush(Connection conn, CrossReleaseClassLoader thisClassLoader) {
        if (!CRCLConfig.isSomebodyUsingCrcl(conn, thisClassLoader)) {
            return;
        }
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:tccl touse   " + thisClassLoader);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        tccl = CRCLHelper.findNonCRCLParent(tccl);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:tccl parent  " + tccl);
        }
        ClassLoader newTCCL = thisClassLoader == null ? tccl : CrossReleaseClassLoader.getTCCLishCRCL(thisClassLoader, tccl);
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:tccl setting " + newTCCL);
        }
        Thread.currentThread().setContextClassLoader(newTCCL);
    }

    private static ClassLoader findNonCRCLParent(ClassLoader tccl) {
        while (tccl instanceof CrossReleaseClassLoader.TCCLishCRCL) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:tccl unwrap  " + tccl);
            }
            tccl = ((CrossReleaseClassLoader.TCCLishCRCL)tccl).getTCCLparent();
        }
        return tccl;
    }

    private static Object performReflectiveNew(ClassLoader thisClassLoader, String className, Class[] types, Object ... args) {
        try {
            Class<?> theClass = thisClassLoader.loadClass(className);
            Constructor<?> constructor = theClass.getConstructor(types);
            if (constructor == null) {
                String methodSig = CRCLHelper.recreateConstructorSignature(className, types, args);
                throw new EngineRuntimeException(null, ExceptionCode.API_CRCL_REFLECTION_NOSUCH, (Object[])new String[]{methodSig});
            }
            Object instance = constructor.newInstance(args);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: instance " + instance);
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (SecurityException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (NoSuchMethodException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (IllegalArgumentException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (InstantiationException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (IllegalAccessException e) {
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)cause;
            }
            throw CRCLHelper.reflectFailConstructor(e, className, types, args);
        }
    }

    private static Object performReflectiveCall(ClassLoader thisClassLoader, Object target, String thisClassName, String thisMethodName, Class[] types, Object ... args) {
        try {
            Class<?> theClass = thisClassLoader.loadClass(thisClassName);
            Method theMethod = theClass.getMethod(thisMethodName, types);
            if (theMethod == null) {
                String methodSig = CRCLHelper.recreateMethodSignature(thisClassName, thisMethodName, types, args);
                throw new EngineRuntimeException(null, ExceptionCode.API_CRCL_REFLECTION_NOSUCH, (Object[])new String[]{methodSig});
            }
            Object theResult = theMethod.invoke(target, args);
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: result " + theResult);
            }
            return theResult;
        }
        catch (ClassNotFoundException e) {
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
        catch (SecurityException e) {
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
        catch (NoSuchMethodException e) {
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
        catch (IllegalArgumentException e) {
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
        catch (IllegalAccessException e) {
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)cause;
            }
            throw CRCLHelper.reflectFailMethod(e, thisClassName, thisMethodName, types, args);
        }
    }

    public static void finesseWsiCredential(Connection connectionImpl) {
        Class<?> implementationWsiClass;
        Set<WSICredential> visibleWsiCreds;
        String jarFile;
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: finesse WSICredential");
        }
        if ((jarFile = CRCLConfig.locateTheJarFile(connectionImpl)) == null) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: no JAR");
            }
            return;
        }
        CrossReleaseClassLoader implementationWsiClassLoader = CRCLConfig.locateTheClassLoader(jarFile);
        if (implementationWsiClassLoader == null || !(implementationWsiClassLoader instanceof CrossReleaseClassLoader)) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: CRCL not involved, CL=" + implementationWsiClassLoader);
            }
            return;
        }
        boolean subjectFromUserContext = false;
        Subject subject = UserContext.get().getSubject();
        if (subject == null) {
            subject = UserContext.getAmbientSubject();
        } else {
            subjectFromUserContext = true;
        }
        if (subject == null) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: no Subject");
            }
            return;
        }
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            String flag = subjectFromUserContext ? "u" : "a";
            logger.traceDetail("CRCL: finesse WSICredential for[" + flag + "] " + subject);
        }
        if ((visibleWsiCreds = subject.getPrivateCredentials(WSICredential.class)) == null || visibleWsiCreds.size() == 0) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: no visible WSICredential");
            }
            return;
        }
        WSICredential visibleWsiCred = visibleWsiCreds.iterator().next();
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: finesse WSICredential: visible WSICredential=" + visibleWsiCred);
        }
        try {
            implementationWsiClass = ((ClassLoader)implementationWsiClassLoader).loadClass(WSI_CRED_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.error("CRCL: Is the JAR file " + jarFile + " corrupt, unreadable, etc?", e);
            throw new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{"ClassLoader.loadClass(\"WSICredential\")"});
        }
        Set<?> implementationWsiCredentials = subject.getPrivateCredentials(implementationWsiClass);
        if (implementationWsiCredentials != null && implementationWsiCredentials.size() > 0) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: implementation! WSICredential=" + implementationWsiCredentials.iterator().next());
            }
            return;
        }
        Object implementationWsiCred = CRCLHelper.cloneCrclWsiCred(implementationWsiClass, visibleWsiCred);
        if (implementationWsiCred == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: implementation WSICredential could not be cloned");
            }
            return;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: finesse WSICredential: implementation* WSICredential=" + implementationWsiCred);
        }
        Set<Object> allPrivateCreds = subject.getPrivateCredentials();
        allPrivateCreds.add(implementationWsiCred);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: finesse WSICredential into " + subject);
        }
    }

    private static Object cloneCrclWsiCred(Class implementationWsiClass, WSICredential visibleWsiCred) {
        Security security = visibleWsiCred.getSecurityToken();
        UsernameToken utoken = security.UsernameToken;
        if (utoken == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: finesse WSICredential: visible WSICredential not a U/P case; " + security);
            }
            return null;
        }
        String u = utoken.Username;
        String p = utoken.Password;
        try {
            Constructor implementationWsiConstructor = implementationWsiClass.getConstructor(types_ss);
            Object implementationWsiInstance = implementationWsiConstructor.newInstance(u, p);
            return implementationWsiInstance;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])WSI_CRED_SIG);
        }
    }

    private static Connection locateTheConnection(Object[] args) {
        if (args != null) {
            for (int ii = 0; ii < args.length; ++ii) {
                Object arg = args[ii];
                Connection conn = CRCLHelper.locateTheConnection(ii, arg);
                if (conn == null) continue;
                return conn;
            }
        }
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL:conn no arg/item is an EngineObject or a Connection object");
        }
        return null;
    }

    private static Connection locateTheConnection(int ii, Object arg) {
        if (arg instanceof Connection) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is a Connection object: " + arg);
            }
            Connection conn = (Connection)arg;
            return conn;
        }
        if (arg instanceof EngineObject) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is an EngineObject: " + arg);
            }
            EngineObject eo = (EngineObject)arg;
            Connection conn = eo.getConnection();
            return conn;
        }
        if (arg instanceof Object[]) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is an ARRAY, looking inside ... " + arg);
            }
            Object[] items = (Object[])arg;
            Connection conn = CRCLHelper.locateTheConnection(items);
            return conn;
        }
        if (arg instanceof Collection) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is a COLLECTION, looking inside ... " + arg);
            }
            Object[] items = ((Collection)arg).toArray();
            Connection conn = CRCLHelper.locateTheConnection(items);
            return conn;
        }
        if (arg instanceof EngineSet) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is an EngineSet, looking inside current page ... " + arg);
            }
            EngineSet set = (EngineSet)arg;
            PageIterator pit = set.pageIterator();
            Object[] items = pit.getCurrentPage();
            Connection conn = CRCLHelper.locateTheConnection(items);
            return conn;
        }
        if (arg instanceof EngineCollection) {
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL:conn arg/item " + ii + " is an EngineCollection, looking inside ... " + arg);
            }
            int item = 0;
            Iterator it = ((EngineCollection)arg).iterator();
            while (it.hasNext()) {
                Connection conn;
                Object ecItem = it.next();
                if ((conn = CRCLHelper.locateTheConnection(item++, ecItem)) == null) continue;
                return conn;
            }
            return null;
        }
        return null;
    }

    private static EngineRuntimeException reflectFailConstructor(Throwable e, String className, Class[] types, Object ... args) {
        String methodSig = CRCLHelper.recreateConstructorSignature(className, types, args);
        return new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{methodSig});
    }

    private static EngineRuntimeException reflectFailMethod(Throwable e, String className, String methodName, Class[] types, Object ... args) {
        String methodSig = CRCLHelper.recreateMethodSignature(className, methodName, types, args);
        return new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{methodSig});
    }

    private static String recreateConstructorSignature(String className, Class[] types, Object[] args) {
        StringBuffer methodSig = new StringBuffer();
        methodSig.append("new ").append(className).append('(');
        CRCLHelper.typesAndArgs(methodSig, types, args);
        return methodSig.toString();
    }

    private static String recreateMethodSignature(String className, String methodName, Class[] types, Object ... args) {
        StringBuffer methodSig = new StringBuffer();
        methodSig.append(className).append('.').append(methodName).append('(');
        CRCLHelper.typesAndArgs(methodSig, types, args);
        return methodSig.toString();
    }

    private static void typesAndArgs(StringBuffer methodSig, Class[] types, Object ... args) {
        if (types != null && args != null) {
            for (int ii = 0; ii < args.length; ++ii) {
                Object object = args[ii];
                String argClassName = object == null ? "null" : object.getClass().getSimpleName();
                String typeClassName = types[ii].getSimpleName();
                if (typeClassName.equals(argClassName)) {
                    methodSig.append(argClassName);
                } else {
                    methodSig.append(typeClassName).append("{").append(argClassName).append("}");
                }
                if (ii == args.length - 1) continue;
                methodSig.append(", ");
            }
        }
        methodSig.append(")");
    }

    public static final Properties copyDirtyPropertiesConsideringCrcl(Properties sourcePies) {
        ClassLoader incomingCL = sourcePies.getClass().getClassLoader();
        Properties targetPies = incomingCL == VISIBLE_API_CLASSLOADER ? CRCLHelper.shallowCopyPropertiesDirect(sourcePies) : CRCLHelper.shallowCopyPropertiesReflective(sourcePies, incomingCL);
        return targetPies;
    }

    private static final Properties shallowCopyPropertiesDirect(Properties sourcePies) {
        PropertiesImpl targetPies = new PropertiesImpl();
        Iterator it = sourcePies.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.isDirty()) continue;
            targetPies.put(prop);
        }
        return targetPies;
    }

    private static final Properties shallowCopyPropertiesReflective(Properties sourcePies, ClassLoader incomingCL) {
        Method putMethod;
        Properties targetPies;
        try {
            Class<?> piesClass = incomingCL.loadClass(PIES_CLASS_NAME);
            targetPies = (Properties)piesClass.newInstance();
            putMethod = piesClass.getMethod("put", Property.class);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{CRCLHelper.class.getName() + ".shallowCopyPropertiesReflective(1)"});
        }
        Iterator it = sourcePies.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.isDirty()) continue;
            try {
                putMethod.invoke((Object)targetPies, prop);
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.API_CRCL_REFLECTION_FAIL, (Object[])new String[]{CRCLHelper.class.getName() + ".shallowCopyPropertiesReflective(2)"});
            }
        }
        return targetPies;
    }
}

