/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.ApiToEngineBridge;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.CacheEntry;
import com.filenet.apiimpl.util.ConcurrentCache;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CMCLCacheEntry;
import com.filenet.apiimpl.util.classloader.CodeModuleToCItem;
import com.filenet.apiimpl.util.classloader.ContentElementURLutil;
import com.filenet.apiimpl.util.classloader.DummyClassLoader;
import com.filenet.apiimpl.util.classloader.DummyEnumeration;
import com.filenet.apiimpl.util.classloader.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class CodeModuleClassLoader
extends ClassLoader {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CodeModuleClassLoader.class, SubSystem.CodeModule);
    private static final ClassLoader apiClassLoader = CodeModuleClassLoader.class.getClassLoader();
    private static final ClassLoader engineClassLoader = ApiToEngineBridge.getEngineClassLoader();
    private static final ClassLoader bootstrapClassLoader = String.class.getClassLoader();
    private ClassLoader parentClassLoader;
    private static final int MAX_CACHE_ENTRIES;
    private static final int MAX_CLASS_SIZE;
    private static final int DEFAULT_CACHE_EXPIRY_SECONDS = 86400;
    private static final String GCD_CACHE_CONFIG_ITEM_TTL = "CodeModuleCacheEntryTTL";
    private static final String GCD_CACHE_CONFIG_CLASS_NAME = "ServerCacheConfiguration";
    private static final ConcurrentCache clInstances;
    private static long lastTwiddle;
    private static final long TIME_TWEEN_TWIDDLES = 50000L;
    private int instantiationCount = 0;
    private int classesLoaded = 0;
    private List<CodeModuleToCItem> cmTOC = null;
    private int defineClassDepth = 0;
    private final Id osId;
    private final Id cmId;
    private final boolean doParentFirstForClasses;
    private final boolean doParentFirstForResources;
    private final Connection connection;
    private final URLClassLoader jbojClassLoader;
    private final Set<String> augmentedWhiteListClassnames;
    private String cacheKey;
    private String toString = null;
    private static final String simpleName;
    private static ThreadLocal<Set<String>> ourStoryTL;
    private static Integer ZERO;
    private ThreadLocal<Integer> classOrResourceDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return ZERO;
        }
    };
    private static final String depthPrefix = "++++++++++++++++++++++*";
    private static final Set<String> nonDelegatedPackages;
    private static final Set<String> yesDelegatedPackages;
    private static final boolean ndpHasBang;
    private String nonCodeModuleClassName = null;
    private String bangPackageName = null;

    private static ClassLoader getParentClassloader(ClassLoader parentClassLoader) {
        if (parentClassLoader != null) {
            return parentClassLoader;
        }
        if (engineClassLoader != null) {
            return engineClassLoader;
        }
        return apiClassLoader;
    }

    private static final void twiddleCache(boolean payAttentionToTime) {
        int newTTL;
        if (clInstances == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (payAttentionToTime && now - lastTwiddle < 50000L) {
            return;
        }
        lastTwiddle = now;
        int currentTTL = clInstances.getTTL();
        if (currentTTL != (newTTL = ApiToEngineBridge.getGCDValue(GCD_CACHE_CONFIG_CLASS_NAME, GCD_CACHE_CONFIG_ITEM_TTL, currentTTL, null))) {
            clInstances.setTTL(newTTL);
            logger.traceDetail("CMCL CACHE ttl " + newTTL + " seconds, was " + currentTTL);
        }
    }

    private CodeModuleClassLoader(String cacheKey, Id osId, Id cmId, String className, Collection<URL> jboj, Collection<String> augmentedWhiteList, boolean doParentFirstForClasses, boolean doParentFirstForResources, Connection connection, ClassLoader parentClassLoader) {
        super(CodeModuleClassLoader.getParentClassloader(parentClassLoader));
        this.cacheKey = cacheKey;
        this.parentClassLoader = CodeModuleClassLoader.getParentClassloader(parentClassLoader);
        this.osId = osId;
        this.cmId = cmId;
        this.nonCodeModuleClassName = className;
        if (this.nonCodeModuleClassName != null) {
            this.bangPackageName = Util.getPackageName(this.nonCodeModuleClassName);
        }
        if (jboj != null && jboj.size() > 0) {
            this.checkCanReadJboj(jboj);
            URL[] jbojA = jboj.toArray(EMPTY_URL_ARRAY);
            this.jbojClassLoader = URLClassLoader.newInstance(jbojA, DummyClassLoader.INSTANCE);
        } else {
            this.jbojClassLoader = null;
        }
        if (augmentedWhiteList != null && augmentedWhiteList.size() > 0) {
            this.augmentedWhiteListClassnames = new HashSet<String>();
            this.augmentedWhiteListClassnames.addAll(augmentedWhiteList);
        } else {
            this.augmentedWhiteListClassnames = null;
        }
        this.doParentFirstForClasses = doParentFirstForClasses;
        this.doParentFirstForResources = doParentFirstForResources;
        this.connection = connection;
        if (this.hasCodeModule()) {
            this.cmTOC = CodeModuleToCItem.populateTOC(osId, cmId, connection);
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL constructed 0x" + Integer.toHexString(System.identityHashCode(this)) + " " + this);
        }
    }

    private void checkCanReadJboj(Collection<URL> jboj) {
        for (URL u : jboj) {
            try {
                InputStream is = u.openStream();
                is.close();
            }
            catch (IOException e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, (Object[])null);
            }
        }
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = simpleName + ":" + this.cacheKey;
        }
        return this.toString;
    }

    public static final ClassLoader getInstance(Id osId, Id cmId, boolean doParentFirstForClasses, boolean doParentFirstForResources, Connection conn, ClassLoader parentClassLoader) {
        return CodeModuleClassLoader.getInstance(osId, cmId, conn, null, null, null, doParentFirstForClasses, doParentFirstForResources, parentClassLoader);
    }

    public static final ClassLoader getInstance(String className, boolean doParentFirstForClasses, boolean doParentFirstForResources, ClassLoader parentClassLoader) {
        ClassLoader cmcl = CodeModuleClassLoader.getInstance(null, null, null, className, null, null, doParentFirstForClasses, doParentFirstForResources, CodeModuleClassLoader.getParentClassloader(parentClassLoader));
        return cmcl;
    }

    public static final ClassLoader getInstance(Collection<URL> jboj, Collection<String> augmentedWhiteList, boolean doParentFirstForClasses, boolean doParentFirstForResources, ClassLoader parentClassLoader) {
        ClassLoader cmcl = CodeModuleClassLoader.getInstance(null, null, null, null, jboj, augmentedWhiteList, doParentFirstForClasses, doParentFirstForResources, CodeModuleClassLoader.getParentClassloader(parentClassLoader));
        return cmcl;
    }

    public static final ClassLoader getInstance(Id osId, Id cmId, Connection connection, boolean doParentFirstForClasses, boolean doParentFirstForResources, ClassLoader parentClassLoader) {
        return CodeModuleClassLoader.getInstance(osId, cmId, connection, null, null, null, doParentFirstForClasses, doParentFirstForResources, parentClassLoader);
    }

    private static final ClassLoader getInstance(Id osId, Id cmId, Connection connection, String className, Collection<URL> jboj, Collection<String> augmentedWhiteList, boolean doParentFirstForClasses, boolean doParentFirstForResources, ClassLoader parentClassLoader) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL classloader for osId=" + osId + ", cmId=" + cmId + ", className=" + className + ", jboj=0x" + Integer.toHexString(System.identityHashCode(jboj)) + ", awl=0x" + Integer.toHexString(System.identityHashCode(augmentedWhiteList)) + ", PFc=" + doParentFirstForClasses + ", PFr=" + doParentFirstForResources + ", " + connection + ", parent=0x" + Integer.toHexString(System.identityHashCode(parentClassLoader)) + " " + parentClassLoader);
        }
        String key = CMCLCacheEntry.makeKey(osId, cmId, className, jboj, augmentedWhiteList, doParentFirstForClasses, doParentFirstForResources, CodeModuleClassLoader.getParentClassloader(parentClassLoader));
        CacheEntry entry = null;
        if (clInstances != null) {
            entry = clInstances.find(key);
        }
        CodeModuleClassLoader cmcl = null;
        if (entry == null) {
            CodeModuleClassLoader.twiddleCache(false);
            cmcl = new CodeModuleClassLoader(key, osId, cmId, className, jboj, augmentedWhiteList, doParentFirstForClasses, doParentFirstForResources, connection, parentClassLoader);
            if (logger.isDetailTraceEnabled()) {
                if (jboj != null) {
                    for (URL url : jboj) {
                        logger.traceDetail("CMCL jboj url=" + url);
                    }
                }
                if (augmentedWhiteList != null) {
                    for (String awlItem : augmentedWhiteList) {
                        logger.traceDetail("CMCL awl item=" + awlItem);
                    }
                }
            }
            if (clInstances != null) {
                entry = new CMCLCacheEntry(cmcl, key);
                clInstances.add(entry);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CMCL cache size is now " + clInstances.size() + " of " + clInstances.getMaxEntries());
                }
            }
        } else {
            CodeModuleClassLoader.twiddleCache(true);
            cmcl = (CodeModuleClassLoader)entry.getValue();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("cached CMCL found; reusing " + cmcl + " IC=" + ++cmcl.instantiationCount);
                logger.traceDetail("CMCL cache size is now " + clInstances.size() + " of " + clInstances.getMaxEntries());
            }
        }
        return cmcl;
    }

    private final boolean hasCodeModule() {
        return this.cmId != null;
    }

    private Class<?> loadClassFromSomewhere(String name) throws ClassNotFoundException {
        boolean isOnAWL;
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL avoiding java/javax class " + name);
            }
            throw new ClassNotFoundException(name);
        }
        boolean bl = isOnAWL = this.augmentedWhiteListClassnames != null && this.augmentedWhiteListClassnames.contains(name);
        if (isOnAWL && logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL AWL contains " + name);
        }
        if (CodeModuleClassLoader.isYesDelegatedPackageClass(name) && !isOnAWL) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL avoiding yes-delegated package class " + name);
            }
            throw new ClassNotFoundException(name);
        }
        if (this.hasCodeModule()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL searching in CodeModule for class " + name);
            }
            return this.loadClassFromCodeModule(name);
        }
        if (this.jbojClassLoader != null) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL searching in JBOJ for class " + name);
            }
            try {
                return this.loadClassFromClassLoaderResource(this.jbojClassLoader, name);
            }
            catch (ClassNotFoundException e) {
                if (logger.isDetailTraceEnabled()) {
                    this.logger_traceDetail("CMCL JBOJ search failed, searching via parents " + name);
                }
                return this.loadClassFromClassLoaderResource(this.parentClassLoader, name);
            }
        }
        if (this.isNonDelegatedPackageClass(name)) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL searching non-delegated package class " + name);
            }
            return this.loadClassFromClassLoaderResource(this.parentClassLoader, name);
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL avoiding default-delegated package class " + name);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadClassFromCodeModule(String name) throws ClassNotFoundException {
        if (!this.hasCodeModule()) {
            throw new ClassNotFoundException(name);
        }
        Class<?> rawClass = null;
        for (CodeModuleToCItem tocItem : this.cmTOC) {
            if (!(tocItem.isClassElement() ? (rawClass = this.getRawClassFromClassElement(tocItem, name)) != null : tocItem.isJarZipElement() && (rawClass = this.getRawClassFromJarZipElement(tocItem, name)) != null)) continue;
            return rawClass;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadClassFromClassLoaderResource(ClassLoader cl, String name) throws ClassNotFoundException {
        byte[] classBytes;
        InputStream is;
        String resourceName = CodeModuleClassLoader.classNameToResourcePath(name);
        URL url = cl.getResource(resourceName);
        if (url == null) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL did not find class as resource: " + name);
            }
            throw new ClassNotFoundException(name);
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL found class as resource: " + name + " is " + url);
        }
        boolean foundBootstrapClass = false;
        ClassLoader candidateClassLoader = null;
        try {
            Class<?> candidate = super.findSystemClass(name);
            if (candidate != null && (candidateClassLoader = candidate.getClassLoader()) == bootstrapClassLoader) {
                foundBootstrapClass = true;
            }
        }
        catch (Throwable candidate) {
            // empty catch block
        }
        if (foundBootstrapClass) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL found class as resource, skipping: IS a bootstrap class: " + name);
            }
            throw new ClassNotFoundException();
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL found class as resource, NOT a bootstrap class: " + name + ", CL 0x" + System.identityHashCode(candidateClassLoader));
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            logger.error("Trying to open for " + url + " as a resource stream, got exception: " + e.getMessage());
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        try {
            classBytes = this.obtainInputStreamBytes(is);
            is.close();
        }
        catch (IOException e) {
            logger.error("Trying to read class bytes from " + url + " as a resource stream, got exception: " + e.getMessage());
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        Class<?> rawDefinedClass = this.definePackageThenClass("resource", name, classBytes);
        return rawDefinedClass;
    }

    private Class<?> definePackageThenClass(String loggingTag, String name, byte[] classBytes) throws ClassFormatError {
        String packageName;
        int lastDotAt = name.lastIndexOf(".");
        Package pkg = null;
        if (lastDotAt > 0 && (pkg = this.getPackage(packageName = name.substring(0, lastDotAt))) == null) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL defining package named " + packageName);
            }
            pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL [" + loggingTag + "] defining class: " + name);
        }
        Class<?> rawDefinedClass = this.defineClass(name, classBytes, 0, classBytes.length);
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL [" + loggingTag + "] defined  class: " + name + "; Package " + pkg);
        }
        return rawDefinedClass;
    }

    private byte[] obtainInputStreamBytes(InputStream is) throws IOException {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
        byte[] buf = new byte[1000];
        while ((n = is.read(buf)) > 0) {
            baos.write(buf, 0, n);
        }
        return baos.toByteArray();
    }

    private Class<?> getRawClassFromClassElement(CodeModuleToCItem tocItem, String name) {
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL search for " + name + " in content element " + tocItem);
        }
        if (tocItem.isClassAlreadyLoadedInJVM()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL class for this content element has already been loaded; skipping " + tocItem);
            }
            return null;
        }
        if (tocItem.isFunky()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL this content element is already marked funky; skipping " + tocItem);
            }
            return null;
        }
        if (tocItem.isClassBeingDefined()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL class for this content element is actively being defined; skipping " + tocItem);
            }
            return null;
        }
        byte[] classBytes = this.obtainElementBytes(tocItem, name);
        if (classBytes == null) {
            return null;
        }
        try {
            tocItem.setClassIsBeingDefined(true);
            ++this.defineClassDepth;
            Class<?> rawDefinedClass = this.definePackageThenClass("ToCitem", name, classBytes);
            tocItem.setRawBytes(null);
            tocItem.setClassAlreadyLoadedInJVM(true);
            Class<?> clazz = rawDefinedClass;
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL A class other than " + name + " was found in " + tocItem + " (not unusual)");
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (ClassCircularityError e) {
            if (this.defineClassDepth > 1) {
                String cfeWarning = "Ignoring unusual but legal class circularity (depth " + this.defineClassDepth + ") " + tocItem + ": " + e;
                logger.traceDetail(cfeWarning);
                logger.warn(cfeWarning);
                Class<?> clazz = null;
                return clazz;
            }
            Object[] args = new Object[]{name, tocItem.getElementNumber() + ""};
            tocItem.setRawBytes(null);
            tocItem.setIsFunky(true);
            throw new EngineRuntimeException(e, ExceptionCode.EVENT_CM_CIRCULARITY, args);
        }
        catch (ClassFormatError e) {
            String cfeWarning = "content element content is not a valid Java class file " + tocItem + ": " + e;
            logger.traceDetail(cfeWarning);
            logger.warn(cfeWarning);
            Object[] args = new Object[]{name, tocItem.getElementNumber() + ""};
            tocItem.setRawBytes(null);
            tocItem.setIsFunky(true);
            throw new EngineRuntimeException(e, ExceptionCode.EVENT_CM_CLASS_FORMAT, args);
        }
        catch (Throwable t) {
            String defcWarning = "content element content defineClass failed " + tocItem + ": " + t;
            logger.traceDetail(defcWarning);
            logger.warn(defcWarning);
            tocItem.setRawBytes(null);
            tocItem.setIsFunky(true);
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            --this.defineClassDepth;
            tocItem.setClassIsBeingDefined(false);
        }
    }

    private static final Set<String> getOurStory() {
        Set<String> ourStorySoFar = ourStoryTL.get();
        if (ourStorySoFar == null) {
            ourStorySoFar = new HashSet<String>();
            ourStoryTL.set(ourStorySoFar);
        }
        return ourStorySoFar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] obtainElementBytes(CodeModuleToCItem tocItem, String name) {
        String thisItem;
        Set<String> ourStorySoFar = CodeModuleClassLoader.getOurStory();
        if (ourStorySoFar.contains(thisItem = "obtainElementBytes(" + tocItem + ",\"" + name + "\")")) {
            this.makeANoteOfTheMadness(thisItem);
            return null;
        }
        try {
            ourStorySoFar.add(thisItem);
            byte[] byArray = this.obtainElementBytesInternal(tocItem);
            return byArray;
        }
        finally {
            ourStorySoFar.remove(thisItem);
        }
    }

    private void makeANoteOfTheMadness(String thisItem) {
        String madnessMessage = "CMCL: Recursion stopped: " + thisItem + " in " + this;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(madnessMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] obtainElementBytesInternal(CodeModuleToCItem tocItem) {
        byte[] classBytes = tocItem.getRawBytes();
        if (classBytes == null) {
            InputStream is;
            ContentTransfer ct;
            int size;
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL reading raw class from the CE content element " + tocItem);
            }
            if ((size = (ct = tocItem.getContentTransfer()).get_ContentSize().intValue()) <= 0) {
                String emtpyWarning = "empty content element read, skipped: " + tocItem + " for " + this;
                logger.traceDetail(emtpyWarning);
                logger.warn(emtpyWarning);
                return null;
            }
            if (size > MAX_CLASS_SIZE) {
                String tooBigWarning = "content element exceeds CMCL max class size, skipped: " + tocItem + " for " + this;
                logger.traceDetail(tooBigWarning);
                logger.warn(tooBigWarning);
                return null;
            }
            classBytes = new byte[size];
            boolean previous = CodeModuleClassLoader.preRPC();
            try {
                is = ct.accessContentStream();
            }
            catch (RuntimeException r) {
                String ioeWarning = "exception while opening Class content element for reading " + tocItem + ": " + r;
                logger.traceDetail(ioeWarning);
                logger.warn(ioeWarning);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                CodeModuleClassLoader.postRPC(previous);
            }
            int offset = 0;
            try {
                int count;
                for (int remaining = classBytes.length; remaining > 0 && (count = is.read(classBytes, offset, remaining)) > 0; remaining -= count) {
                    offset += count;
                }
            }
            catch (IOException e) {
                String ioeWarning = "exception while reading content element content " + tocItem + ": " + e;
                logger.traceDetail(ioeWarning);
                logger.warn(ioeWarning);
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL   read raw class from the CE content element " + tocItem + ", " + classBytes.length + " bytes");
            }
            tocItem.setRawBytes(classBytes);
        }
        return classBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getRawClassFromJarZipElement(CodeModuleToCItem tocItem, String name) {
        String thisItem;
        Set<String> ourStorySoFar = CodeModuleClassLoader.getOurStory();
        if (ourStorySoFar.contains(thisItem = "getRawClassFromJarZipElement(" + tocItem + ",\"" + name + "\")")) {
            this.makeANoteOfTheMadness(thisItem);
            return null;
        }
        try {
            ourStorySoFar.add(thisItem);
            Class<?> clazz = this.getRawClassFromJarZipElementInternal(tocItem, name);
            return clazz;
        }
        finally {
            ourStorySoFar.remove(thisItem);
        }
    }

    private Class<?> getRawClassFromJarZipElementInternal(CodeModuleToCItem tocItem, String name) {
        String resourcePath;
        ClassLoader jarZipClassLoader;
        InputStream resourceStream;
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL search for class " + name + " in JAR/ZIP " + tocItem);
        }
        if ((resourceStream = (jarZipClassLoader = tocItem.getJarZipClassLoader()).getResourceAsStream(resourcePath = CodeModuleClassLoader.classNameToResourcePath(name))) == null) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL path " + resourcePath + " not found in JAR/ZIP; skipping");
            }
            return null;
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL path " + resourcePath + " found in JAR/ZIP");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        try {
            int count;
            while ((count = resourceStream.read(buf)) >= 0) {
                baos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("exception while reading JAR/ZIP content: " + e);
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    logger.info(" CMCL failed to close jarZip stream for class : " + name);
                }
            }
        }
        try {
            Class<?> rawClass;
            byte[] classBytes = baos.toByteArray();
            ++this.defineClassDepth;
            Class<?> clazz = rawClass = this.definePackageThenClass("JarZip", name, classBytes);
            return clazz;
        }
        catch (ClassCircularityError e) {
            if (this.defineClassDepth > 1) {
                String cfeWarning = "Ignoring unusual but legal class circularity (depth " + this.defineClassDepth + ") " + tocItem + ": " + e;
                logger.traceDetail(cfeWarning);
                logger.warn(cfeWarning);
                Class<?> clazz = null;
                return clazz;
            }
            Object[] args = new Object[]{name, tocItem.getElementNumber() + ""};
            throw new EngineRuntimeException(e, ExceptionCode.EVENT_CM_CIRCULARITY, args);
        }
        catch (ClassFormatError e) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("JAR/ZIP content is not a valid Java class file: " + e);
            }
            Object[] args = new Object[]{name, tocItem.getElementNumber() + ""};
            throw new EngineRuntimeException(e, ExceptionCode.EVENT_CM_CLASS_FORMAT, args);
        }
        catch (Throwable t) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("JAR/ZIP content defineClass failed: " + t);
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            --this.defineClassDepth;
        }
    }

    private static String classNameToResourcePath(String className) {
        String resourcePath = className.replace('.', '/') + ".class";
        return resourcePath;
    }

    private int getDepth() {
        return this.classOrResourceDepth.get();
    }

    private void setDepth(int newDepth) {
        this.classOrResourceDepth.set(newDepth);
    }

    private void bumpUpDepth() {
        int current = this.getDepth();
        this.setDepth(current + 1);
    }

    private void bumpDownDepth() {
        int current = this.getDepth();
        this.setDepth(current - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            this.bumpUpDepth();
            Class<?> clazz = this.loadClassCounted(name, resolve);
            return clazz;
        }
        finally {
            this.bumpDownDepth();
        }
    }

    private Class<?> loadClassCounted(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block16: {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CodeModuleClassLoader.loadClass(" + name + "," + resolve + ") " + this);
            }
            if ((c = this.findLoadedClass(name)) != null) {
                if (logger.isDetailTraceEnabled()) {
                    this.logger_traceDetail("CMCL class " + name + " was found already loaded in JVM");
                }
            } else {
                if (this.doParentFirstForClasses) {
                    try {
                        c = this.parentClassLoader.loadClass(name);
                        if (logger.isDetailTraceEnabled()) {
                            this.logger_traceDetail("CMCL class " + name + " found by PARENT classloader 0x" + Integer.toHexString(System.identityHashCode(c.getClassLoader())));
                        }
                        break block16;
                    }
                    catch (ClassNotFoundException e) {
                        if (logger.isDetailTraceEnabled()) {
                            this.logger_traceDetail("CMCL class " + name + " NOT found by PARENT classloader");
                        }
                        c = this.loadClassFromSomewhere(name);
                        if (logger.isDetailTraceEnabled()) {
                            this.logger_traceDetail("CMCL class " + name + " found by CMCL classloader, CC=" + ++this.classesLoaded);
                        }
                        break block16;
                    }
                }
                try {
                    c = this.loadClassFromSomewhere(name);
                    if (logger.isDetailTraceEnabled()) {
                        this.logger_traceDetail("CMCL class " + name + " found by CMCL classloader, CC=" + ++this.classesLoaded);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (logger.isDetailTraceEnabled()) {
                        this.logger_traceDetail("CMCL class " + name + " NOT found by CMCL classloader");
                    }
                    c = this.parentClassLoader.loadClass(name);
                    if (!logger.isDetailTraceEnabled()) break block16;
                    this.logger_traceDetail("CMCL class " + name + " found by PARENT classloader 0x" + Integer.toHexString(System.identityHashCode(c.getClassLoader())));
                }
            }
        }
        if (resolve) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL resolving " + c);
            }
            this.resolveClass(c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        String thisItem;
        Set<String> ourStorySoFar = CodeModuleClassLoader.getOurStory();
        if (ourStorySoFar.contains(thisItem = "findResource(\"" + name + "\")")) {
            this.makeANoteOfTheMadness(thisItem);
            return null;
        }
        try {
            ourStorySoFar.add(thisItem);
            this.bumpUpDepth();
            URL uRL = this.findResourceInternal(name);
            return uRL;
        }
        finally {
            this.bumpDownDepth();
            ourStorySoFar.remove(thisItem);
        }
    }

    private URL findResourceInternal(String name) {
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL CodeModuleClassLoader.findResource(" + name + ") " + this);
        }
        if (this.jbojClassLoader != null) {
            return this.jbojClassLoader.findResource(name);
        }
        if (!this.hasCodeModule()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL No CodeModule so " + name + " not found");
            }
            return null;
        }
        for (CodeModuleToCItem tocItem : this.cmTOC) {
            URL u;
            if (name.equals(tocItem.getContentTransfer().get_RetrievalName()) && (u = this.findResourceFromElement(tocItem)) != null) {
                if (logger.isDetailTraceEnabled()) {
                    this.logger_traceDetail("CMCL resource " + name + " found at " + u);
                }
                return u;
            }
            if (!tocItem.isJarZipElement() || (u = this.getResourceFromJarZipElement(tocItem, name)) == null) continue;
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL resource " + name + " found at " + u);
            }
            return u;
        }
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL resource " + name + " not found");
        }
        return null;
    }

    private URL findResourceFromElement(CodeModuleToCItem tocItem) {
        URL u = ContentElementURLutil.makeContentElementURL(this.connection, this.osId.toString(), "CodeModule", this.cmId.toString(), tocItem.getElementNumber(), -1, null);
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Enumeration<URL> findResources(String name) {
        String thisItem;
        Set<String> ourStorySoFar = CodeModuleClassLoader.getOurStory();
        if (ourStorySoFar.contains(thisItem = "findResources(\"" + name + "\")")) {
            this.makeANoteOfTheMadness(thisItem);
            return DummyEnumeration.EMPTY;
        }
        try {
            ourStorySoFar.add(thisItem);
            this.bumpUpDepth();
            Enumeration<URL> enumeration = this.findResourcesInternal(name);
            return enumeration;
        }
        finally {
            this.bumpDownDepth();
            ourStorySoFar.remove(thisItem);
        }
    }

    protected Enumeration<URL> findResourcesInternal(String name) {
        if (logger.isDetailTraceEnabled()) {
            this.logger_traceDetail("CMCL CodeModuleClassLoader.findResources(" + name + ") " + this);
        }
        if (this.jbojClassLoader != null) {
            try {
                return this.jbojClassLoader.findResources(name);
            }
            catch (IOException e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, (Object[])null);
            }
        }
        Vector<URL> urls = new Vector<URL>();
        if (!this.hasCodeModule()) {
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL No CodeModule so resource " + name + " not found");
            }
            return urls.elements();
        }
        for (CodeModuleToCItem tocItem : this.cmTOC) {
            URL u;
            if (name.equals(tocItem.getContentTransfer().get_RetrievalName()) && (u = this.findResourceFromElement(tocItem)) != null) {
                if (logger.isDetailTraceEnabled()) {
                    this.logger_traceDetail("CMCL resource " + name + " found at " + u);
                }
                urls.add(u);
            }
            if (!tocItem.isJarZipElement() || (u = this.getResourceFromJarZipElement(tocItem, name)) == null) continue;
            if (logger.isDetailTraceEnabled()) {
                this.logger_traceDetail("CMCL resource " + name + " found at " + u);
            }
            urls.add(u);
        }
        return urls.elements();
    }

    @Override
    public URL getResource(String name) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL CodeModuleClassLoader.getResource(" + name + ") " + this);
        }
        URL u = null;
        if (this.doParentFirstForResources) {
            u = this.parentClassLoader.getResource(name);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("CMCL resource " + name + " PARENT result " + u);
            }
            if (u == null) {
                u = this.findResource(name);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CMCL resource " + name + " CMCL result " + u);
                }
            }
        } else {
            u = this.findResource(name);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("CMCL resource " + name + " CMCL result " + u);
            }
            if (u == null) {
                u = this.parentClassLoader.getResource(name);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CMCL resource " + name + " PARENT result " + u);
                }
            }
        }
        return u;
    }

    private URL getResourceFromJarZipElement(CodeModuleToCItem tocItem, String name) {
        ClassLoader cl = tocItem.getJarZipClassLoader();
        return cl.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL CodeModuleClassLoader.getResourceAsStream(" + name + ") " + this);
        }
        URL u = this.getResource(name);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL resource URL " + u);
        }
        if (u == null) {
            return null;
        }
        boolean previous = CodeModuleClassLoader.preRPC();
        try {
            InputStream inputStream = u.openStream();
            return inputStream;
        }
        catch (IOException e) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("exception while opening resource URL: " + u + "; " + e);
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            CodeModuleClassLoader.postRPC(previous);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL url;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL CodeModuleClassLoader.getResources(" + name + ") " + this);
        }
        String firstString = this.doParentFirstForResources ? "PARENT: " : "CMCL: ";
        String secondString = this.doParentFirstForResources ? "CMCL: " : "PARENT: ";
        Enumeration<URL> first = null;
        Enumeration<URL> second = null;
        if (this.doParentFirstForResources) {
            first = this.parentClassLoader.getResources(name);
            second = this.findResources(name);
        } else {
            first = this.findResources(name);
            second = this.parentClassLoader.getResources(name);
        }
        Vector<URL> urls = new Vector<URL>();
        StringBuffer sb = null;
        if (logger.isDetailTraceEnabled()) {
            sb = new StringBuffer();
            sb.append("Resources:: ").append(firstString);
        }
        while (first.hasMoreElements()) {
            url = first.nextElement();
            if (logger.isDetailTraceEnabled() && sb != null) {
                sb.append(url).append(", ");
            }
            urls.add(url);
        }
        if (logger.isDetailTraceEnabled() && sb != null) {
            sb.append(" ... ").append(secondString);
        }
        while (second.hasMoreElements()) {
            url = second.nextElement();
            if (logger.isDetailTraceEnabled() && sb != null) {
                sb.append(url).append(", ");
            }
            urls.add(url);
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL " + sb);
        }
        return urls.elements();
    }

    private void logger_traceDetail(String s) {
        int depth = this.getDepth();
        String prefix = depth <= 0 ? "" : (depth > depthPrefix.length() ? depthPrefix : depthPrefix.substring(0, depth));
        logger.traceDetail(prefix + s);
    }

    protected void finalize() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL finalize 0x" + Integer.toHexString(System.identityHashCode(this)) + " " + this);
        }
        this.removedFromCacheCallback();
        this.cmTOC.clear();
        this.cmTOC = null;
    }

    protected void removedFromCacheCallback() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL cache size is now " + clInstances.size() + " of " + clInstances.getMaxEntries());
        }
        if (this.cmTOC == null || this.cmTOC.size() == 0) {
            return;
        }
        for (CodeModuleToCItem tocItem : this.cmTOC) {
            tocItem.uncacheToCItem();
        }
    }

    static boolean preRPC() {
        boolean previous = ApiToEngineBridge.setSecurityCheckingDisabled(true);
        return previous;
    }

    static void postRPC(boolean previous) {
        ApiToEngineBridge.setSecurityCheckingDisabled(previous);
    }

    private boolean isNonDelegatedPackageClass(String className) {
        return CodeModuleClassLoader.isNonDelegatedPackageClass(className, this.bangPackageName);
    }

    private static final boolean isNonDelegatedPackageClass(String className, String bangPackageName) {
        String packageName = Util.getPackageName(className);
        boolean isInList = Util.isInSomePackageCollection(packageName, nonDelegatedPackages);
        if (isInList) {
            return true;
        }
        if (!ndpHasBang) {
            return false;
        }
        boolean sameAsBase = packageName.equals(bangPackageName);
        return sameAsBase;
    }

    private static final boolean isYesDelegatedPackageClass(String className) {
        String packageName = Util.getPackageName(className);
        boolean isInList = Util.isInSomePackageCollection(packageName, yesDelegatedPackages);
        return isInList;
    }

    static {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL    ENGINE classloader: 0x" + Integer.toHexString(System.identityHashCode(engineClassLoader)) + " " + engineClassLoader);
            ClassLoader parent = engineClassLoader;
            while (parent != null && (parent = parent.getParent()) != null) {
                logger.traceDetail("CMCL    ENGINE    parentCL: 0x" + Integer.toHexString(System.identityHashCode(parent)) + " " + parent);
            }
            logger.traceDetail("CMCL       API classloader: 0x" + Integer.toHexString(System.identityHashCode(apiClassLoader)) + " " + apiClassLoader);
            parent = apiClassLoader;
            while (parent != null && (parent = parent.getParent()) != null) {
                logger.traceDetail("CMCL       API    parentCL: 0x" + Integer.toHexString(System.identityHashCode(parent)) + " " + parent);
            }
            logger.traceDetail("CMCL BOOTSTRAP classloader: 0x" + Integer.toHexString(System.identityHashCode(bootstrapClassLoader)) + " " + bootstrapClassLoader);
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            logger.traceDetail("CMCL    SYSTEM classloader: 0x" + Integer.toHexString(System.identityHashCode(scl)) + " " + scl);
        }
        MAX_CACHE_ENTRIES = ConfigValueLookup.getValueAsInt("com.filenet.engine.cmcl.cachesize", 99);
        MAX_CLASS_SIZE = ConfigValueLookup.getValueAsInt("com.filenet.engine.cmcl.maxclasssize", 200000);
        boolean svr = engineClassLoader != null;
        int cacheTTL = 86400;
        if (svr) {
            cacheTTL = ApiToEngineBridge.getGCDValue(GCD_CACHE_CONFIG_CLASS_NAME, GCD_CACHE_CONFIG_ITEM_TTL, 86400, null);
            clInstances = new ConcurrentCache(false, cacheTTL, MAX_CACHE_ENTRIES, null, "CodeModule ClassLoader Cache", true);
        } else {
            clInstances = null;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL CACHE (server=" + svr + "): 0x" + Integer.toHexString(System.identityHashCode(clInstances)) + " " + clInstances);
            if (clInstances != null) {
                logger.traceDetail("CMCL CACHE ttl " + cacheTTL + " seconds, max entries " + MAX_CACHE_ENTRIES);
            }
            logger.traceDetail("CMCL max class size " + MAX_CLASS_SIZE);
        }
        lastTwiddle = 0L;
        simpleName = CodeModuleClassLoader.class.getSimpleName();
        ourStoryTL = new ThreadLocal();
        ZERO = 0;
        nonDelegatedPackages = new TreeSet<String>();
        yesDelegatedPackages = new TreeSet<String>();
        String commaList = ConfigValueLookup.getValue("com.filenet.engine.cmcl.ndps", "!");
        Util.parsePackageNamesToCollection(commaList, nonDelegatedPackages);
        ndpHasBang = nonDelegatedPackages.contains("!");
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL non-delegated packages: " + nonDelegatedPackages.size() + " " + nonDelegatedPackages);
        }
        commaList = ConfigValueLookup.getValue("com.filenet.engine.cmcl.ydps", "com.filenet.api,com.filenet.apiimpl,com.filenet.engine,com.ibm.ws.security");
        Util.parsePackageNamesToCollection(commaList, yesDelegatedPackages);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL yes-delegated packages: " + yesDelegatedPackages.size() + " " + yesDelegatedPackages);
        }
    }
}

