/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.admin.CodeModule;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.ReferentialContainmentRelationshipSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CodeModuleClassLoader;
import com.filenet.apiimpl.util.classloader.ContentElementURLutil;
import com.filenet.apiimpl.util.classloader.DummyClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CodeModuleToCItem {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CodeModuleToCItem.class, SubSystem.CodeModule);
    private static final String TEMP_FILE_SUFFIX = ".jar";
    private static final String TEMP_FILE_SUFFIX_TEMP = ".jub";
    private static final String TEMP_FILE_PREFIX = "cmcl-p8-";
    private static final String TEMP_DIRECTORY_NAME = ConfigValueLookup.getValue("com.filenet.engine.cmcl.cachedir", null);
    private static File TEMP_DIRECTORY = CodeModuleToCItem.fiddleCacheDirectory();
    private final ContentTransfer ct;
    private final int elementNumber;
    private byte[] rawBytes = null;
    private File cachedJarZipFile;
    private ClassLoader jarZipClassLoader;
    private boolean classAlreadyLoadedInJVM = false;
    private boolean classIsBeingDefined = false;
    private final boolean isClassElement;
    private final boolean isJarZipElement;
    private boolean isFunky = false;
    private static int maxJarZipRetries;
    private static final PropertyFilter TOC_PF;
    private static final PropertyFilter TOC_PATHS_PF;
    private String toStringStub = null;

    private static File fiddleCacheDirectory() {
        if (TEMP_DIRECTORY_NAME == null) {
            logger.traceSummary("CMCL will use default tmpdir for caching");
            return null;
        }
        logger.traceSummary("CMCL configured to use directory for caching: " + TEMP_DIRECTORY_NAME);
        File tempDirectory = new File(TEMP_DIRECTORY_NAME);
        if (tempDirectory.isDirectory()) {
            return tempDirectory;
        }
        if (tempDirectory.exists()) {
            String fallingBackWarning = "CMCL configured directory exists but is not a directory; falling back to default";
            logger.traceSummary(fallingBackWarning);
            logger.warn(fallingBackWarning);
            return null;
        }
        logger.traceSummary("CMCL attempting to create: " + TEMP_DIRECTORY_NAME);
        String fallingBackWarning = "CMCL directory creation failed; falling back to default";
        try {
            boolean madeIt = tempDirectory.mkdirs();
            if (madeIt) {
                return tempDirectory;
            }
            logger.traceSummary(fallingBackWarning);
            logger.warn(fallingBackWarning);
            return null;
        }
        catch (Throwable t) {
            fallingBackWarning = fallingBackWarning + " due to " + t;
            logger.traceSummary(fallingBackWarning);
            logger.warn(fallingBackWarning);
            return null;
        }
    }

    CodeModuleToCItem(ContentTransfer ct, int elementNumber) {
        this.ct = ct;
        this.elementNumber = elementNumber;
        String type = ct.get_ContentType();
        String name = ct.get_RetrievalName();
        if (name == null) {
            name = "";
        }
        this.isClassElement = ContentElementURLutil.isClassType(type) && ct.get_ContentSize() > 0.0;
        boolean bl = this.isJarZipElement = ContentElementURLutil.isJarZipType(type) && ct.get_ContentSize() > 0.0;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("content element " + elementNumber + " '" + type + "' isClassType? " + this.isClassElement + ", isJarZipType? " + this.isJarZipElement + ", " + name);
        }
    }

    private static void cleanUpOldCachedFiles() {
        File parent;
        if (logger.isSummaryTraceEnabled()) {
            logger.traceSummary("Start-up clean-up of CodeModule class loader cached files");
        }
        try {
            logger.traceSummary("File.createTempFile(cmcl-p8-, .jar, " + TEMP_DIRECTORY + ")");
            File temp = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, TEMP_DIRECTORY);
            logger.traceSummary("Temp file used for cleanup probing: " + temp.getAbsolutePath());
            parent = temp.getParentFile();
            temp.delete();
        }
        catch (IOException e) {
            String unableWarning = "Unable to open temp directory for CMCL cache cleanup. Watch for other CMCL problems.";
            logger.traceSummary(unableWarning);
            logger.warn(unableWarning);
            return;
        }
        JarZipFilenameFilter filter = new JarZipFilenameFilter();
        long staticInitTime = System.currentTimeMillis();
        File[] cachedFiles = parent.listFiles(filter);
        for (int ii = 0; ii < cachedFiles.length; ++ii) {
            File cachedFile = cachedFiles[ii];
            if (cachedFile.length() == 0L || cachedFile.lastModified() < staticInitTime - 60000L) {
                boolean deleteSuccess = cachedFile.delete();
                if (!logger.isSummaryTraceEnabled()) continue;
                logger.traceSummary("Deleting file: " + cachedFile + " ... success? " + deleteSuccess);
                continue;
            }
            if (!logger.isSummaryTraceEnabled()) continue;
            long size = cachedFile.length();
            logger.traceSummary("Skipping file (not empty or too fresh): " + cachedFile + "; size " + size);
        }
    }

    protected void uncacheToCItem() {
        this.uncacheJarZipFile();
    }

    protected void finalize() {
        this.uncacheToCItem();
    }

    boolean isClassElement() {
        return this.isClassElement;
    }

    boolean isJarZipElement() {
        return this.isJarZipElement;
    }

    void setRawBytes(byte[] rawBytes) {
        if (logger.isDetailTraceEnabled()) {
            if (rawBytes == null && this.rawBytes != null) {
                logger.traceDetail("discarding cached raw bytes " + this.toString() + ", " + this.rawBytes.length + " bytes");
            }
            if (rawBytes != null) {
                logger.traceDetail("caching raw bytes for reuse " + this.toString() + ", " + rawBytes.length + " bytes");
            }
        }
        this.rawBytes = rawBytes;
    }

    byte[] getRawBytes() {
        return this.rawBytes;
    }

    int getElementNumber() {
        return this.elementNumber;
    }

    ContentTransfer getContentTransfer() {
        return this.ct;
    }

    void setIsFunky(boolean isFunky) {
        this.isFunky = isFunky;
    }

    boolean isFunky() {
        return this.isFunky;
    }

    private void cacheJarZipFile() {
        InputStream ctStream;
        boolean previous = CodeModuleClassLoader.preRPC();
        try {
            ctStream = this.ct.accessContentStream();
        }
        catch (RuntimeException r) {
            String ioeWarning = "exception while opening JAR/ZIP content element for reading " + this + ": " + r;
            logger.traceSummary(ioeWarning);
            logger.warn(ioeWarning);
            throw r;
        }
        finally {
            CodeModuleClassLoader.postRPC(previous);
        }
        FileOutputStream fos = null;
        try {
            int count;
            File tempJarZipFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX_TEMP, TEMP_DIRECTORY);
            String tempTempName = tempJarZipFile.getPath();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Opening temp-temp cache file for write " + tempTempName + " for " + this);
            }
            fos = new FileOutputStream(tempJarZipFile);
            byte[] buf = new byte[65536];
            while ((count = ctStream.read(buf)) >= 0) {
                fos.write(buf, 0, count);
            }
            fos.close();
            String finalTempName = tempTempName.substring(0, tempTempName.length() - TEMP_FILE_SUFFIX_TEMP.length()) + TEMP_FILE_SUFFIX;
            this.cachedJarZipFile = new File(finalTempName);
            boolean renameSuccess = tempJarZipFile.renameTo(this.cachedJarZipFile);
            if (!renameSuccess) {
                this.cachedJarZipFile = null;
                boolean deleteSuccess = tempJarZipFile.delete();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Failed to rename cache file to " + finalTempName + " ... deleted? " + deleteSuccess);
                }
            } else if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Renamed cache file to " + finalTempName + " for " + this);
            }
        }
        catch (IOException e) {
            block17: {
                this.uncacheJarZipFile();
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        if (!logger.isSummaryTraceEnabled()) break block17;
                        logger.traceSummary("Exception inside exception handler: " + e1);
                    }
                }
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void uncacheJarZipFile() {
        this.jarZipClassLoader = null;
        if (this.cachedJarZipFile != null) {
            if (!this.cachedJarZipFile.exists()) {
                return;
            }
            deleteSuccess = this.cachedJarZipFile.delete();
            if (!deleteSuccess) {
                if (CodeModuleToCItem.logger.isDetailTraceEnabled()) {
                    CodeModuleToCItem.logger.traceDetail("Could not delete CMCL cache file " + this.cachedJarZipFile.getAbsolutePath());
                }
                fos = null;
                try {
                    fos = new FileOutputStream(this.cachedJarZipFile, false);
                    fos.write(new byte[0]);
                    if (!CodeModuleToCItem.logger.isDetailTraceEnabled()) ** GOTO lbl29
                    CodeModuleToCItem.logger.traceDetail("Truncated CMCL cache file " + this.cachedJarZipFile.getAbsolutePath());
                }
                catch (Exception e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        CodeModuleToCItem.logger.info(" failed to close file stream: " + this.cachedJarZipFile.getAbsolutePath());
                    }
                    this.cachedJarZipFile = null;
                }
            } else if (CodeModuleToCItem.logger.isDetailTraceEnabled()) {
                CodeModuleToCItem.logger.traceDetail("Deleted CMCL cache file " + this.cachedJarZipFile.getAbsolutePath() + " for " + this.toString());
            }
        }
lbl29:
        // 7 sources

        this.cachedJarZipFile = null;
    }

    private boolean isJarZipCached() {
        if (this.cachedJarZipFile == null) {
            return false;
        }
        if (this.cachedJarZipFile.exists() && this.cachedJarZipFile.length() > 0L) {
            return true;
        }
        this.cachedJarZipFile = null;
        return false;
    }

    ClassLoader getJarZipClassLoader() {
        int tryCount = 0;
        while (!this.isJarZipCached()) {
            this.jarZipClassLoader = null;
            try {
                this.cacheJarZipFile();
            }
            catch (RuntimeException r) {
                logger.traceDetail("Due to a problem reading the JAR/ZIP file, an empty URLClassLoader is returned for " + this);
                URL[] urls = new URL[]{};
                return new URLClassLoader(urls, (ClassLoader)DummyClassLoader.INSTANCE);
            }
            if (++tryCount <= maxJarZipRetries) continue;
            Object[] args = new Object[]{maxJarZipRetries + "", TEMP_DIRECTORY};
            throw new EngineRuntimeException(ExceptionCode.EVENT_CM_CACHE_LOOP, args);
        }
        if (this.jarZipClassLoader == null) {
            URL[] urls;
            try {
                URL jarZipURL = this.cachedJarZipFile.toURI().toURL();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("URL for cached file '" + this.cachedJarZipFile + "' is '" + jarZipURL + "' for " + this);
                }
                urls = new URL[]{jarZipURL};
            }
            catch (MalformedURLException e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            this.jarZipClassLoader = new URLClassLoader(urls, (ClassLoader)DummyClassLoader.INSTANCE);
        }
        return this.jarZipClassLoader;
    }

    boolean isClassAlreadyLoadedInJVM() {
        return this.classAlreadyLoadedInJVM;
    }

    void setClassAlreadyLoadedInJVM(boolean alreadyLoaded) {
        this.classAlreadyLoadedInJVM = alreadyLoaded;
    }

    public void setClassIsBeingDefined(boolean classIsBeingDefined) {
        this.classIsBeingDefined = classIsBeingDefined;
    }

    public boolean isClassBeingDefined() {
        return this.classIsBeingDefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<CodeModuleToCItem> populateTOC(Id osId, Id cmId, Connection connection) {
        CodeModule cm;
        Domain dom = Factory.Domain.getInstance(connection, null);
        ObjectStore os = Factory.ObjectStore.getInstance(dom, osId);
        boolean previous = CodeModuleClassLoader.preRPC();
        try {
            PropertyFilter cmPF = logger.isDetailTraceEnabled() ? TOC_PATHS_PF : TOC_PF;
            cm = Factory.CodeModule.fetchInstance(os, cmId, cmPF);
            if (logger.isDetailTraceEnabled()) {
                ObjectReference cmOR = cm.getObjectReference();
                logger.traceDetail("fetched CodeModule " + cmOR);
                ReferentialContainmentRelationshipSet rcrs = cm.get_Containers();
                if (rcrs == null || rcrs.isEmpty()) {
                    logger.traceDetail(cmOR + " path: (none)");
                } else {
                    Iterator it = rcrs.iterator();
                    while (it.hasNext()) {
                        ReferentialContainmentRelationship rcr = (ReferentialContainmentRelationship)it.next();
                        String containmentName = rcr.get_ContainmentName();
                        Folder folder = (Folder)rcr.get_Tail();
                        String path = folder.get_PathName();
                        logger.traceDetail(cmOR + " path: " + path + "/" + containmentName);
                    }
                }
            }
        }
        finally {
            CodeModuleClassLoader.postRPC(previous);
        }
        ContentElementList cel = cm.get_ContentElements();
        int celCount = cel.size();
        ArrayList<CodeModuleToCItem> cmTOC = new ArrayList<CodeModuleToCItem>(celCount);
        for (int ii = 0; ii < celCount; ++ii) {
            ContentElement ce = (ContentElement)cel.get(ii);
            if (!(ce instanceof ContentTransfer)) continue;
            ContentTransfer contentTransfer = (ContentTransfer)ce;
            CodeModuleToCItem tocItem = new CodeModuleToCItem(contentTransfer, ii);
            cmTOC.add(tocItem);
        }
        return cmTOC;
    }

    public String toString() {
        String state;
        if (this.toStringStub == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName()).append(":").append(this.elementNumber).append(":").append(this.ct.get_ElementSequenceNumber()).append(":").append(this.ct.get_ContentType()).append(":").append(this.ct.get_RetrievalName()).append(":state=");
            this.toStringStub = sb.toString();
        }
        if ((state = (this.isFunky() ? "F" : "") + (this.getRawBytes() != null ? "B" : "") + (this.isClassBeingDefined() ? "D" : "") + (this.isClassAlreadyLoadedInJVM() ? "L" : "")).length() == 0) {
            state = "U";
        }
        return this.toStringStub + state;
    }

    static {
        CodeModuleToCItem.cleanUpOldCachedFiles();
        maxJarZipRetries = ConfigValueLookup.getValueAsInt("com.filenet.engine.cmcl.jarzip.maxretry", 5);
        TOC_PF = new PropertyFilter();
        TOC_PATHS_PF = new PropertyFilter();
        TOC_PF.addIncludeProperty(1, null, null, "ContentElements", null);
        TOC_PF.addIncludeProperty(1, null, null, "ContentType", null);
        TOC_PF.addIncludeProperty(1, null, null, "RetrievalName", null);
        TOC_PF.addIncludeProperty(1, null, null, "ContentSize", null);
        TOC_PF.addIncludeProperty(1, null, null, "ElementSequenceNumber", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "ContentElements", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "ContentType", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "RetrievalName", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "ContentSize", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "ElementSequenceNumber", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "Containers", null);
        TOC_PATHS_PF.addIncludeProperty(1, null, null, "ContainmentName", null);
        TOC_PATHS_PF.addIncludeProperty(2, null, null, "Tail", null);
        TOC_PATHS_PF.addIncludeProperty(2, null, null, "PathName", null);
    }

    private static final class JarZipFilenameFilter
    implements FilenameFilter {
        private JarZipFilenameFilter() {
        }

        @Override
        public boolean accept(File parent, String simpleFilename) {
            if (!simpleFilename.startsWith(CodeModuleToCItem.TEMP_FILE_PREFIX)) {
                return false;
            }
            return simpleFilename.endsWith(CodeModuleToCItem.TEMP_FILE_SUFFIX);
        }
    }
}

