/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.ScriptEngine;
import com.filenet.apiimpl.util.classloader.ScriptHandler;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JavaScriptEngine
implements ScriptEngine {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(JavaScriptEngine.class, SubSystem.Events);
    private static final int maxPoolSize = ConfigValueLookup.getValueAsInt("com.filenet.engine.script.JavaScriptPoolSize", 4);
    private static final int optimizationLevel = ConfigValueLookup.getValueAsInt("com.filenet.engine.script.JavaScriptOptimizationLevel", 9);
    private static String[] bannedKeywords = new String[]{"ProcessBuilder", "Runtime.getRuntime"};
    private String scriptText;
    private ConcurrentLinkedQueue<CompiledScope> compiledScopes = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logScriptEngineInfo() {
        if (logger.isDetailTraceEnabled()) {
            Context context = Context.enter();
            try {
                ProtectionDomain protectionDomain = context.getClass().getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                URL location = codeSource.getLocation();
                logger.traceDetail("SCRIPT: JavaScript engine version " + context.getImplementationVersion() + ", from " + location);
                if (location == null) {
                    protectionDomain = ScriptHandler.class.getProtectionDomain();
                    codeSource = protectionDomain.getCodeSource();
                    location = codeSource.getLocation();
                    logger.traceDetail("SCRIPT: JavaScript engine version " + context.getImplementationVersion() + ", probably near " + location);
                }
                logger.traceDetail("SCRIPT: JavaScript engine classloader " + context.getClass().getClassLoader());
            }
            finally {
                Context.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(String scriptText) {
        for (int i = 0; i < bannedKeywords.length; ++i) {
            if (scriptText.indexOf(bannedKeywords[i]) == -1) continue;
            logger.error("SCRIPT: banned keyword '" + bannedKeywords[i] + "' found in script");
            throw new EngineRuntimeException(ExceptionCode.E_ACCESS_DENIED);
        }
        this.scriptText = scriptText;
        Context context = Context.enter();
        try {
            CompiledScope compiledScope = new CompiledScope(context, scriptText);
            this.compiledScopes.add(compiledScope);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String scriptMethod, Object[] parameters) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SCRIPT: " + JavaScriptEngine.class.getSimpleName() + " begin executing script function '" + scriptMethod + "', script hash=" + this.scriptText.hashCode());
        }
        Context context = Context.enter();
        CompiledScope scope = null;
        try {
            scope = this.getScope(context);
            Object object = scope.execute(context, scriptMethod, parameters);
            return object;
        }
        finally {
            this.releaseScope(scope);
            Context.exit();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SCRIPT: " + JavaScriptEngine.class.getSimpleName() + " end   executing script function '" + scriptMethod + "', script hash=" + this.scriptText.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify(String[] scriptMethods) {
        Context context = Context.enter();
        CompiledScope scope = null;
        try {
            scope = this.getScope(context);
            scope.verify(context, scriptMethods);
        }
        finally {
            this.releaseScope(scope);
            Context.exit();
        }
    }

    private CompiledScope getScope(Context context) {
        CompiledScope scope = this.compiledScopes.poll();
        if (scope == null) {
            scope = new CompiledScope(context, this.scriptText);
        }
        return scope;
    }

    private void releaseScope(CompiledScope scope) {
        if (scope != null && this.compiledScopes.size() < maxPoolSize) {
            this.compiledScopes.add(scope);
        }
    }

    static {
        JavaScriptEngine.logScriptEngineInfo();
    }

    private static class CompiledScope {
        private Scriptable scope;
        private ConcurrentHashMap<String, Function> functions = new ConcurrentHashMap();

        CompiledScope(Context context, String scriptText) {
            try {
                context.setGeneratingDebug(true);
                context.setOptimizationLevel(optimizationLevel);
                context.setGeneratingSource(false);
                this.scope = new ImporterTopLevel(context);
                context.evaluateString(this.scope, scriptText, "", 1, null);
            }
            catch (JavaScriptException e) {
                throw new EngineRuntimeException(e, ExceptionCode.SCRIPT_ERROR, null);
            }
            catch (EvaluatorException ee) {
                throw new EngineRuntimeException(ee, ExceptionCode.SCRIPT_ERROR, null);
            }
        }

        Object execute(Context context, String scriptMethod, Object[] parameters) {
            try {
                Object retObj;
                Function func = this.functions.get(scriptMethod);
                if (func == null) {
                    Object funObj = this.scope.get(scriptMethod, this.scope);
                    if (!(funObj instanceof Function)) {
                        throw new EngineRuntimeException(ExceptionCode.SCRIPT_NO_SUCH_METHOD, new Object[]{scriptMethod});
                    }
                    func = (Function)funObj;
                    this.functions.put(scriptMethod, func);
                }
                if ((retObj = ScriptRuntime.call((Context)context, (Object)func, (Object)this.scope, (Object[])parameters, (Scriptable)this.scope)) != null && retObj instanceof NativeJavaObject) {
                    NativeJavaObject njo = (NativeJavaObject)retObj;
                    retObj = njo.unwrap();
                }
                return retObj;
            }
            catch (JavaScriptException e) {
                throw new EngineRuntimeException(e, ExceptionCode.SCRIPT_ERROR, null);
            }
            catch (EvaluatorException ee) {
                throw new EngineRuntimeException(ee, ExceptionCode.SCRIPT_ERROR, null);
            }
        }

        void verify(Context context, String[] scriptMethods) {
            for (int i = 0; i < scriptMethods.length; ++i) {
                Object funObj = this.scope.get(scriptMethods[i], this.scope);
                if (!(funObj instanceof Function)) {
                    throw new EngineRuntimeException(ExceptionCode.SCRIPT_NO_SUCH_METHOD, new Object[]{scriptMethods[i]});
                }
                this.functions.put(scriptMethods[i], (Function)funObj);
            }
        }
    }
}

