/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Util {
    private Util() {
    }

    public static final String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDotAt = className.lastIndexOf(46);
        String packageName = "";
        if (lastDotAt > 0) {
            packageName = className.substring(0, lastDotAt);
        }
        return packageName;
    }

    public static final boolean isInSomePackageCollection(String thisPackageName, Iterable<String> candidatePackages) {
        for (String candidatePackage : candidatePackages) {
            if (thisPackageName.equals(candidatePackage)) {
                return true;
            }
            if (!thisPackageName.startsWith(candidatePackage + ".")) continue;
            return true;
        }
        return false;
    }

    public static void parsePackageNamesToCollection(String commaList, Collection collection) {
        if (commaList == null) {
            commaList = "";
        }
        String[] pkgSplits = commaList.split(",");
        for (int ii = 0; ii < pkgSplits.length; ++ii) {
            String somePkg = pkgSplits[ii];
            if ((somePkg = somePkg.trim()).equals(".")) {
                somePkg = "";
            }
            collection.add(somePkg);
        }
    }

    public static Map<String, String> parseDelimTrimToMap(String originalInput) {
        if (originalInput == null || originalInput.length() < 2) {
            throw new RuntimeException("I don't like your input value due to too short: '" + originalInput + "'");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String input = originalInput.trim();
        String delim = Pattern.quote(input.substring(0, 1));
        input = input.substring(1);
        String[] rawTokens = input.split(delim);
        for (int ii = 0; ii < rawTokens.length; ++ii) {
            String key = rawTokens[ii].trim();
            String value = ii == rawTokens.length - 1 ? null : rawTokens[++ii].trim();
            if (key == null || key.length() == 0) {
                if (value == null || value.length() == 0) continue;
                throw new RuntimeException("I don't like your input value due to a null key: '" + originalInput + "'");
            }
            map.put(key, value);
        }
        return map;
    }

    public static String urlWithoutQueryPart(String uri) {
        int firstQuestionMark = uri.indexOf(63);
        if (firstQuestionMark < 0) {
            return uri;
        }
        return uri.substring(0, firstQuestionMark);
    }

    public static String jarPathToUrlString(String jarFilePath) {
        String jarJarUrlString = "jar:file:" + jarFilePath + "!/";
        return jarJarUrlString;
    }
}

