/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.json;

import com.filenet.apiimpl.util.json.JSON;
import com.filenet.apiimpl.util.json.JSONArtifact;
import com.filenet.apiimpl.util.json.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class JSONObject
extends HashMap<String, Object>
implements JSONArtifact {
    public JSONObject() {
    }

    protected JSONObject(Tokenizer tkr) throws IOException {
        Tokenizer.Token tok;
        Tokenizer.TokenType tt;
        do {
            if ((tt = (tok = tkr.nextToken()).getTokenType()) == Tokenizer.TokenType.CLOSE_BRACE) {
                return;
            }
            if (tt != Tokenizer.TokenType.QUOTED_STRING) {
                throw new RuntimeException("Unexpected token " + tok + " while parsing JSON; expecting QUOTED_STRING");
            }
            String attrName = tok.getValue();
            tok = tkr.nextToken();
            if (tok.getTokenType() != Tokenizer.TokenType.COLON) {
                throw new RuntimeException("Unexpected token " + tok + " while parsing JSON; expecting COLON");
            }
            tok = tkr.nextToken();
            Object attrVal = JSON.decodeToken(tok, tkr);
            this.put(attrName, attrVal);
            tok = tkr.nextToken();
            tt = tok.getTokenType();
            if (tt != Tokenizer.TokenType.CLOSE_BRACE) continue;
            return;
        } while (tt == Tokenizer.TokenType.COMMA);
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON; expecting COMMA or CLOSE_BRACE");
    }

    public static JSONObject parse(String json) throws IOException {
        return JSONObject.parse(new StringReader(json));
    }

    public static JSONObject parse(Reader reader) throws IOException {
        Tokenizer tkr = new Tokenizer(reader);
        Tokenizer.Token tok = tkr.nextToken();
        if (tok.getTokenType().equals((Object)Tokenizer.TokenType.OPEN_BRACE)) {
            return new JSONObject(tkr);
        }
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON object; expecting OPEN_BRACE");
    }

    public static JSONObject parse(InputStream stream) throws IOException {
        return JSONObject.parse(new InputStreamReader(stream));
    }

    @Override
    public String serialize() throws IOException {
        return this.toString();
    }

    public void serialize(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    @Override
    public void serialize(OutputStream os) throws IOException {
        this.serialize(new OutputStreamWriter(os));
    }

    public String getString(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        this.toJsonString(sb);
        return sb.toString();
    }

    void toJsonString(StringBuilder sb) {
        sb.append("{");
        int count = 0;
        for (Map.Entry me : this.entrySet()) {
            if (count > 0) {
                sb.append(",");
            }
            String key = (String)me.getKey();
            sb.append('\"');
            sb.append(key);
            sb.append("\":");
            JSON.toJsonString(sb, me.getValue());
            ++count;
        }
        sb.append("}");
    }
}

