/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.MultipartOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class AttachmentHelperNst {
    private static final TransportLogger logger = TransportLogger.getLogger(AttachmentHelperNst.class, SubSystem.WSI);
    private List attachmentsToBeWritten = null;
    private long attachmentNumberBase = 0L;
    private long attachmentNumberHighWater = 0L;
    private final Random RNG = new Random();
    private String uniquePiece = null;
    private byte[] bufferForCopyingAttachmentContent = null;

    AttachmentHelperNst() {
    }

    final String registerAttachment(int attachmentBindingType, InputStream stream) {
        if (this.attachmentsToBeWritten == null) {
            this.attachmentsToBeWritten = new ArrayList();
        }
        this.attachmentsToBeWritten.add(stream);
        String cid = this.computeContentId(this.attachmentsToBeWritten.size(), attachmentBindingType);
        return "cid:" + cid;
    }

    final String computeContentId(int n, int attachmentBindingType) {
        long thisN = (long)n + this.attachmentNumberBase;
        this.attachmentNumberHighWater = Math.max(this.attachmentNumberHighWater, thisN);
        String thisNuniquePiece = "v" + thisN + "-" + this.getUniquePiece();
        String computedContentId = thisNuniquePiece + "@mtom.p8ce.filenet.com";
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("oPART assign " + n + "   CID= " + computedContentId);
        }
        return computedContentId;
    }

    final String getUniquePiece() {
        if (this.uniquePiece == null) {
            String randPiece = Long.toHexString(this.RNG.nextLong());
            String timePiece = Long.toHexString(System.currentTimeMillis());
            this.uniquePiece = randPiece + "-" + timePiece;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("unique piece: " + this.uniquePiece);
            }
        }
        return this.uniquePiece;
    }

    final boolean thereAreAttachments() {
        if (this.attachmentsToBeWritten == null) {
            return false;
        }
        return this.attachmentsToBeWritten.size() != 0;
    }

    final List getRegisteredAttachments() {
        return this.attachmentsToBeWritten;
    }

    final void clearRegisteredAttachments() {
        this.attachmentNumberBase = this.attachmentNumberHighWater + 1L;
        this.attachmentsToBeWritten = null;
    }

    void spillAndClearAttachments(MultipartOutputStream moStr, int attachmentBindingType) throws IOException {
        if (this.thereAreAttachments()) {
            int attachmentNumber = 0;
            Iterator it = this.getRegisteredAttachments().iterator();
            while (it.hasNext()) {
                int n;
                String contentIdN = this.computeContentId(++attachmentNumber, attachmentBindingType);
                moStr.startAttachment(contentIdN);
                InputStream thisAttachmentIStr = (InputStream)it.next();
                if (this.bufferForCopyingAttachmentContent == null) {
                    this.bufferForCopyingAttachmentContent = new byte[2000];
                }
                int nTotal = 0;
                while ((n = thisAttachmentIStr.read(this.bufferForCopyingAttachmentContent)) > 0) {
                    moStr.write(this.bufferForCopyingAttachmentContent, 0, n);
                    nTotal += n;
                }
                thisAttachmentIStr.close();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("oPART wrote  " + attachmentNumber + "   CID= " + contentIdN + " ; bytes " + nTotal);
                }
                moStr.endAttachment(it.hasNext());
            }
            this.clearRegisteredAttachments();
        }
    }
}

