/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class HttpCookieStore {
    private static final TransportLogger logger = TransportLogger.getLogger(HttpCookieStore.class, SubSystem.WSI);
    private static final ConcurrentHashMap<String, CookieManager> cookieJar = new ConcurrentHashMap();
    private static final HttpCookieStore cookieStore = new HttpCookieStore();
    private static final long HTTP_COOKIE_EXPIRATION = ConfigValueLookup.getValueAsInt("FileNet.WSI.HttpCookieMaxAge", 600);
    private static final Map<String, List<String>> dummyMap = Collections.unmodifiableMap(new HashMap());

    private HttpCookieStore() {
    }

    final void storeReturnedCookies(String userName, URLConnection httpConn) throws Exception {
        Map<String, List<String>> responseHeaders;
        if (userName != null && !(responseHeaders = httpConn.getHeaderFields()).isEmpty()) {
            logger.traceDetail("Storing cookies for user: \"" + userName + "\" from URL: \"" + httpConn.getURL() + "\".");
            CookieManager cookieManager = cookieJar.get(userName);
            if (cookieManager == null) {
                CookieManager newCookieManager = new CookieManager();
                while ((cookieManager = cookieJar.putIfAbsent(userName, newCookieManager)) == null) {
                }
            }
            URI uri = httpConn.getURL().toURI();
            cookieManager.put(uri, responseHeaders);
            CookieStore cookieStore = cookieManager.getCookieStore();
            if (cookieStore != null) {
                List<HttpCookie> cookies = cookieStore.getCookies();
                for (int i = cookies.size() - 1; i >= 0; --i) {
                    HttpCookie cookie = null;
                    try {
                        cookie = cookies.get(i);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        continue;
                    }
                    long maxAge = cookie.getMaxAge();
                    if (maxAge != HTTP_COOKIE_EXPIRATION) {
                        cookie.setMaxAge(HTTP_COOKIE_EXPIRATION);
                    }
                    if (!logger.isDetailTraceEnabled()) continue;
                    logger.traceDetail("Found cookie to store with name: \"" + cookie.getName() + "\", domain: \"" + cookie.getDomain() + "\", path: \"" + cookie.getPath() + "\", max age: \"" + cookie.getMaxAge() + "\", version: \"" + cookie.getVersion() + "\", port list: \"" + cookie.getPortlist() + "\", discard: \"" + cookie.getDiscard() + "\", secure: \"" + cookie.getSecure() + "\", comment: \"" + cookie.getComment() + "\", comment URL: \"" + cookie.getCommentURL() + "\", value: \"" + cookie.getValue() + "\".");
                }
            }
        }
    }

    final void removeStoredCookies(String userName, URLConnection httpConn) throws Exception {
        CookieManager cookieManager;
        if (userName != null && (cookieManager = cookieJar.get(userName)) != null) {
            URI uri = httpConn.getURL().toURI();
            CookieStore cookieStore = cookieManager.getCookieStore();
            ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
            cookies.addAll(cookieStore.get(uri));
            for (HttpCookie cookie : cookies) {
                cookieStore.remove(uri, cookie);
            }
            if (cookieStore.getCookies().isEmpty()) {
                cookieJar.remove(userName);
            }
        }
    }

    final String getCookieString(String userName, URI uri) {
        String allCookieStr = null;
        StringBuilder allCookieStrBuf = new StringBuilder();
        CookieManager cookieManager = cookieJar.get(userName);
        if (cookieManager != null) {
            try {
                Map<String, List<String>> cookieMap = cookieManager.get(uri, dummyMap);
                List<String> cookieList = cookieMap.get("Cookie");
                for (String cookieInfo : cookieList) {
                    int index;
                    if (allCookieStrBuf.length() > 0) {
                        allCookieStrBuf.append("; ");
                    }
                    if ((index = cookieInfo.indexOf(59)) > 0) {
                        cookieInfo = cookieInfo.substring(0, index);
                    }
                    allCookieStrBuf.append(cookieInfo);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            allCookieStr = allCookieStrBuf.toString();
            logger.traceDetail("Retrieved cookie string: " + allCookieStr);
        }
        return allCookieStr;
    }

    public static final HttpCookieStore getCookieStore() {
        return cookieStore;
    }
}

