/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.smm.TimerMeasurement;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.EngineCommPort;
import com.filenet.apiimpl.transport.ejb.EngineCommPortFactory;
import com.filenet.apiimpl.transport.ejb.EnginePort;
import com.filenet.apiimpl.transport.ejb.EnginePortFactory;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.wsi.ClientInfo;
import java.security.GeneralSecurityException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;

class ServerHelperNst {
    private final String operation;
    private static InitialContext namingContext;
    private long start;

    public ServerHelperNst(String operation) {
        this.operation = operation;
    }

    protected void traceRequest(Request request, TransportLogger logger) throws Exception {
        if (logger != null && logger.isCallTraceEnabled()) {
            logger.traceRequest(null, this.operation, (Message)((Object)request));
        }
        this.start = TimerMeasurement.getMillis();
    }

    protected void traceResponse(EngineRuntimeException ere, Response response, TransportLogger logger) {
        if (ere == null) {
            if (logger != null) {
                logger.traceResponse(null, this.operation, (Message)((Object)response), this.start);
            }
        } else if (logger != null) {
            logger.traceException(this.operation, ere, this.start);
        }
    }

    protected Context getNamingContext() {
        if (namingContext == null) {
            try {
                namingContext = new InitialContext();
            }
            catch (NamingException e) {
                throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_NO_INITIAL_CONTEXT, null);
            }
        }
        return namingContext;
    }

    protected EnginePort getEnginePort() throws Exception {
        Object home = SessionLocator.getEJB(this.getNamingContext());
        if (home == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_UNABLE_TO_LOCATE_EJB, null);
        }
        try {
            return EnginePortFactory.create(home);
        }
        catch (Throwable e) {
            Throwable aleCause = e.getCause();
            if (e instanceof AccessLocalException && (aleCause instanceof SecurityException || aleCause instanceof GeneralSecurityException)) {
                throw new EngineRuntimeException(e, ExceptionCode.E_NOT_AUTHENTICATED, null);
            }
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_UNABLE_TO_LOCATE_EJB, new Object[]{home.toString()});
        }
    }

    protected EngineCommPort getEngineCommPort() throws Exception {
        Object home = SessionLocator.getCommEJB(this.getNamingContext());
        if (home == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_UNABLE_TO_LOCATE_EJB, null);
        }
        try {
            return EngineCommPortFactory.create(home);
        }
        catch (Throwable e) {
            Throwable aleCause = e.getCause();
            if (e instanceof AccessLocalException && (aleCause instanceof SecurityException || aleCause instanceof GeneralSecurityException)) {
                throw new EngineRuntimeException(e, ExceptionCode.E_NOT_AUTHENTICATED, null);
            }
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_UNABLE_TO_LOCATE_EJB, new Object[]{home.toString()});
        }
    }

    protected static EngineRuntimeException distillInterestingException(Throwable t, String principal, TransportLogger logger) {
        EngineRuntimeException ere;
        if (t == null) {
            return null;
        }
        Throwable cause = t;
        while (cause != null) {
            if (cause instanceof EngineRuntimeException) {
                t = cause;
                if (((EngineRuntimeException)t).getExceptionCode() != ExceptionCode.E_UNEXPECTED_EXCEPTION) break;
                cause = cause.getCause();
                continue;
            }
            if (cause instanceof EJBException) {
                cause = ((EJBException)cause).getCausedByException();
                continue;
            }
            cause = cause.getCause();
        }
        if (t instanceof EngineRuntimeException) {
            ere = (EngineRuntimeException)t;
        } else {
            ere = new EngineRuntimeException(t, ExceptionCode.E_SERVER_ERROR, null);
            logger.logError(ere, principal, Boolean.FALSE, Boolean.FALSE);
        }
        return ere;
    }

    protected static void setClientInfo(String bindingVersionHint, Subject subject) {
        Integer binding = ClientInfo.determineBinding(bindingVersionHint);
        Integer version = ClientInfo.determineWsdlVersion(bindingVersionHint);
        if (binding == null || version == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_FAILED_SERVER_CALL_CONTEXT_CREATE, null, ExceptionContext.TRANSPORT_WSI_BINDING_FAILED, new Object[]{bindingVersionHint == null ? "<unknown>" : bindingVersionHint});
        }
        SessionContext.setSessionContext(new SessionContext(null));
        ClientInfo.setVersion(version);
        ClientInfo.setBinding(binding);
        ClientInfo.setLocation(2);
        ClientInfo.setSubject(subject);
    }
}

