/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.constants.MergeMode;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.query.MergedScope;
import com.filenet.apiimpl.query.ObjectStoreScope;
import com.filenet.apiimpl.query.SearchScope;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import java.util.HashMap;
import java.util.List;

public class SearchScopeSerialization
extends Serialization {
    private static HashMap MAP_MERGE_MODE = new HashMap();
    public static final SearchScopeSerialization INSTANCE;

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        if (object instanceof ObjectStoreScope) {
            context.writeSchemaType("ObjectStoreScope");
            GlobalIdentity objStore = ((ObjectStoreScope)object).getObjectStore();
            context.writeAttribute("objectStore", objStore.getObjectIdentity());
        } else if (object instanceof MergedScope) {
            MergedScope mscope = (MergedScope)object;
            context.writeSchemaType("MergedScope");
            switch (mscope.getMergeMode().getValue()) {
                case 1: {
                    context.writeAttribute("mergeMode", "Union");
                    break;
                }
                case 0: {
                    context.writeAttribute("mergeMode", "Intersection");
                }
            }
            context.serializeObjectArray("ComponentScope", this, (Object[])mscope.getComponentScope());
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        String type = context.getXsiType();
        if (type.equals("ObjectStoreScope")) {
            String objStore = context.getAttribute("objectStore");
            if (objStore == null) {
                context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "objectStore");
            }
            context.nextElementToken();
            context.checkEndToken();
            return new ObjectStoreScope(new GlobalIdentity("ObjectStore", objStore));
        }
        if (type.equals("MergedScope")) {
            MergeMode mode = (MergeMode)context.deserializeEnumAttribute("mergeMode", false, MAP_MERGE_MODE, MergeMode.UNION);
            context.nextToken();
            List components = context.deserializeObjectList("ComponentScope", this, null);
            context.checkEndToken();
            SearchScope[] scopes = components.toArray(new SearchScope[components.size()]);
            return new MergedScope(scopes, mode);
        }
        context.checkEndToken();
        return null;
    }

    static {
        MAP_MERGE_MODE.put("Union", MergeMode.UNION);
        MAP_MERGE_MODE.put("Intersection", MergeMode.INTERSECTION);
        INSTANCE = new SearchScopeSerialization();
    }
}

