/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.apiimpl.transport.comm.CommResponse;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;

public class CommResponseSerialization
extends Serialization {
    public static final CommResponseSerialization INSTANCE = new CommResponseSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        CommResponse response = (CommResponse)object;
        context.writeAttribute("id", response.getCorrelationId());
        if (response.getValue() instanceof EngineRuntimeException) {
            context.writeSchemaType("CommErrorResponseType");
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, response.getValue());
        } else {
            context.writeSchemaType("CommResponseType");
        }
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        CommResponse response = (CommResponse)object;
        String correlationId = context.getAttribute("id");
        response.setCorrelationId(correlationId);
        String type = context.getXsiType();
        Object value = null;
        if (type.equals("CommErrorResponseType")) {
            context.nextElementToken();
            value = context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
            response.putValue(value);
        }
        return response;
    }
}

