/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.BinaryListImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.BinarySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.io.InputStream;
import java.util.ArrayList;

public class BinaryListSerialization
extends PropertySerialization {
    public static final BinaryListSerialization INSTANCE = new BinaryListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfBinary", context.getOptionalXsdType("base64Binary"), object, context);
    }

    @Override
    protected String toString(Object value) {
        if (value instanceof InputStream) {
            return "XOP stream";
        }
        return Util.toBase64BinaryString((byte[])value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        boolean foundXop = false;
        ArrayList<Object> vals = new ArrayList<Object>();
        while (context.isStartToken("Value")) {
            Object val = BinarySerialization.deserializeBinaryValue(context, this.util);
            vals.add(val);
            if (val instanceof InputStream) {
                foundXop = true;
            }
            context.nextElementToken();
        }
        PropertyBinaryListImpl property = new PropertyBinaryListImpl(call.propertyId, new BinaryListImpl(vals), call.propertyAccess);
        if (foundXop) {
            context.addXopBinaryProperty(property);
        }
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseBase64Binary(jsonVals.getString(i)));
            }
        }
        PropertyBinaryListImpl property = new PropertyBinaryListImpl(call.propertyId, new BinaryListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseBase64Binary(text);
    }
}

