/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.BooleanListImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.util.ArrayList;

public class BooleanListSerialization
extends PropertySerialization {
    public static final BooleanListSerialization INSTANCE = new BooleanListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfBoolean", context.getOptionalXsdType("boolean"), object, context);
    }

    @Override
    protected String toString(Object value) {
        return Util.toBooleanString((Boolean)value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyBooleanListImpl property = new PropertyBooleanListImpl(call.propertyId, new BooleanListImpl(this.readList(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseBoolean(jsonVals.getString(i)));
            }
        }
        PropertyBooleanListImpl property = new PropertyBooleanListImpl(call.propertyId, new BooleanListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseBoolean(text);
    }
}

