/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.Deserializer;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Registry;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.util.Arrays;
import java.util.Comparator;

public class PropertiesSerialization {
    public static final PropertiesSerialization INSTANCE = new PropertiesSerialization();
    private final Util util = Util.INSTANCE;

    public void serialize(EngineObjectImpl object, SerializerContext context) throws Exception {
        PropertyImpl[] properties = (PropertyImpl[])object.getPropertiesImpl().toArray();
        if (context.getShouldSortProperties()) {
            Arrays.sort(properties, new PropComparator());
        }
        PropertySerializerCall call = new PropertySerializerCall(object);
        for (int i = 0; i < properties.length; ++i) {
            PropertyImpl property;
            call.property = property = properties[i];
            context.serializeObject("Property", property.getClass(), (Object)call);
        }
    }

    public void deserialize(PropertyDeserializerCall call, DeserializerContext context) throws Exception {
        PropertiesImpl properties = call.parent.getPropertiesImpl();
        while (true) {
            if (!Util.isStartToken(context.getTokenType())) break;
            PropertyImpl property = (PropertyImpl)context.deserializeObject(context.getXsiType(), (Object)call);
            properties.put(property);
        }
    }

    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        PropertiesImpl properties = call.parent.getPropertiesImpl();
        for (String propName : json.keySet()) {
            Object o = json.get(propName);
            if (!(o instanceof JSONObject)) continue;
            JSONObject jsonProp = (JSONObject)o;
            String type = jsonProp.getString("type");
            Deserializer deserializer = Registry.getInstance("http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/wsdl").getDeserializer(type);
            PropertyImpl property = (PropertyImpl)deserializer.deserializeJson(connection, jsonProp, propName, hasDeltas, call);
            properties.put(property);
        }
        return properties;
    }

    private static class PropComparator
    implements Comparator {
        private PropComparator() {
        }

        public int compare(Object o1, Object o2) {
            PropertyImpl prop1 = (PropertyImpl)o1;
            PropertyImpl prop2 = (PropertyImpl)o2;
            String prop1Name = prop1 != null ? prop1.getPropertyName() : "";
            String prop2Name = prop2 != null ? prop2.getPropertyName() : "";
            return prop1Name.compareTo(prop2Name);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PropComparator;
        }
    }
}

