/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PropertySerialization
extends Serialization {
    protected PropertySerializerCall enter(String typeName, Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = (PropertySerializerCall)object;
        context.writeSchemaType(typeName);
        this.writeAttributes(call, context);
        return call;
    }

    protected void writeAttributes(PropertySerializerCall call, SerializerContext context) throws Exception {
        PropertyImpl property = call.property;
        context.writeAttribute("propertyId", property.getPropertyName());
        if (context.isServerProcessing() && property.isSettable()) {
            context.writeAttribute("settable", "1");
        }
    }

    protected PropertyDeserializerCall enter(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = (PropertyDeserializerCall)object;
        this.readAttributes(call, context);
        context.nextElementToken();
        return call;
    }

    protected void readAttributes(PropertyDeserializerCall call, DeserializerContext context) throws Exception {
        boolean settable;
        call.propertyId = Util.checkNotEmpty("propertyId", Util.emptyAsNull(context.getAttribute("propertyId")));
        call.propertyAccess = context.isServerProcessing() ? (byte)7 : (byte)((settable = Boolean.TRUE.equals(Util.parseBoolean(context.getAttribute("settable")))) ? 7 : 1);
    }

    protected PropertyImpl leave(PropertyImpl property, PropertyDeserializerCall call, DeserializerContext context) throws Exception {
        context.nextElementToken();
        call.propertyId = null;
        call.propertyAccess = 0;
        return property;
    }

    protected void prepare(PropertyDeserializerCall call, String propName, JSONObject json, boolean hasDeltas) {
        boolean settable;
        call.propertyId = propName;
        call.propertyAccess = hasDeltas ? (byte)7 : (byte)((settable = Boolean.TRUE.equals(Util.parseBoolean(json.getString("settable")))) ? 7 : 1);
    }

    protected PropertyImpl respond(PropertyImpl property, PropertyDeserializerCall call) {
        call.propertyId = null;
        call.propertyAccess = 0;
        return property;
    }

    protected String getValueText(DeserializerContext context) throws Exception {
        return context.readElement("Value");
    }

    protected void serializeList(String propertyType, String valueType, Object object, SerializerContext context) throws Exception {
        List list;
        PropertySerializerCall call = this.enter(propertyType, object, context);
        Object value = call.property.getObjectValue();
        List list2 = list = value instanceof List ? (List)value : null;
        if (list != null && list.size() > 0) {
            Util.checkListForNulls(list, call.property.getPropertyName());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                context.writeElement("Value", valueType, this.toString(i.next()));
            }
        }
        context.leaveElement();
    }

    protected String toString(Object value) {
        throw new UnsupportedOperationException(value == null ? "" : value.toString());
    }

    protected List readList(DeserializerContext context) throws Exception {
        String text;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((text = context.readElement("Value")) != null) {
            list.add(this.parseValue(text));
        }
        return list;
    }

    protected Object parseValue(String text) {
        throw new UnsupportedOperationException(text);
    }
}

