/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.stream.Location;
import javax.xml.stream.SerializableLocation;
import javax.xml.stream.ThrowableMethods;

public class XMLStreamException
extends Exception {
    private static final long serialVersionUID = 2018819321811497362L;
    protected Throwable nested;
    protected Location location;

    public XMLStreamException() {
    }

    public XMLStreamException(String string) {
        super(string);
    }

    public XMLStreamException(Throwable throwable) {
        super(throwable == null ? null : throwable.toString());
        this.setNestedException0(throwable);
    }

    public XMLStreamException(String string, Throwable throwable) {
        super(string);
        this.setNestedException0(throwable);
    }

    public XMLStreamException(String string, Location location, Throwable throwable) {
        this(string, throwable);
        this.location = location != null ? new SerializableLocation(location) : null;
    }

    public XMLStreamException(String string, Location location) {
        this(string);
        this.location = location != null ? new SerializableLocation(location) : null;
    }

    public Throwable getNestedException() {
        if (this.nested != null) {
            return this.nested;
        }
        if (ThrowableMethods.j2se14MethodsAvailable()) {
            try {
                Throwable throwable = ThrowableMethods.getCause(this);
                if (throwable != null) {
                    this.nested = throwable;
                }
                return throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Location getLocation() {
        return this.location;
    }

    public void printStackTrace() {
        if (!ThrowableMethods.j2se14MethodsAvailable() && this.nested != null) {
            this.printStackTrace0(new PrintWriter(System.err, true));
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (!ThrowableMethods.j2se14MethodsAvailable() && this.nested != null) {
            this.printStackTrace0(new PrintWriter(printStream));
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (!ThrowableMethods.j2se14MethodsAvailable() && this.nested != null) {
            this.printStackTrace0(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }

    private void printStackTrace0(PrintWriter printWriter) {
        this.nested.printStackTrace(printWriter);
        printWriter.println("------------------------------------------");
        super.printStackTrace(printWriter);
    }

    private void setNestedException0(Throwable throwable) {
        this.nested = throwable;
        if (ThrowableMethods.j2se14MethodsAvailable()) {
            try {
                ThrowableMethods.initCause(this, throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (ThrowableMethods.j2se14MethodsAvailable()) {
            try {
                Throwable throwable = ThrowableMethods.getCause(this);
                if (this.nested == null) {
                    this.nested = throwable;
                } else if (throwable == null) {
                    ThrowableMethods.initCause(this, this.nested);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

